/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ConjureCollections;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.Parameters;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryAttribution;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryCapability;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SerializationProtocol;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlDialect;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlQuery;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.TimeoutInMillis;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types.Branch;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class SqlExecuteRequestV2 {
    private final SqlQuery query;
    private final SqlDialect dialect;
    private final SerializationProtocol serializationProtocol;
    private final Optional<Parameters> parameters;
    private final List<Branch> fallbackBranchIds;
    private final Optional<TimeoutInMillis> timeout;
    private final OptionalInt maxRows;
    private final OptionalInt maxStreams;
    private final Optional<Boolean> disableArrowCompression;
    private final Set<QueryCapability> queryCapabilities;
    private final Optional<QueryAttribution> attribution;
    private final Optional<Boolean> useFurnace;
    private int memoizedHashCode;

    private SqlExecuteRequestV2(SqlQuery query, SqlDialect dialect, SerializationProtocol serializationProtocol, Optional<Parameters> parameters, List<Branch> fallbackBranchIds, Optional<TimeoutInMillis> timeout, OptionalInt maxRows, OptionalInt maxStreams, Optional<Boolean> disableArrowCompression, Set<QueryCapability> queryCapabilities, Optional<QueryAttribution> attribution, Optional<Boolean> useFurnace) {
        SqlExecuteRequestV2.validateFields(query, dialect, serializationProtocol, parameters, fallbackBranchIds, timeout, maxRows, maxStreams, disableArrowCompression, queryCapabilities, attribution, useFurnace);
        this.query = query;
        this.dialect = dialect;
        this.serializationProtocol = serializationProtocol;
        this.parameters = parameters;
        this.fallbackBranchIds = Collections.unmodifiableList(fallbackBranchIds);
        this.timeout = timeout;
        this.maxRows = maxRows;
        this.maxStreams = maxStreams;
        this.disableArrowCompression = disableArrowCompression;
        this.queryCapabilities = Collections.unmodifiableSet(queryCapabilities);
        this.attribution = attribution;
        this.useFurnace = useFurnace;
    }

    @JsonProperty(value="query")
    public SqlQuery getQuery() {
        return this.query;
    }

    @JsonProperty(value="dialect")
    public SqlDialect getDialect() {
        return this.dialect;
    }

    @JsonProperty(value="serializationProtocol")
    public SerializationProtocol getSerializationProtocol() {
        return this.serializationProtocol;
    }

    @JsonProperty(value="parameters")
    public Optional<Parameters> getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="fallbackBranchIds")
    public List<Branch> getFallbackBranchIds() {
        return this.fallbackBranchIds;
    }

    @JsonProperty(value="timeout")
    public Optional<TimeoutInMillis> getTimeout() {
        return this.timeout;
    }

    @JsonProperty(value="maxRows")
    @Safe
    public OptionalInt getMaxRows() {
        return this.maxRows;
    }

    @JsonProperty(value="maxStreams")
    @Safe
    public OptionalInt getMaxStreams() {
        return this.maxStreams;
    }

    @JsonProperty(value="disableArrowCompression")
    @Safe
    public Optional<Boolean> getDisableArrowCompression() {
        return this.disableArrowCompression;
    }

    @JsonProperty(value="queryCapabilities")
    public Set<QueryCapability> getQueryCapabilities() {
        return this.queryCapabilities;
    }

    @JsonProperty(value="attribution")
    public Optional<QueryAttribution> getAttribution() {
        return this.attribution;
    }

    @JsonProperty(value="useFurnace")
    @Safe
    public Optional<Boolean> getUseFurnace() {
        return this.useFurnace;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof SqlExecuteRequestV2 && this.equalTo((SqlExecuteRequestV2)other);
    }

    private boolean equalTo(SqlExecuteRequestV2 other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.query.equals(other.query) && this.dialect.equals(other.dialect) && this.serializationProtocol.equals(other.serializationProtocol) && this.parameters.equals(other.parameters) && this.fallbackBranchIds.equals(other.fallbackBranchIds) && this.timeout.equals(other.timeout) && this.maxRows.equals(other.maxRows) && this.maxStreams.equals(other.maxStreams) && this.disableArrowCompression.equals(other.disableArrowCompression) && this.queryCapabilities.equals(other.queryCapabilities) && this.attribution.equals(other.attribution) && this.useFurnace.equals(other.useFurnace);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.query.hashCode();
            hash = 31 * hash + this.dialect.hashCode();
            hash = 31 * hash + this.serializationProtocol.hashCode();
            hash = 31 * hash + this.parameters.hashCode();
            hash = 31 * hash + this.fallbackBranchIds.hashCode();
            hash = 31 * hash + this.timeout.hashCode();
            hash = 31 * hash + this.maxRows.hashCode();
            hash = 31 * hash + this.maxStreams.hashCode();
            hash = 31 * hash + this.disableArrowCompression.hashCode();
            hash = 31 * hash + this.queryCapabilities.hashCode();
            hash = 31 * hash + this.attribution.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.useFurnace.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "SqlExecuteRequestV2{query: " + String.valueOf(this.query) + ", dialect: " + String.valueOf(this.dialect) + ", serializationProtocol: " + String.valueOf(this.serializationProtocol) + ", parameters: " + String.valueOf(this.parameters) + ", fallbackBranchIds: " + String.valueOf(this.fallbackBranchIds) + ", timeout: " + String.valueOf(this.timeout) + ", maxRows: " + String.valueOf(this.maxRows) + ", maxStreams: " + String.valueOf(this.maxStreams) + ", disableArrowCompression: " + String.valueOf(this.disableArrowCompression) + ", queryCapabilities: " + String.valueOf(this.queryCapabilities) + ", attribution: " + String.valueOf(this.attribution) + ", useFurnace: " + String.valueOf(this.useFurnace) + "}";
    }

    private static void validateFields(SqlQuery query, SqlDialect dialect, SerializationProtocol serializationProtocol, Optional<Parameters> parameters, List<Branch> fallbackBranchIds, Optional<TimeoutInMillis> timeout, OptionalInt maxRows, OptionalInt maxStreams, Optional<Boolean> disableArrowCompression, Set<QueryCapability> queryCapabilities, Optional<QueryAttribution> attribution, Optional<Boolean> useFurnace) {
        List<String> missingFields = null;
        missingFields = SqlExecuteRequestV2.addFieldIfMissing(missingFields, query, "query");
        missingFields = SqlExecuteRequestV2.addFieldIfMissing(missingFields, dialect, "dialect");
        missingFields = SqlExecuteRequestV2.addFieldIfMissing(missingFields, serializationProtocol, "serializationProtocol");
        missingFields = SqlExecuteRequestV2.addFieldIfMissing(missingFields, parameters, "parameters");
        missingFields = SqlExecuteRequestV2.addFieldIfMissing(missingFields, fallbackBranchIds, "fallbackBranchIds");
        missingFields = SqlExecuteRequestV2.addFieldIfMissing(missingFields, timeout, "timeout");
        missingFields = SqlExecuteRequestV2.addFieldIfMissing(missingFields, maxRows, "maxRows");
        missingFields = SqlExecuteRequestV2.addFieldIfMissing(missingFields, maxStreams, "maxStreams");
        missingFields = SqlExecuteRequestV2.addFieldIfMissing(missingFields, disableArrowCompression, "disableArrowCompression");
        missingFields = SqlExecuteRequestV2.addFieldIfMissing(missingFields, queryCapabilities, "queryCapabilities");
        missingFields = SqlExecuteRequestV2.addFieldIfMissing(missingFields, attribution, "attribution");
        if ((missingFields = SqlExecuteRequestV2.addFieldIfMissing(missingFields, useFurnace, "useFurnace")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(12);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static QueryStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        private SqlQuery query;
        private SqlDialect dialect;
        private SerializationProtocol serializationProtocol;
        private Optional<Parameters> parameters = Optional.empty();
        private List<Branch> fallbackBranchIds = ConjureCollections.newList();
        private Optional<TimeoutInMillis> timeout = Optional.empty();
        @Safe
        private OptionalInt maxRows = OptionalInt.empty();
        @Safe
        private OptionalInt maxStreams = OptionalInt.empty();
        private Optional<@Safe Boolean> disableArrowCompression = Optional.empty();
        private Set<QueryCapability> queryCapabilities = ConjureCollections.newSet();
        private Optional<QueryAttribution> attribution = Optional.empty();
        private Optional<@Safe Boolean> useFurnace = Optional.empty();

        private DefaultBuilder() {
        }

        @Override
        public Builder from(SqlExecuteRequestV2 other) {
            this.checkNotBuilt();
            this.query(other.getQuery());
            this.dialect(other.getDialect());
            this.serializationProtocol(other.getSerializationProtocol());
            this.parameters((Optional)other.getParameters());
            this.fallbackBranchIds(other.getFallbackBranchIds());
            this.timeout((Optional)other.getTimeout());
            this.maxRows(other.getMaxRows());
            this.maxStreams(other.getMaxStreams());
            this.disableArrowCompression((Optional)other.getDisableArrowCompression());
            this.queryCapabilities(other.getQueryCapabilities());
            this.attribution((Optional)other.getAttribution());
            this.useFurnace((Optional)other.getUseFurnace());
            return this;
        }

        @Override
        @JsonSetter(value="query")
        public Builder query(@Nonnull SqlQuery query) {
            this.checkNotBuilt();
            this.query = Preconditions.checkNotNull(query, "query cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="dialect")
        public Builder dialect(@Nonnull SqlDialect dialect) {
            this.checkNotBuilt();
            this.dialect = Preconditions.checkNotNull(dialect, "dialect cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="serializationProtocol")
        public Builder serializationProtocol(@Nonnull SerializationProtocol serializationProtocol) {
            this.checkNotBuilt();
            this.serializationProtocol = Preconditions.checkNotNull(serializationProtocol, "serializationProtocol cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="parameters", nulls=Nulls.SKIP)
        public Builder parameters(@Nonnull Optional<Parameters> parameters) {
            this.checkNotBuilt();
            this.parameters = Preconditions.checkNotNull(parameters, "parameters cannot be null");
            return this;
        }

        @Override
        public Builder parameters(@Nonnull Parameters parameters) {
            this.checkNotBuilt();
            this.parameters = Optional.of(Preconditions.checkNotNull(parameters, "parameters cannot be null"));
            return this;
        }

        @Override
        @JsonSetter(value="fallbackBranchIds", nulls=Nulls.SKIP)
        public Builder fallbackBranchIds(@Nonnull Iterable<Branch> fallbackBranchIds) {
            this.checkNotBuilt();
            this.fallbackBranchIds = ConjureCollections.newList(Preconditions.checkNotNull(fallbackBranchIds, "fallbackBranchIds cannot be null"));
            return this;
        }

        @Override
        public Builder addAllFallbackBranchIds(@Nonnull Iterable<Branch> fallbackBranchIds) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.fallbackBranchIds, Preconditions.checkNotNull(fallbackBranchIds, "fallbackBranchIds cannot be null"));
            return this;
        }

        @Override
        public Builder fallbackBranchIds(Branch fallbackBranchIds) {
            this.checkNotBuilt();
            this.fallbackBranchIds.add(fallbackBranchIds);
            return this;
        }

        @Override
        @JsonSetter(value="timeout", nulls=Nulls.SKIP)
        public Builder timeout(@Nonnull Optional<TimeoutInMillis> timeout) {
            this.checkNotBuilt();
            this.timeout = Preconditions.checkNotNull(timeout, "timeout cannot be null");
            return this;
        }

        @Override
        public Builder timeout(@Nonnull TimeoutInMillis timeout) {
            this.checkNotBuilt();
            this.timeout = Optional.of(Preconditions.checkNotNull(timeout, "timeout cannot be null"));
            return this;
        }

        @Override
        @JsonSetter(value="maxRows", nulls=Nulls.SKIP)
        public Builder maxRows(@Nonnull @Safe OptionalInt maxRows) {
            this.checkNotBuilt();
            this.maxRows = Preconditions.checkNotNull(maxRows, "maxRows cannot be null");
            return this;
        }

        @Override
        public Builder maxRows(@Safe int maxRows) {
            this.checkNotBuilt();
            this.maxRows = OptionalInt.of(maxRows);
            return this;
        }

        @Override
        @JsonSetter(value="maxStreams", nulls=Nulls.SKIP)
        public Builder maxStreams(@Nonnull @Safe OptionalInt maxStreams) {
            this.checkNotBuilt();
            this.maxStreams = Preconditions.checkNotNull(maxStreams, "maxStreams cannot be null");
            return this;
        }

        @Override
        public Builder maxStreams(@Safe int maxStreams) {
            this.checkNotBuilt();
            this.maxStreams = OptionalInt.of(maxStreams);
            return this;
        }

        @Override
        @JsonSetter(value="disableArrowCompression", nulls=Nulls.SKIP)
        public Builder disableArrowCompression(@Nonnull Optional<@Safe Boolean> disableArrowCompression) {
            this.checkNotBuilt();
            this.disableArrowCompression = Preconditions.checkNotNull(disableArrowCompression, "disableArrowCompression cannot be null");
            return this;
        }

        @Override
        public Builder disableArrowCompression(@Safe boolean disableArrowCompression) {
            this.checkNotBuilt();
            this.disableArrowCompression = Optional.of(disableArrowCompression);
            return this;
        }

        @Override
        @JsonSetter(value="queryCapabilities", nulls=Nulls.SKIP)
        public Builder queryCapabilities(@Nonnull Iterable<QueryCapability> queryCapabilities) {
            this.checkNotBuilt();
            this.queryCapabilities = ConjureCollections.newSet(Preconditions.checkNotNull(queryCapabilities, "queryCapabilities cannot be null"));
            return this;
        }

        @Override
        public Builder addAllQueryCapabilities(@Nonnull Iterable<QueryCapability> queryCapabilities) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.queryCapabilities, Preconditions.checkNotNull(queryCapabilities, "queryCapabilities cannot be null"));
            return this;
        }

        @Override
        public Builder queryCapabilities(QueryCapability queryCapabilities) {
            this.checkNotBuilt();
            this.queryCapabilities.add(queryCapabilities);
            return this;
        }

        @Override
        @JsonSetter(value="attribution", nulls=Nulls.SKIP)
        public Builder attribution(@Nonnull Optional<QueryAttribution> attribution) {
            this.checkNotBuilt();
            this.attribution = Preconditions.checkNotNull(attribution, "attribution cannot be null");
            return this;
        }

        @Override
        public Builder attribution(@Nonnull QueryAttribution attribution) {
            this.checkNotBuilt();
            this.attribution = Optional.of(Preconditions.checkNotNull(attribution, "attribution cannot be null"));
            return this;
        }

        @Override
        @JsonSetter(value="useFurnace", nulls=Nulls.SKIP)
        public Builder useFurnace(@Nonnull Optional<@Safe Boolean> useFurnace) {
            this.checkNotBuilt();
            this.useFurnace = Preconditions.checkNotNull(useFurnace, "useFurnace cannot be null");
            return this;
        }

        @Override
        public Builder useFurnace(@Safe boolean useFurnace) {
            this.checkNotBuilt();
            this.useFurnace = Optional.of(useFurnace);
            return this;
        }

        @Override
        @CheckReturnValue
        public SqlExecuteRequestV2 build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new SqlExecuteRequestV2(this.query, this.dialect, this.serializationProtocol, this.parameters, this.fallbackBranchIds, this.timeout, this.maxRows, this.maxStreams, this.disableArrowCompression, this.queryCapabilities, this.attribution, this.useFurnace);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends QueryStageBuilder,
    DialectStageBuilder,
    SerializationProtocolStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder query(@Nonnull SqlQuery var1);

        @Override
        public Builder from(SqlExecuteRequestV2 var1);

        @Override
        public Builder dialect(@Nonnull SqlDialect var1);

        @Override
        public Builder serializationProtocol(@Nonnull SerializationProtocol var1);

        @Override
        @CheckReturnValue
        public SqlExecuteRequestV2 build();

        @Override
        public Builder parameters(@Nonnull Optional<Parameters> var1);

        @Override
        public Builder parameters(@Nonnull Parameters var1);

        @Override
        public Builder fallbackBranchIds(@Nonnull Iterable<Branch> var1);

        @Override
        public Builder addAllFallbackBranchIds(@Nonnull Iterable<Branch> var1);

        @Override
        public Builder fallbackBranchIds(Branch var1);

        @Override
        public Builder timeout(@Nonnull Optional<TimeoutInMillis> var1);

        @Override
        public Builder timeout(@Nonnull TimeoutInMillis var1);

        @Override
        public Builder maxRows(@Nonnull @Safe OptionalInt var1);

        @Override
        public Builder maxRows(@Safe int var1);

        @Override
        public Builder maxStreams(@Nonnull @Safe OptionalInt var1);

        @Override
        public Builder maxStreams(@Safe int var1);

        @Override
        public Builder disableArrowCompression(@Nonnull Optional<@Safe Boolean> var1);

        @Override
        public Builder disableArrowCompression(@Safe boolean var1);

        @Override
        public Builder queryCapabilities(@Nonnull Iterable<QueryCapability> var1);

        @Override
        public Builder addAllQueryCapabilities(@Nonnull Iterable<QueryCapability> var1);

        @Override
        public Builder queryCapabilities(QueryCapability var1);

        @Override
        public Builder attribution(@Nonnull Optional<QueryAttribution> var1);

        @Override
        public Builder attribution(@Nonnull QueryAttribution var1);

        @Override
        public Builder useFurnace(@Nonnull Optional<@Safe Boolean> var1);

        @Override
        public Builder useFurnace(@Safe boolean var1);
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public SqlExecuteRequestV2 build();

        public Completed_StageBuilder parameters(@Nonnull Optional<Parameters> var1);

        public Completed_StageBuilder parameters(@Nonnull Parameters var1);

        public Completed_StageBuilder fallbackBranchIds(@Nonnull Iterable<Branch> var1);

        public Completed_StageBuilder addAllFallbackBranchIds(@Nonnull Iterable<Branch> var1);

        public Completed_StageBuilder fallbackBranchIds(Branch var1);

        public Completed_StageBuilder timeout(@Nonnull Optional<TimeoutInMillis> var1);

        public Completed_StageBuilder timeout(@Nonnull TimeoutInMillis var1);

        public Completed_StageBuilder maxRows(@Nonnull @Safe OptionalInt var1);

        public Completed_StageBuilder maxRows(@Safe int var1);

        public Completed_StageBuilder maxStreams(@Nonnull @Safe OptionalInt var1);

        public Completed_StageBuilder maxStreams(@Safe int var1);

        public Completed_StageBuilder disableArrowCompression(@Nonnull Optional<@Safe Boolean> var1);

        public Completed_StageBuilder disableArrowCompression(@Safe boolean var1);

        public Completed_StageBuilder queryCapabilities(@Nonnull Iterable<QueryCapability> var1);

        public Completed_StageBuilder addAllQueryCapabilities(@Nonnull Iterable<QueryCapability> var1);

        public Completed_StageBuilder queryCapabilities(QueryCapability var1);

        public Completed_StageBuilder attribution(@Nonnull Optional<QueryAttribution> var1);

        public Completed_StageBuilder attribution(@Nonnull QueryAttribution var1);

        public Completed_StageBuilder useFurnace(@Nonnull Optional<@Safe Boolean> var1);

        public Completed_StageBuilder useFurnace(@Safe boolean var1);
    }

    public static interface SerializationProtocolStageBuilder {
        public Completed_StageBuilder serializationProtocol(@Nonnull SerializationProtocol var1);
    }

    public static interface DialectStageBuilder {
        public SerializationProtocolStageBuilder dialect(@Nonnull SqlDialect var1);
    }

    public static interface QueryStageBuilder {
        public DialectStageBuilder query(@Nonnull SqlQuery var1);

        public Builder from(SqlExecuteRequestV2 var1);
    }
}

