/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryId;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryStatus;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class SqlExecuteResponse {
    private final QueryId queryId;
    private final QueryStatus status;
    private int memoizedHashCode;

    private SqlExecuteResponse(QueryId queryId, QueryStatus status) {
        SqlExecuteResponse.validateFields(queryId, status);
        this.queryId = queryId;
        this.status = status;
    }

    @JsonProperty(value="queryId")
    public QueryId getQueryId() {
        return this.queryId;
    }

    @JsonProperty(value="status")
    public QueryStatus getStatus() {
        return this.status;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof SqlExecuteResponse && this.equalTo((SqlExecuteResponse)other);
    }

    private boolean equalTo(SqlExecuteResponse other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.queryId.equals(other.queryId) && this.status.equals(other.status);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.queryId.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.status.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "SqlExecuteResponse{queryId: " + String.valueOf(this.queryId) + ", status: " + String.valueOf(this.status) + "}";
    }

    public static SqlExecuteResponse of(QueryId queryId, QueryStatus status) {
        return SqlExecuteResponse.builder().queryId(queryId).status(status).build();
    }

    private static void validateFields(QueryId queryId, QueryStatus status) {
        List<String> missingFields = null;
        missingFields = SqlExecuteResponse.addFieldIfMissing(missingFields, queryId, "queryId");
        if ((missingFields = SqlExecuteResponse.addFieldIfMissing(missingFields, status, "status")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(2);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static QueryIdStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        private QueryId queryId;
        private QueryStatus status;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(SqlExecuteResponse other) {
            this.checkNotBuilt();
            this.queryId(other.getQueryId());
            this.status(other.getStatus());
            return this;
        }

        @Override
        @JsonSetter(value="queryId")
        public Builder queryId(@Nonnull QueryId queryId) {
            this.checkNotBuilt();
            this.queryId = Preconditions.checkNotNull(queryId, "queryId cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public Builder status(@Nonnull QueryStatus status) {
            this.checkNotBuilt();
            this.status = Preconditions.checkNotNull(status, "status cannot be null");
            return this;
        }

        @Override
        @CheckReturnValue
        public SqlExecuteResponse build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new SqlExecuteResponse(this.queryId, this.status);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends QueryIdStageBuilder,
    StatusStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder queryId(@Nonnull QueryId var1);

        @Override
        public Builder from(SqlExecuteResponse var1);

        @Override
        public Builder status(@Nonnull QueryStatus var1);

        @Override
        @CheckReturnValue
        public SqlExecuteResponse build();
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public SqlExecuteResponse build();
    }

    public static interface StatusStageBuilder {
        public Completed_StageBuilder status(@Nonnull QueryStatus var1);
    }

    public static interface QueryIdStageBuilder {
        public StatusStageBuilder queryId(@Nonnull QueryId var1);

        public Builder from(SqlExecuteResponse var1);
    }
}

