/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.DoNotLog;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ConjureCollections;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryInput;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryStatusV2;
import shadow.palantir.driver.com.palantir.ri.ResourceIdentifier;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@DoNotLog
@JsonDeserialize(builder=DefaultBuilder.class)
public final class SqlExecuteResponseV2 {
    private final Set<ResourceIdentifier> inputRids;
    private final Set<QueryInput> inputs;
    private final QueryStatusV2 status;
    private int memoizedHashCode;

    private SqlExecuteResponseV2(Set<ResourceIdentifier> inputRids, Set<QueryInput> inputs, QueryStatusV2 status) {
        SqlExecuteResponseV2.validateFields(inputRids, inputs, status);
        this.inputRids = Collections.unmodifiableSet(inputRids);
        this.inputs = Collections.unmodifiableSet(inputs);
        this.status = status;
    }

    @JsonProperty(value="inputRids")
    @Safe
    @Deprecated
    public Set<ResourceIdentifier> getInputRids() {
        return this.inputRids;
    }

    @JsonProperty(value="inputs")
    public Set<QueryInput> getInputs() {
        return this.inputs;
    }

    @JsonProperty(value="status")
    public QueryStatusV2 getStatus() {
        return this.status;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof SqlExecuteResponseV2 && this.equalTo((SqlExecuteResponseV2)other);
    }

    private boolean equalTo(SqlExecuteResponseV2 other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.inputRids.equals(other.inputRids) && this.inputs.equals(other.inputs) && this.status.equals(other.status);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.inputRids.hashCode();
            hash = 31 * hash + this.inputs.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.status.hashCode());
        }
        return result;
    }

    @DoNotLog
    public String toString() {
        return "SqlExecuteResponseV2{inputRids: " + String.valueOf(this.inputRids) + ", inputs: " + String.valueOf(this.inputs) + ", status: " + String.valueOf(this.status) + "}";
    }

    public static SqlExecuteResponseV2 of(@Safe Set<ResourceIdentifier> inputRids, Set<QueryInput> inputs, QueryStatusV2 status) {
        return SqlExecuteResponseV2.builder().status(status).inputRids(inputRids).inputs(inputs).build();
    }

    private static void validateFields(Set<ResourceIdentifier> inputRids, Set<QueryInput> inputs, QueryStatusV2 status) {
        List<String> missingFields = null;
        missingFields = SqlExecuteResponseV2.addFieldIfMissing(missingFields, inputRids, "inputRids");
        missingFields = SqlExecuteResponseV2.addFieldIfMissing(missingFields, inputs, "inputs");
        if ((missingFields = SqlExecuteResponseV2.addFieldIfMissing(missingFields, status, "status")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(3);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static StatusStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        private Set<@Safe ResourceIdentifier> inputRids = ConjureCollections.newSet();
        private Set<QueryInput> inputs = ConjureCollections.newSet();
        private QueryStatusV2 status;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(SqlExecuteResponseV2 other) {
            this.checkNotBuilt();
            this.inputRids(other.getInputRids());
            this.inputs(other.getInputs());
            this.status(other.getStatus());
            return this;
        }

        @Override
        @Deprecated
        @JsonSetter(value="inputRids", nulls=Nulls.SKIP)
        public Builder inputRids(@Nonnull Iterable<@Safe ResourceIdentifier> inputRids) {
            this.checkNotBuilt();
            this.inputRids = ConjureCollections.newSet(Preconditions.checkNotNull(inputRids, "inputRids cannot be null"));
            return this;
        }

        @Override
        @Deprecated
        public Builder addAllInputRids(@Nonnull Iterable<@Safe ResourceIdentifier> inputRids) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.inputRids, Preconditions.checkNotNull(inputRids, "inputRids cannot be null"));
            return this;
        }

        @Override
        @Deprecated
        public Builder inputRids(@Safe ResourceIdentifier inputRids) {
            this.checkNotBuilt();
            this.inputRids.add(inputRids);
            return this;
        }

        @Override
        @JsonSetter(value="inputs", nulls=Nulls.SKIP)
        public Builder inputs(@Nonnull Iterable<QueryInput> inputs) {
            this.checkNotBuilt();
            this.inputs = ConjureCollections.newSet(Preconditions.checkNotNull(inputs, "inputs cannot be null"));
            return this;
        }

        @Override
        public Builder addAllInputs(@Nonnull Iterable<QueryInput> inputs) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.inputs, Preconditions.checkNotNull(inputs, "inputs cannot be null"));
            return this;
        }

        @Override
        public Builder inputs(QueryInput inputs) {
            this.checkNotBuilt();
            this.inputs.add(inputs);
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public Builder status(@Nonnull QueryStatusV2 status) {
            this.checkNotBuilt();
            this.status = Preconditions.checkNotNull(status, "status cannot be null");
            return this;
        }

        @Override
        @CheckReturnValue
        public SqlExecuteResponseV2 build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new SqlExecuteResponseV2(this.inputRids, this.inputs, this.status);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends StatusStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder status(@Nonnull QueryStatusV2 var1);

        @Override
        public Builder from(SqlExecuteResponseV2 var1);

        @Override
        @CheckReturnValue
        public SqlExecuteResponseV2 build();

        @Override
        @Deprecated
        public Builder inputRids(@Nonnull Iterable<@Safe ResourceIdentifier> var1);

        @Override
        @Deprecated
        public Builder addAllInputRids(@Nonnull Iterable<@Safe ResourceIdentifier> var1);

        @Override
        @Deprecated
        public Builder inputRids(@Safe ResourceIdentifier var1);

        @Override
        public Builder inputs(@Nonnull Iterable<QueryInput> var1);

        @Override
        public Builder addAllInputs(@Nonnull Iterable<QueryInput> var1);

        @Override
        public Builder inputs(QueryInput var1);
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public SqlExecuteResponseV2 build();

        @Deprecated
        public Completed_StageBuilder inputRids(@Nonnull Iterable<@Safe ResourceIdentifier> var1);

        @Deprecated
        public Completed_StageBuilder addAllInputRids(@Nonnull Iterable<@Safe ResourceIdentifier> var1);

        @Deprecated
        public Completed_StageBuilder inputRids(@Safe ResourceIdentifier var1);

        public Completed_StageBuilder inputs(@Nonnull Iterable<QueryInput> var1);

        public Completed_StageBuilder addAllInputs(@Nonnull Iterable<QueryInput> var1);

        public Completed_StageBuilder inputs(QueryInput var1);
    }

    public static interface StatusStageBuilder {
        public Completed_StageBuilder status(@Nonnull QueryStatusV2 var1);

        public Builder from(SqlExecuteResponseV2 var1);
    }
}

