/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types.Branch;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types.DatasetRid;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types.ModelApiName;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class SqlGenerateRequest {
    private final String userInput;
    private final DatasetRid datasetRid;
    private final Branch branchId;
    private final Optional<ModelApiName> modelApiName;
    private int memoizedHashCode;

    private SqlGenerateRequest(String userInput, DatasetRid datasetRid, Branch branchId, Optional<ModelApiName> modelApiName) {
        SqlGenerateRequest.validateFields(userInput, datasetRid, branchId, modelApiName);
        this.userInput = userInput;
        this.datasetRid = datasetRid;
        this.branchId = branchId;
        this.modelApiName = modelApiName;
    }

    @JsonProperty(value="userInput")
    @Unsafe
    public String getUserInput() {
        return this.userInput;
    }

    @JsonProperty(value="datasetRid")
    public DatasetRid getDatasetRid() {
        return this.datasetRid;
    }

    @JsonProperty(value="branchId")
    public Branch getBranchId() {
        return this.branchId;
    }

    @JsonProperty(value="modelApiName")
    public Optional<ModelApiName> getModelApiName() {
        return this.modelApiName;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof SqlGenerateRequest && this.equalTo((SqlGenerateRequest)other);
    }

    private boolean equalTo(SqlGenerateRequest other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.userInput.equals(other.userInput) && this.datasetRid.equals(other.datasetRid) && this.branchId.equals(other.branchId) && this.modelApiName.equals(other.modelApiName);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.userInput.hashCode();
            hash = 31 * hash + this.datasetRid.hashCode();
            hash = 31 * hash + this.branchId.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.modelApiName.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "SqlGenerateRequest{userInput: " + this.userInput + ", datasetRid: " + String.valueOf(this.datasetRid) + ", branchId: " + String.valueOf(this.branchId) + ", modelApiName: " + String.valueOf(this.modelApiName) + "}";
    }

    private static void validateFields(String userInput, DatasetRid datasetRid, Branch branchId, Optional<ModelApiName> modelApiName) {
        List<String> missingFields = null;
        missingFields = SqlGenerateRequest.addFieldIfMissing(missingFields, userInput, "userInput");
        missingFields = SqlGenerateRequest.addFieldIfMissing(missingFields, datasetRid, "datasetRid");
        missingFields = SqlGenerateRequest.addFieldIfMissing(missingFields, branchId, "branchId");
        if ((missingFields = SqlGenerateRequest.addFieldIfMissing(missingFields, modelApiName, "modelApiName")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(4);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static UserInputStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        @Unsafe
        private String userInput;
        private DatasetRid datasetRid;
        private Branch branchId;
        private Optional<ModelApiName> modelApiName = Optional.empty();

        private DefaultBuilder() {
        }

        @Override
        public Builder from(SqlGenerateRequest other) {
            this.checkNotBuilt();
            this.userInput(other.getUserInput());
            this.datasetRid(other.getDatasetRid());
            this.branchId(other.getBranchId());
            this.modelApiName((Optional)other.getModelApiName());
            return this;
        }

        @Override
        @JsonSetter(value="userInput")
        public Builder userInput(@Nonnull @Unsafe String userInput) {
            this.checkNotBuilt();
            this.userInput = Preconditions.checkNotNull(userInput, "userInput cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="datasetRid")
        public Builder datasetRid(@Nonnull DatasetRid datasetRid) {
            this.checkNotBuilt();
            this.datasetRid = Preconditions.checkNotNull(datasetRid, "datasetRid cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="branchId")
        public Builder branchId(@Nonnull Branch branchId) {
            this.checkNotBuilt();
            this.branchId = Preconditions.checkNotNull(branchId, "branchId cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="modelApiName", nulls=Nulls.SKIP)
        public Builder modelApiName(@Nonnull Optional<ModelApiName> modelApiName) {
            this.checkNotBuilt();
            this.modelApiName = Preconditions.checkNotNull(modelApiName, "modelApiName cannot be null");
            return this;
        }

        @Override
        public Builder modelApiName(@Nonnull ModelApiName modelApiName) {
            this.checkNotBuilt();
            this.modelApiName = Optional.of(Preconditions.checkNotNull(modelApiName, "modelApiName cannot be null"));
            return this;
        }

        @Override
        @CheckReturnValue
        public SqlGenerateRequest build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new SqlGenerateRequest(this.userInput, this.datasetRid, this.branchId, this.modelApiName);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends UserInputStageBuilder,
    DatasetRidStageBuilder,
    BranchIdStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder userInput(@Nonnull @Unsafe String var1);

        @Override
        public Builder from(SqlGenerateRequest var1);

        @Override
        public Builder datasetRid(@Nonnull DatasetRid var1);

        @Override
        public Builder branchId(@Nonnull Branch var1);

        @Override
        @CheckReturnValue
        public SqlGenerateRequest build();

        @Override
        public Builder modelApiName(@Nonnull Optional<ModelApiName> var1);

        @Override
        public Builder modelApiName(@Nonnull ModelApiName var1);
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public SqlGenerateRequest build();

        public Completed_StageBuilder modelApiName(@Nonnull Optional<ModelApiName> var1);

        public Completed_StageBuilder modelApiName(@Nonnull ModelApiName var1);
    }

    public static interface BranchIdStageBuilder {
        public Completed_StageBuilder branchId(@Nonnull Branch var1);
    }

    public static interface DatasetRidStageBuilder {
        public BranchIdStageBuilder datasetRid(@Nonnull DatasetRid var1);
    }

    public static interface UserInputStageBuilder {
        public DatasetRidStageBuilder userInput(@Nonnull @Unsafe String var1);

        public Builder from(SqlGenerateRequest var1);
    }
}

