/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlQuery;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class SqlGenerateResponse {
    private final SqlQuery query;

    private SqlGenerateResponse(SqlQuery query) {
        SqlGenerateResponse.validateFields(query);
        this.query = query;
    }

    @JsonProperty(value="query")
    public SqlQuery getQuery() {
        return this.query;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof SqlGenerateResponse && this.equalTo((SqlGenerateResponse)other);
    }

    private boolean equalTo(SqlGenerateResponse other) {
        return this.query.equals(other.query);
    }

    public int hashCode() {
        return this.query.hashCode();
    }

    @Unsafe
    public String toString() {
        return "SqlGenerateResponse{query: " + String.valueOf(this.query) + "}";
    }

    public static SqlGenerateResponse of(SqlQuery query) {
        return SqlGenerateResponse.builder().query(query).build();
    }

    private static void validateFields(SqlQuery query) {
        List<String> missingFields = null;
        if ((missingFields = SqlGenerateResponse.addFieldIfMissing(missingFields, query, "query")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(1);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static QueryStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        private SqlQuery query;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(SqlGenerateResponse other) {
            this.checkNotBuilt();
            this.query(other.getQuery());
            return this;
        }

        @Override
        @JsonSetter(value="query")
        public Builder query(@Nonnull SqlQuery query) {
            this.checkNotBuilt();
            this.query = Preconditions.checkNotNull(query, "query cannot be null");
            return this;
        }

        @Override
        @CheckReturnValue
        public SqlGenerateResponse build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new SqlGenerateResponse(this.query);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends QueryStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder query(@Nonnull SqlQuery var1);

        @Override
        public Builder from(SqlGenerateResponse var1);

        @Override
        @CheckReturnValue
        public SqlGenerateResponse build();
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public SqlGenerateResponse build();
    }

    public static interface QueryStageBuilder {
        public Completed_StageBuilder query(@Nonnull SqlQuery var1);

        public Builder from(SqlGenerateResponse var1);
    }
}

