/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ConjureCollections;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryHistoryItem;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryHistoryPageToken;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=Builder.class)
public final class SqlGetHistoryResponse {
    private final List<QueryHistoryItem> items;
    private final Optional<QueryHistoryPageToken> nextPageToken;
    private int memoizedHashCode;

    private SqlGetHistoryResponse(List<QueryHistoryItem> items, Optional<QueryHistoryPageToken> nextPageToken) {
        SqlGetHistoryResponse.validateFields(items, nextPageToken);
        this.items = Collections.unmodifiableList(items);
        this.nextPageToken = nextPageToken;
    }

    @JsonProperty(value="items")
    public List<QueryHistoryItem> getItems() {
        return this.items;
    }

    @JsonProperty(value="nextPageToken")
    public Optional<QueryHistoryPageToken> getNextPageToken() {
        return this.nextPageToken;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof SqlGetHistoryResponse && this.equalTo((SqlGetHistoryResponse)other);
    }

    private boolean equalTo(SqlGetHistoryResponse other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.items.equals(other.items) && this.nextPageToken.equals(other.nextPageToken);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.items.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.nextPageToken.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "SqlGetHistoryResponse{items: " + String.valueOf(this.items) + ", nextPageToken: " + String.valueOf(this.nextPageToken) + "}";
    }

    public static SqlGetHistoryResponse of(List<QueryHistoryItem> items, QueryHistoryPageToken nextPageToken) {
        return SqlGetHistoryResponse.builder().items(items).nextPageToken(Optional.of(nextPageToken)).build();
    }

    private static void validateFields(List<QueryHistoryItem> items, Optional<QueryHistoryPageToken> nextPageToken) {
        List<String> missingFields = null;
        missingFields = SqlGetHistoryResponse.addFieldIfMissing(missingFields, items, "items");
        if ((missingFields = SqlGetHistoryResponse.addFieldIfMissing(missingFields, nextPageToken, "nextPageToken")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(2);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        private List<QueryHistoryItem> items = ConjureCollections.newList();
        private Optional<QueryHistoryPageToken> nextPageToken = Optional.empty();

        private Builder() {
        }

        public Builder from(SqlGetHistoryResponse other) {
            this.checkNotBuilt();
            this.items(other.getItems());
            this.nextPageToken(other.getNextPageToken());
            return this;
        }

        @JsonSetter(value="items", nulls=Nulls.SKIP)
        public Builder items(@Nonnull Iterable<QueryHistoryItem> items) {
            this.checkNotBuilt();
            this.items = ConjureCollections.newList(Preconditions.checkNotNull(items, "items cannot be null"));
            return this;
        }

        public Builder addAllItems(@Nonnull Iterable<QueryHistoryItem> items) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.items, Preconditions.checkNotNull(items, "items cannot be null"));
            return this;
        }

        public Builder items(QueryHistoryItem items) {
            this.checkNotBuilt();
            this.items.add(items);
            return this;
        }

        @JsonSetter(value="nextPageToken", nulls=Nulls.SKIP)
        public Builder nextPageToken(@Nonnull Optional<QueryHistoryPageToken> nextPageToken) {
            this.checkNotBuilt();
            this.nextPageToken = Preconditions.checkNotNull(nextPageToken, "nextPageToken cannot be null");
            return this;
        }

        public Builder nextPageToken(@Nonnull QueryHistoryPageToken nextPageToken) {
            this.checkNotBuilt();
            this.nextPageToken = Optional.of(Preconditions.checkNotNull(nextPageToken, "nextPageToken cannot be null"));
            return this;
        }

        @CheckReturnValue
        public SqlGetHistoryResponse build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new SqlGetHistoryResponse(this.items, this.nextPageToken);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

