/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryStatus;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class SqlGetStatusResponse {
    private final QueryStatus status;

    private SqlGetStatusResponse(QueryStatus status) {
        SqlGetStatusResponse.validateFields(status);
        this.status = status;
    }

    @JsonProperty(value="status")
    public QueryStatus getStatus() {
        return this.status;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof SqlGetStatusResponse && this.equalTo((SqlGetStatusResponse)other);
    }

    private boolean equalTo(SqlGetStatusResponse other) {
        return this.status.equals(other.status);
    }

    public int hashCode() {
        return this.status.hashCode();
    }

    @Unsafe
    public String toString() {
        return "SqlGetStatusResponse{status: " + String.valueOf(this.status) + "}";
    }

    public static SqlGetStatusResponse of(QueryStatus status) {
        return SqlGetStatusResponse.builder().status(status).build();
    }

    private static void validateFields(QueryStatus status) {
        List<String> missingFields = null;
        if ((missingFields = SqlGetStatusResponse.addFieldIfMissing(missingFields, status, "status")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(1);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static StatusStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        private QueryStatus status;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(SqlGetStatusResponse other) {
            this.checkNotBuilt();
            this.status(other.getStatus());
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public Builder status(@Nonnull QueryStatus status) {
            this.checkNotBuilt();
            this.status = Preconditions.checkNotNull(status, "status cannot be null");
            return this;
        }

        @Override
        @CheckReturnValue
        public SqlGetStatusResponse build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new SqlGetStatusResponse(this.status);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends StatusStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder status(@Nonnull QueryStatus var1);

        @Override
        public Builder from(SqlGetStatusResponse var1);

        @Override
        @CheckReturnValue
        public SqlGetStatusResponse build();
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public SqlGetStatusResponse build();
    }

    public static interface StatusStageBuilder {
        public Completed_StageBuilder status(@Nonnull QueryStatus var1);

        public Builder from(SqlGetStatusResponse var1);
    }
}

