/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.DoNotLog;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryStatusV2;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@DoNotLog
@JsonDeserialize(builder=DefaultBuilder.class)
public final class SqlGetStatusResponseV2 {
    private final QueryStatusV2 status;

    private SqlGetStatusResponseV2(QueryStatusV2 status) {
        SqlGetStatusResponseV2.validateFields(status);
        this.status = status;
    }

    @JsonProperty(value="status")
    public QueryStatusV2 getStatus() {
        return this.status;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof SqlGetStatusResponseV2 && this.equalTo((SqlGetStatusResponseV2)other);
    }

    private boolean equalTo(SqlGetStatusResponseV2 other) {
        return this.status.equals(other.status);
    }

    public int hashCode() {
        return this.status.hashCode();
    }

    @DoNotLog
    public String toString() {
        return "SqlGetStatusResponseV2{status: " + String.valueOf(this.status) + "}";
    }

    public static SqlGetStatusResponseV2 of(QueryStatusV2 status) {
        return SqlGetStatusResponseV2.builder().status(status).build();
    }

    private static void validateFields(QueryStatusV2 status) {
        List<String> missingFields = null;
        if ((missingFields = SqlGetStatusResponseV2.addFieldIfMissing(missingFields, status, "status")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(1);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static StatusStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        private QueryStatusV2 status;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(SqlGetStatusResponseV2 other) {
            this.checkNotBuilt();
            this.status(other.getStatus());
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public Builder status(@Nonnull QueryStatusV2 status) {
            this.checkNotBuilt();
            this.status = Preconditions.checkNotNull(status, "status cannot be null");
            return this;
        }

        @Override
        @CheckReturnValue
        public SqlGetStatusResponseV2 build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new SqlGetStatusResponseV2(this.status);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends StatusStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder status(@Nonnull QueryStatusV2 var1);

        @Override
        public Builder from(SqlGetStatusResponseV2 var1);

        @Override
        @CheckReturnValue
        public SqlGetStatusResponseV2 build();
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public SqlGetStatusResponseV2 build();
    }

    public static interface StatusStageBuilder {
        public Completed_StageBuilder status(@Nonnull QueryStatusV2 var1);

        public Builder from(SqlGetStatusResponseV2 var1);
    }
}

