/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import java.util.Optional;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ClientEndpoint;
import shadow.palantir.driver.com.palantir.dialogue.Channel;
import shadow.palantir.driver.com.palantir.dialogue.ConjureRuntime;
import shadow.palantir.driver.com.palantir.dialogue.Deserializer;
import shadow.palantir.driver.com.palantir.dialogue.DialogueService;
import shadow.palantir.driver.com.palantir.dialogue.DialogueServiceFactory;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannel;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannelFactory;
import shadow.palantir.driver.com.palantir.dialogue.PlainSerDe;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Serializer;
import shadow.palantir.driver.com.palantir.dialogue.TypeMarker;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.DialogueSqlMetadataEndpoints;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetCatalogsPage;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetCatalogsRequest;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetColumnsRequest;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetColumnsResponse;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetForeignKeyRelationsRequest;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetForeignKeyRelationsResponse;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetPrimaryKeysRequest;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetPrimaryKeysResponse;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetSchemasPage;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetSchemasRequest;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetTablesPage;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.GetTablesRequest;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SessionAuthToken;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SessionId;
import shadow.palantir.driver.com.palantir.tokens.auth.AuthHeader;

@DialogueService(value=Factory.class)
public interface SqlMetadataServiceBlocking {
    @ClientEndpoint(method="POST", path="/metadata/catalogs")
    public GetCatalogsPage getCatalogs(AuthHeader var1, GetCatalogsRequest var2);

    @ClientEndpoint(method="POST", path="/metadata/schemas")
    public GetSchemasPage getSchemas(AuthHeader var1, GetSchemasRequest var2);

    @ClientEndpoint(method="POST", path="/metadata/tables")
    public GetTablesPage getTables(AuthHeader var1, GetTablesRequest var2);

    @ClientEndpoint(method="POST", path="/metadata/columns")
    public GetColumnsResponse getColumns(AuthHeader var1, Optional<SessionAuthToken> var2, Optional<SessionId> var3, GetColumnsRequest var4);

    @ClientEndpoint(method="POST", path="/metadata/primary-keys")
    public GetPrimaryKeysResponse getPrimaryKeys(AuthHeader var1, GetPrimaryKeysRequest var2);

    @ClientEndpoint(method="POST", path="/metadata/foreign-key-relations")
    public GetForeignKeyRelationsResponse getForeignKeyRelations(AuthHeader var1, GetForeignKeyRelationsRequest var2);

    public static SqlMetadataServiceBlocking of(final EndpointChannelFactory _endpointChannelFactory, final ConjureRuntime _runtime) {
        return new SqlMetadataServiceBlocking(){
            private final PlainSerDe _plainSerDe;
            private final Serializer<GetCatalogsRequest> getCatalogsSerializer;
            private final EndpointChannel getCatalogsChannel;
            private final Deserializer<GetCatalogsPage> getCatalogsDeserializer;
            private final Serializer<GetSchemasRequest> getSchemasSerializer;
            private final EndpointChannel getSchemasChannel;
            private final Deserializer<GetSchemasPage> getSchemasDeserializer;
            private final Serializer<GetTablesRequest> getTablesSerializer;
            private final EndpointChannel getTablesChannel;
            private final Deserializer<GetTablesPage> getTablesDeserializer;
            private final Serializer<GetColumnsRequest> getColumnsSerializer;
            private final EndpointChannel getColumnsChannel;
            private final Deserializer<GetColumnsResponse> getColumnsDeserializer;
            private final Serializer<GetPrimaryKeysRequest> getPrimaryKeysSerializer;
            private final EndpointChannel getPrimaryKeysChannel;
            private final Deserializer<GetPrimaryKeysResponse> getPrimaryKeysDeserializer;
            private final Serializer<GetForeignKeyRelationsRequest> getForeignKeyRelationsSerializer;
            private final EndpointChannel getForeignKeyRelationsChannel;
            private final Deserializer<GetForeignKeyRelationsResponse> getForeignKeyRelationsDeserializer;
            {
                this._plainSerDe = _runtime.plainSerDe();
                this.getCatalogsSerializer = _runtime.bodySerDe().serializer(new TypeMarker<GetCatalogsRequest>(){});
                this.getCatalogsChannel = _endpointChannelFactory.endpoint(DialogueSqlMetadataEndpoints.getCatalogs);
                this.getCatalogsDeserializer = _runtime.bodySerDe().deserializer(new TypeMarker<GetCatalogsPage>(){});
                this.getSchemasSerializer = _runtime.bodySerDe().serializer(new TypeMarker<GetSchemasRequest>(){});
                this.getSchemasChannel = _endpointChannelFactory.endpoint(DialogueSqlMetadataEndpoints.getSchemas);
                this.getSchemasDeserializer = _runtime.bodySerDe().deserializer(new TypeMarker<GetSchemasPage>(){});
                this.getTablesSerializer = _runtime.bodySerDe().serializer(new TypeMarker<GetTablesRequest>(){});
                this.getTablesChannel = _endpointChannelFactory.endpoint(DialogueSqlMetadataEndpoints.getTables);
                this.getTablesDeserializer = _runtime.bodySerDe().deserializer(new TypeMarker<GetTablesPage>(){});
                this.getColumnsSerializer = _runtime.bodySerDe().serializer(new TypeMarker<GetColumnsRequest>(){});
                this.getColumnsChannel = _endpointChannelFactory.endpoint(DialogueSqlMetadataEndpoints.getColumns);
                this.getColumnsDeserializer = _runtime.bodySerDe().deserializer(new TypeMarker<GetColumnsResponse>(){});
                this.getPrimaryKeysSerializer = _runtime.bodySerDe().serializer(new TypeMarker<GetPrimaryKeysRequest>(){});
                this.getPrimaryKeysChannel = _endpointChannelFactory.endpoint(DialogueSqlMetadataEndpoints.getPrimaryKeys);
                this.getPrimaryKeysDeserializer = _runtime.bodySerDe().deserializer(new TypeMarker<GetPrimaryKeysResponse>(){});
                this.getForeignKeyRelationsSerializer = _runtime.bodySerDe().serializer(new TypeMarker<GetForeignKeyRelationsRequest>(){});
                this.getForeignKeyRelationsChannel = _endpointChannelFactory.endpoint(DialogueSqlMetadataEndpoints.getForeignKeyRelations);
                this.getForeignKeyRelationsDeserializer = _runtime.bodySerDe().deserializer(new TypeMarker<GetForeignKeyRelationsResponse>(){});
            }

            @Override
            public GetCatalogsPage getCatalogs(AuthHeader authHeader, GetCatalogsRequest request) {
                Request.Builder _request = Request.builder();
                _request.putHeaderParams("Authorization", authHeader.toString());
                _request.body(this.getCatalogsSerializer.serialize(request));
                return _runtime.clients().callBlocking(this.getCatalogsChannel, _request.build(), this.getCatalogsDeserializer);
            }

            @Override
            public GetSchemasPage getSchemas(AuthHeader authHeader, GetSchemasRequest request) {
                Request.Builder _request = Request.builder();
                _request.putHeaderParams("Authorization", authHeader.toString());
                _request.body(this.getSchemasSerializer.serialize(request));
                return _runtime.clients().callBlocking(this.getSchemasChannel, _request.build(), this.getSchemasDeserializer);
            }

            @Override
            public GetTablesPage getTables(AuthHeader authHeader, GetTablesRequest request) {
                Request.Builder _request = Request.builder();
                _request.putHeaderParams("Authorization", authHeader.toString());
                _request.body(this.getTablesSerializer.serialize(request));
                return _runtime.clients().callBlocking(this.getTablesChannel, _request.build(), this.getTablesDeserializer);
            }

            @Override
            public GetColumnsResponse getColumns(AuthHeader authHeader, Optional<SessionAuthToken> sessionAuthToken, Optional<SessionId> sessionId, GetColumnsRequest request) {
                Request.Builder _request = Request.builder();
                _request.putHeaderParams("Authorization", authHeader.toString());
                if (sessionAuthToken.isPresent()) {
                    _request.putHeaderParams("Session-Authorization", this._plainSerDe.serializeString(sessionAuthToken.get().get()));
                }
                if (sessionId.isPresent()) {
                    _request.putQueryParams("sessionId", this._plainSerDe.serializeUuid(sessionId.get().get()));
                }
                _request.body(this.getColumnsSerializer.serialize(request));
                return _runtime.clients().callBlocking(this.getColumnsChannel, _request.build(), this.getColumnsDeserializer);
            }

            @Override
            public GetPrimaryKeysResponse getPrimaryKeys(AuthHeader authHeader, GetPrimaryKeysRequest request) {
                Request.Builder _request = Request.builder();
                _request.putHeaderParams("Authorization", authHeader.toString());
                _request.body(this.getPrimaryKeysSerializer.serialize(request));
                return _runtime.clients().callBlocking(this.getPrimaryKeysChannel, _request.build(), this.getPrimaryKeysDeserializer);
            }

            @Override
            public GetForeignKeyRelationsResponse getForeignKeyRelations(AuthHeader authHeader, GetForeignKeyRelationsRequest request) {
                Request.Builder _request = Request.builder();
                _request.putHeaderParams("Authorization", authHeader.toString());
                _request.body(this.getForeignKeyRelationsSerializer.serialize(request));
                return _runtime.clients().callBlocking(this.getForeignKeyRelationsChannel, _request.build(), this.getForeignKeyRelationsDeserializer);
            }

            public String toString() {
                return "SqlMetadataServiceBlocking{_endpointChannelFactory=" + String.valueOf(_endpointChannelFactory) + ", runtime=" + String.valueOf(_runtime) + "}";
            }
        };
    }

    public static SqlMetadataServiceBlocking of(final Channel _channel, final ConjureRuntime _runtime) {
        if (_channel instanceof EndpointChannelFactory) {
            return SqlMetadataServiceBlocking.of((EndpointChannelFactory)((Object)_channel), _runtime);
        }
        return SqlMetadataServiceBlocking.of(new EndpointChannelFactory(){

            @Override
            public EndpointChannel endpoint(Endpoint endpoint) {
                return _runtime.clients().bind(_channel, endpoint);
            }
        }, _runtime);
    }

    public static final class Factory
    implements DialogueServiceFactory<SqlMetadataServiceBlocking> {
        @Override
        public SqlMetadataServiceBlocking create(EndpointChannelFactory endpointChannelFactory, ConjureRuntime runtime) {
            return SqlMetadataServiceBlocking.of(endpointChannelFactory, runtime);
        }
    }
}

