/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Unsafe;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
public final class SqlQuery
implements Comparable<SqlQuery> {
    @Unsafe
    private final String value;

    private SqlQuery(@Nonnull @Unsafe String value) {
        this.value = Preconditions.checkNotNull(value, "value cannot be null");
    }

    @JsonValue
    @Unsafe
    public String get() {
        return this.value;
    }

    @Unsafe
    public String toString() {
        return this.value.toString();
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof SqlQuery && this.equalTo((SqlQuery)other);
    }

    private boolean equalTo(SqlQuery other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(SqlQuery other) {
        return this.value.compareTo(other.get());
    }

    public static SqlQuery valueOf(@Unsafe String value) {
        return SqlQuery.of(value);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static SqlQuery of(@Nonnull @Unsafe String value) {
        return new SqlQuery(value);
    }
}

