/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import java.io.InputStream;
import shadow.palantir.driver.com.google.errorprone.annotations.MustBeClosed;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ClientEndpoint;
import shadow.palantir.driver.com.palantir.dialogue.Channel;
import shadow.palantir.driver.com.palantir.dialogue.ConjureRuntime;
import shadow.palantir.driver.com.palantir.dialogue.Deserializer;
import shadow.palantir.driver.com.palantir.dialogue.DialogueService;
import shadow.palantir.driver.com.palantir.dialogue.DialogueServiceFactory;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannel;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannelFactory;
import shadow.palantir.driver.com.palantir.dialogue.PlainSerDe;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Serializer;
import shadow.palantir.driver.com.palantir.dialogue.TypeMarker;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.DialogueSqlQueryEndpoints;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryId;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlDescribeRequest;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlDescribeResponse;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlExecuteRequest;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlExecuteResponse;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlGetStatusResponse;
import shadow.palantir.driver.com.palantir.tokens.auth.AuthHeader;

@DialogueService(value=Factory.class)
public interface SqlQueryServiceBlocking {
    @ClientEndpoint(method="POST", path="/queries/execute")
    public SqlExecuteResponse execute(AuthHeader var1, SqlExecuteRequest var2);

    @ClientEndpoint(method="GET", path="/queries/{queryId}/status")
    public SqlGetStatusResponse getStatus(AuthHeader var1, QueryId var2);

    @ClientEndpoint(method="GET", path="/queries/{queryId}/results")
    @MustBeClosed
    public InputStream getResults(AuthHeader var1, QueryId var2);

    @ClientEndpoint(method="PUT", path="/queries/{queryId}/cancel")
    public void cancel(AuthHeader var1, QueryId var2);

    @ClientEndpoint(method="POST", path="/queries/describe")
    public SqlDescribeResponse describe(AuthHeader var1, SqlDescribeRequest var2);

    public static SqlQueryServiceBlocking of(final EndpointChannelFactory _endpointChannelFactory, final ConjureRuntime _runtime) {
        return new SqlQueryServiceBlocking(){
            private final PlainSerDe _plainSerDe;
            private final Serializer<SqlExecuteRequest> executeSerializer;
            private final EndpointChannel executeChannel;
            private final Deserializer<SqlExecuteResponse> executeDeserializer;
            private final EndpointChannel getStatusChannel;
            private final Deserializer<SqlGetStatusResponse> getStatusDeserializer;
            private final EndpointChannel getResultsChannel;
            private final EndpointChannel cancelChannel;
            private final Deserializer<Void> cancelDeserializer;
            private final Serializer<SqlDescribeRequest> describeSerializer;
            private final EndpointChannel describeChannel;
            private final Deserializer<SqlDescribeResponse> describeDeserializer;
            {
                this._plainSerDe = _runtime.plainSerDe();
                this.executeSerializer = _runtime.bodySerDe().serializer(new TypeMarker<SqlExecuteRequest>(){});
                this.executeChannel = _endpointChannelFactory.endpoint(DialogueSqlQueryEndpoints.execute);
                this.executeDeserializer = _runtime.bodySerDe().deserializer(new TypeMarker<SqlExecuteResponse>(){});
                this.getStatusChannel = _endpointChannelFactory.endpoint(DialogueSqlQueryEndpoints.getStatus);
                this.getStatusDeserializer = _runtime.bodySerDe().deserializer(new TypeMarker<SqlGetStatusResponse>(){});
                this.getResultsChannel = _endpointChannelFactory.endpoint(DialogueSqlQueryEndpoints.getResults);
                this.cancelChannel = _endpointChannelFactory.endpoint(DialogueSqlQueryEndpoints.cancel);
                this.cancelDeserializer = _runtime.bodySerDe().emptyBodyDeserializer();
                this.describeSerializer = _runtime.bodySerDe().serializer(new TypeMarker<SqlDescribeRequest>(){});
                this.describeChannel = _endpointChannelFactory.endpoint(DialogueSqlQueryEndpoints.describe);
                this.describeDeserializer = _runtime.bodySerDe().deserializer(new TypeMarker<SqlDescribeResponse>(){});
            }

            @Override
            public SqlExecuteResponse execute(AuthHeader authHeader, SqlExecuteRequest request) {
                Request.Builder _request = Request.builder();
                _request.putHeaderParams("Authorization", authHeader.toString());
                _request.body(this.executeSerializer.serialize(request));
                return _runtime.clients().callBlocking(this.executeChannel, _request.build(), this.executeDeserializer);
            }

            @Override
            public SqlGetStatusResponse getStatus(AuthHeader authHeader, QueryId queryId) {
                Request.Builder _request = Request.builder();
                _request.putHeaderParams("Authorization", authHeader.toString());
                _request.putPathParams("queryId", this._plainSerDe.serializeString(queryId.get()));
                return _runtime.clients().callBlocking(this.getStatusChannel, _request.build(), this.getStatusDeserializer);
            }

            @Override
            public InputStream getResults(AuthHeader authHeader, QueryId queryId) {
                Request.Builder _request = Request.builder();
                _request.putHeaderParams("Authorization", authHeader.toString());
                _request.putPathParams("queryId", this._plainSerDe.serializeString(queryId.get()));
                return _runtime.clients().callBlocking(this.getResultsChannel, _request.build(), _runtime.bodySerDe().inputStreamDeserializer());
            }

            @Override
            public void cancel(AuthHeader authHeader, QueryId queryId) {
                Request.Builder _request = Request.builder();
                _request.putHeaderParams("Authorization", authHeader.toString());
                _request.putPathParams("queryId", this._plainSerDe.serializeString(queryId.get()));
                _runtime.clients().callBlocking(this.cancelChannel, _request.build(), this.cancelDeserializer);
            }

            @Override
            public SqlDescribeResponse describe(AuthHeader authHeader, SqlDescribeRequest request) {
                Request.Builder _request = Request.builder();
                _request.putHeaderParams("Authorization", authHeader.toString());
                _request.body(this.describeSerializer.serialize(request));
                return _runtime.clients().callBlocking(this.describeChannel, _request.build(), this.describeDeserializer);
            }

            public String toString() {
                return "SqlQueryServiceBlocking{_endpointChannelFactory=" + String.valueOf(_endpointChannelFactory) + ", runtime=" + String.valueOf(_runtime) + "}";
            }
        };
    }

    public static SqlQueryServiceBlocking of(final Channel _channel, final ConjureRuntime _runtime) {
        if (_channel instanceof EndpointChannelFactory) {
            return SqlQueryServiceBlocking.of((EndpointChannelFactory)((Object)_channel), _runtime);
        }
        return SqlQueryServiceBlocking.of(new EndpointChannelFactory(){

            @Override
            public EndpointChannel endpoint(Endpoint endpoint) {
                return _runtime.clients().bind(_channel, endpoint);
            }
        }, _runtime);
    }

    public static final class Factory
    implements DialogueServiceFactory<SqlQueryServiceBlocking> {
        @Override
        public SqlQueryServiceBlocking create(EndpointChannelFactory endpointChannelFactory, ConjureRuntime runtime) {
            return SqlQueryServiceBlocking.of(endpointChannelFactory, runtime);
        }
    }
}

