/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Safe;
import java.io.InputStream;
import java.util.Optional;
import java.util.OptionalInt;
import shadow.palantir.driver.com.google.errorprone.annotations.MustBeClosed;
import shadow.palantir.driver.com.palantir.conjure.java.lib.SafeLong;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ClientEndpoint;
import shadow.palantir.driver.com.palantir.dialogue.Channel;
import shadow.palantir.driver.com.palantir.dialogue.ConjureRuntime;
import shadow.palantir.driver.com.palantir.dialogue.Deserializer;
import shadow.palantir.driver.com.palantir.dialogue.DialogueService;
import shadow.palantir.driver.com.palantir.dialogue.DialogueServiceFactory;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannel;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannelFactory;
import shadow.palantir.driver.com.palantir.dialogue.PlainSerDe;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Serializer;
import shadow.palantir.driver.com.palantir.dialogue.TypeMarker;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.ApplicationId;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.DialogueSqlQueryServiceV2Endpoints;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryHistoryPageToken;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryIdV2;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SharedQueryId;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlCancelResponseV2;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlCreateSharedQueryRequest;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlExecuteRequestV2;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlExecuteResponseV2;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlGenerateRequest;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlGenerateResponse;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlGetHistoryResponse;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlGetSharedQueryResponse;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlGetStatusResponseV2;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.Ticket;
import shadow.palantir.driver.com.palantir.tokens.auth.AuthHeader;

@DialogueService(value=Factory.class)
public interface SqlQueryServiceV2Blocking {
    @ClientEndpoint(method="POST", path="/v2/queries/execute")
    public SqlExecuteResponseV2 execute(AuthHeader var1, SqlExecuteRequestV2 var2);

    @ClientEndpoint(method="GET", path="/v2/queries/status")
    public SqlGetStatusResponseV2 getStatus(AuthHeader var1, QueryIdV2 var2);

    @ClientEndpoint(method="PUT", path="/v2/queries/cancel")
    public SqlCancelResponseV2 cancel(AuthHeader var1, QueryIdV2 var2);

    @ClientEndpoint(method="POST", path="/v2/queries/stream")
    @MustBeClosed
    public InputStream getStream(AuthHeader var1, @Safe Optional<Boolean> var2, @Safe Optional<SafeLong> var3, @Safe Optional<SafeLong> var4, Ticket var5);

    @ClientEndpoint(method="GET", path="/v2/queries/history")
    public SqlGetHistoryResponse getHistory(AuthHeader var1, ApplicationId var2, @Safe OptionalInt var3, Optional<QueryHistoryPageToken> var4);

    @ClientEndpoint(method="POST", path="/v2/queries/generate")
    public SqlGenerateResponse generate(AuthHeader var1, SqlGenerateRequest var2);

    @ClientEndpoint(method="POST", path="/v2/queries/shares")
    public SharedQueryId createSharedQuery(AuthHeader var1, SqlCreateSharedQueryRequest var2);

    @ClientEndpoint(method="GET", path="/v2/queries/shares/{sharedQueryId}")
    public SqlGetSharedQueryResponse getSharedQuery(AuthHeader var1, SharedQueryId var2);

    public static SqlQueryServiceV2Blocking of(final EndpointChannelFactory _endpointChannelFactory, final ConjureRuntime _runtime) {
        return new SqlQueryServiceV2Blocking(){
            private final PlainSerDe _plainSerDe;
            private final Serializer<SqlExecuteRequestV2> executeSerializer;
            private final EndpointChannel executeChannel;
            private final Deserializer<SqlExecuteResponseV2> executeDeserializer;
            private final EndpointChannel getStatusChannel;
            private final Deserializer<SqlGetStatusResponseV2> getStatusDeserializer;
            private final EndpointChannel cancelChannel;
            private final Deserializer<SqlCancelResponseV2> cancelDeserializer;
            private final Serializer<Ticket> getStreamSerializer;
            private final EndpointChannel getStreamChannel;
            private final EndpointChannel getHistoryChannel;
            private final Deserializer<SqlGetHistoryResponse> getHistoryDeserializer;
            private final Serializer<SqlGenerateRequest> generateSerializer;
            private final EndpointChannel generateChannel;
            private final Deserializer<SqlGenerateResponse> generateDeserializer;
            private final Serializer<SqlCreateSharedQueryRequest> createSharedQuerySerializer;
            private final EndpointChannel createSharedQueryChannel;
            private final Deserializer<SharedQueryId> createSharedQueryDeserializer;
            private final EndpointChannel getSharedQueryChannel;
            private final Deserializer<SqlGetSharedQueryResponse> getSharedQueryDeserializer;
            {
                this._plainSerDe = _runtime.plainSerDe();
                this.executeSerializer = _runtime.bodySerDe().serializer(new TypeMarker<SqlExecuteRequestV2>(){});
                this.executeChannel = _endpointChannelFactory.endpoint(DialogueSqlQueryServiceV2Endpoints.execute);
                this.executeDeserializer = _runtime.bodySerDe().deserializer(new TypeMarker<SqlExecuteResponseV2>(){});
                this.getStatusChannel = _endpointChannelFactory.endpoint(DialogueSqlQueryServiceV2Endpoints.getStatus);
                this.getStatusDeserializer = _runtime.bodySerDe().deserializer(new TypeMarker<SqlGetStatusResponseV2>(){});
                this.cancelChannel = _endpointChannelFactory.endpoint(DialogueSqlQueryServiceV2Endpoints.cancel);
                this.cancelDeserializer = _runtime.bodySerDe().deserializer(new TypeMarker<SqlCancelResponseV2>(){});
                this.getStreamSerializer = _runtime.bodySerDe().serializer(new TypeMarker<Ticket>(){});
                this.getStreamChannel = _endpointChannelFactory.endpoint(DialogueSqlQueryServiceV2Endpoints.getStream);
                this.getHistoryChannel = _endpointChannelFactory.endpoint(DialogueSqlQueryServiceV2Endpoints.getHistory);
                this.getHistoryDeserializer = _runtime.bodySerDe().deserializer(new TypeMarker<SqlGetHistoryResponse>(){});
                this.generateSerializer = _runtime.bodySerDe().serializer(new TypeMarker<SqlGenerateRequest>(){});
                this.generateChannel = _endpointChannelFactory.endpoint(DialogueSqlQueryServiceV2Endpoints.generate);
                this.generateDeserializer = _runtime.bodySerDe().deserializer(new TypeMarker<SqlGenerateResponse>(){});
                this.createSharedQuerySerializer = _runtime.bodySerDe().serializer(new TypeMarker<SqlCreateSharedQueryRequest>(){});
                this.createSharedQueryChannel = _endpointChannelFactory.endpoint(DialogueSqlQueryServiceV2Endpoints.createSharedQuery);
                this.createSharedQueryDeserializer = _runtime.bodySerDe().deserializer(new TypeMarker<SharedQueryId>(){});
                this.getSharedQueryChannel = _endpointChannelFactory.endpoint(DialogueSqlQueryServiceV2Endpoints.getSharedQuery);
                this.getSharedQueryDeserializer = _runtime.bodySerDe().deserializer(new TypeMarker<SqlGetSharedQueryResponse>(){});
            }

            @Override
            public SqlExecuteResponseV2 execute(AuthHeader authHeader, SqlExecuteRequestV2 request) {
                Request.Builder _request = Request.builder();
                _request.putHeaderParams("Authorization", authHeader.toString());
                _request.body(this.executeSerializer.serialize(request));
                return _runtime.clients().callBlocking(this.executeChannel, _request.build(), this.executeDeserializer);
            }

            @Override
            public SqlGetStatusResponseV2 getStatus(AuthHeader authHeader, QueryIdV2 queryId) {
                Request.Builder _request = Request.builder();
                _request.putHeaderParams("Authorization", authHeader.toString());
                _request.putQueryParams("queryId", this._plainSerDe.serializeString(queryId.get()));
                return _runtime.clients().callBlocking(this.getStatusChannel, _request.build(), this.getStatusDeserializer);
            }

            @Override
            public SqlCancelResponseV2 cancel(AuthHeader authHeader, QueryIdV2 queryId) {
                Request.Builder _request = Request.builder();
                _request.putHeaderParams("Authorization", authHeader.toString());
                _request.putQueryParams("queryId", this._plainSerDe.serializeString(queryId.get()));
                return _runtime.clients().callBlocking(this.cancelChannel, _request.build(), this.cancelDeserializer);
            }

            @Override
            public InputStream getStream(AuthHeader authHeader, Optional<Boolean> compress, Optional<SafeLong> rowOffset, Optional<SafeLong> rowLimit, Ticket ticket) {
                Request.Builder _request = Request.builder();
                _request.putHeaderParams("Authorization", authHeader.toString());
                _request.body(this.getStreamSerializer.serialize(ticket));
                if (compress.isPresent()) {
                    _request.putQueryParams("compress", this._plainSerDe.serializeBoolean(compress.get()));
                }
                if (rowOffset.isPresent()) {
                    _request.putQueryParams("rowOffset", this._plainSerDe.serializeSafeLong(rowOffset.get()));
                }
                if (rowLimit.isPresent()) {
                    _request.putQueryParams("rowLimit", this._plainSerDe.serializeSafeLong(rowLimit.get()));
                }
                return _runtime.clients().callBlocking(this.getStreamChannel, _request.build(), _runtime.bodySerDe().inputStreamDeserializer());
            }

            @Override
            public SqlGetHistoryResponse getHistory(AuthHeader authHeader, ApplicationId applicationId, OptionalInt limit, Optional<QueryHistoryPageToken> pageToken) {
                Request.Builder _request = Request.builder();
                _request.putHeaderParams("Authorization", authHeader.toString());
                _request.putQueryParams("applicationId", this._plainSerDe.serializeString(applicationId.get()));
                if (limit.isPresent()) {
                    _request.putQueryParams("limit", this._plainSerDe.serializeInteger(limit.getAsInt()));
                }
                if (pageToken.isPresent()) {
                    _request.putQueryParams("pageToken", this._plainSerDe.serializeString(pageToken.get().get()));
                }
                return _runtime.clients().callBlocking(this.getHistoryChannel, _request.build(), this.getHistoryDeserializer);
            }

            @Override
            public SqlGenerateResponse generate(AuthHeader authHeader, SqlGenerateRequest request) {
                Request.Builder _request = Request.builder();
                _request.putHeaderParams("Authorization", authHeader.toString());
                _request.body(this.generateSerializer.serialize(request));
                return _runtime.clients().callBlocking(this.generateChannel, _request.build(), this.generateDeserializer);
            }

            @Override
            public SharedQueryId createSharedQuery(AuthHeader authHeader, SqlCreateSharedQueryRequest request) {
                Request.Builder _request = Request.builder();
                _request.putHeaderParams("Authorization", authHeader.toString());
                _request.body(this.createSharedQuerySerializer.serialize(request));
                return _runtime.clients().callBlocking(this.createSharedQueryChannel, _request.build(), this.createSharedQueryDeserializer);
            }

            @Override
            public SqlGetSharedQueryResponse getSharedQuery(AuthHeader authHeader, SharedQueryId sharedQueryId) {
                Request.Builder _request = Request.builder();
                _request.putHeaderParams("Authorization", authHeader.toString());
                _request.putPathParams("sharedQueryId", this._plainSerDe.serializeString(sharedQueryId.get()));
                return _runtime.clients().callBlocking(this.getSharedQueryChannel, _request.build(), this.getSharedQueryDeserializer);
            }

            public String toString() {
                return "SqlQueryServiceV2Blocking{_endpointChannelFactory=" + String.valueOf(_endpointChannelFactory) + ", runtime=" + String.valueOf(_runtime) + "}";
            }
        };
    }

    public static SqlQueryServiceV2Blocking of(final Channel _channel, final ConjureRuntime _runtime) {
        if (_channel instanceof EndpointChannelFactory) {
            return SqlQueryServiceV2Blocking.of((EndpointChannelFactory)((Object)_channel), _runtime);
        }
        return SqlQueryServiceV2Blocking.of(new EndpointChannelFactory(){

            @Override
            public EndpointChannel endpoint(Endpoint endpoint) {
                return _runtime.clients().bind(_channel, endpoint);
            }
        }, _runtime);
    }

    public static final class Factory
    implements DialogueServiceFactory<SqlQueryServiceV2Blocking> {
        @Override
        public SqlQueryServiceV2Blocking create(EndpointChannelFactory endpointChannelFactory, ConjureRuntime runtime) {
            return SqlQueryServiceV2Blocking.of(endpointChannelFactory, runtime);
        }
    }
}

