/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ConjureCollections;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.Parameters;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlDialect;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlQuery;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types.Branch;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class SqlSharedQuery {
    private final SqlQuery query;
    private final Optional<Parameters> parameters;
    private final SqlDialect dialect;
    private final List<Branch> fallbackBranchIds;
    private int memoizedHashCode;

    private SqlSharedQuery(SqlQuery query, Optional<Parameters> parameters, SqlDialect dialect, List<Branch> fallbackBranchIds) {
        SqlSharedQuery.validateFields(query, parameters, dialect, fallbackBranchIds);
        this.query = query;
        this.parameters = parameters;
        this.dialect = dialect;
        this.fallbackBranchIds = Collections.unmodifiableList(fallbackBranchIds);
    }

    @JsonProperty(value="query")
    public SqlQuery getQuery() {
        return this.query;
    }

    @JsonProperty(value="parameters")
    public Optional<Parameters> getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="dialect")
    public SqlDialect getDialect() {
        return this.dialect;
    }

    @JsonProperty(value="fallbackBranchIds")
    public List<Branch> getFallbackBranchIds() {
        return this.fallbackBranchIds;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof SqlSharedQuery && this.equalTo((SqlSharedQuery)other);
    }

    private boolean equalTo(SqlSharedQuery other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.query.equals(other.query) && this.parameters.equals(other.parameters) && this.dialect.equals(other.dialect) && this.fallbackBranchIds.equals(other.fallbackBranchIds);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.query.hashCode();
            hash = 31 * hash + this.parameters.hashCode();
            hash = 31 * hash + this.dialect.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.fallbackBranchIds.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "SqlSharedQuery{query: " + String.valueOf(this.query) + ", parameters: " + String.valueOf(this.parameters) + ", dialect: " + String.valueOf(this.dialect) + ", fallbackBranchIds: " + String.valueOf(this.fallbackBranchIds) + "}";
    }

    private static void validateFields(SqlQuery query, Optional<Parameters> parameters, SqlDialect dialect, List<Branch> fallbackBranchIds) {
        List<String> missingFields = null;
        missingFields = SqlSharedQuery.addFieldIfMissing(missingFields, query, "query");
        missingFields = SqlSharedQuery.addFieldIfMissing(missingFields, parameters, "parameters");
        missingFields = SqlSharedQuery.addFieldIfMissing(missingFields, dialect, "dialect");
        if ((missingFields = SqlSharedQuery.addFieldIfMissing(missingFields, fallbackBranchIds, "fallbackBranchIds")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(4);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static QueryStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        private SqlQuery query;
        private Optional<Parameters> parameters = Optional.empty();
        private SqlDialect dialect;
        private List<Branch> fallbackBranchIds = ConjureCollections.newList();

        private DefaultBuilder() {
        }

        @Override
        public Builder from(SqlSharedQuery other) {
            this.checkNotBuilt();
            this.query(other.getQuery());
            this.parameters((Optional)other.getParameters());
            this.dialect(other.getDialect());
            this.fallbackBranchIds(other.getFallbackBranchIds());
            return this;
        }

        @Override
        @JsonSetter(value="query")
        public Builder query(@Nonnull SqlQuery query) {
            this.checkNotBuilt();
            this.query = Preconditions.checkNotNull(query, "query cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="parameters", nulls=Nulls.SKIP)
        public Builder parameters(@Nonnull Optional<Parameters> parameters) {
            this.checkNotBuilt();
            this.parameters = Preconditions.checkNotNull(parameters, "parameters cannot be null");
            return this;
        }

        @Override
        public Builder parameters(@Nonnull Parameters parameters) {
            this.checkNotBuilt();
            this.parameters = Optional.of(Preconditions.checkNotNull(parameters, "parameters cannot be null"));
            return this;
        }

        @Override
        @JsonSetter(value="dialect")
        public Builder dialect(@Nonnull SqlDialect dialect) {
            this.checkNotBuilt();
            this.dialect = Preconditions.checkNotNull(dialect, "dialect cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="fallbackBranchIds", nulls=Nulls.SKIP)
        public Builder fallbackBranchIds(@Nonnull Iterable<Branch> fallbackBranchIds) {
            this.checkNotBuilt();
            this.fallbackBranchIds = ConjureCollections.newList(Preconditions.checkNotNull(fallbackBranchIds, "fallbackBranchIds cannot be null"));
            return this;
        }

        @Override
        public Builder addAllFallbackBranchIds(@Nonnull Iterable<Branch> fallbackBranchIds) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.fallbackBranchIds, Preconditions.checkNotNull(fallbackBranchIds, "fallbackBranchIds cannot be null"));
            return this;
        }

        @Override
        public Builder fallbackBranchIds(Branch fallbackBranchIds) {
            this.checkNotBuilt();
            this.fallbackBranchIds.add(fallbackBranchIds);
            return this;
        }

        @Override
        @CheckReturnValue
        public SqlSharedQuery build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new SqlSharedQuery(this.query, this.parameters, this.dialect, this.fallbackBranchIds);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends QueryStageBuilder,
    DialectStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder query(@Nonnull SqlQuery var1);

        @Override
        public Builder from(SqlSharedQuery var1);

        @Override
        public Builder dialect(@Nonnull SqlDialect var1);

        @Override
        @CheckReturnValue
        public SqlSharedQuery build();

        @Override
        public Builder parameters(@Nonnull Optional<Parameters> var1);

        @Override
        public Builder parameters(@Nonnull Parameters var1);

        @Override
        public Builder fallbackBranchIds(@Nonnull Iterable<Branch> var1);

        @Override
        public Builder addAllFallbackBranchIds(@Nonnull Iterable<Branch> var1);

        @Override
        public Builder fallbackBranchIds(Branch var1);
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public SqlSharedQuery build();

        public Completed_StageBuilder parameters(@Nonnull Optional<Parameters> var1);

        public Completed_StageBuilder parameters(@Nonnull Parameters var1);

        public Completed_StageBuilder fallbackBranchIds(@Nonnull Iterable<Branch> var1);

        public Completed_StageBuilder addAllFallbackBranchIds(@Nonnull Iterable<Branch> var1);

        public Completed_StageBuilder fallbackBranchIds(Branch var1);
    }

    public static interface DialectStageBuilder {
        public Completed_StageBuilder dialect(@Nonnull SqlDialect var1);
    }

    public static interface QueryStageBuilder {
        public DialectStageBuilder query(@Nonnull SqlQuery var1);

        public Builder from(SqlSharedQuery var1);
    }
}

