/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.TableType;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class TableInfo {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final TableType tableType;
    private int memoizedHashCode;

    private TableInfo(String catalogName, String schemaName, String tableName, TableType tableType) {
        TableInfo.validateFields(catalogName, schemaName, tableName, tableType);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.tableType = tableType;
    }

    @JsonProperty(value="catalogName")
    @Unsafe
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty(value="schemaName")
    @Unsafe
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty(value="tableName")
    @Unsafe
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty(value="tableType")
    public TableType getTableType() {
        return this.tableType;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof TableInfo && this.equalTo((TableInfo)other);
    }

    private boolean equalTo(TableInfo other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.catalogName.equals(other.catalogName) && this.schemaName.equals(other.schemaName) && this.tableName.equals(other.tableName) && this.tableType.equals(other.tableType);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.catalogName.hashCode();
            hash = 31 * hash + this.schemaName.hashCode();
            hash = 31 * hash + this.tableName.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.tableType.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "TableInfo{catalogName: " + this.catalogName + ", schemaName: " + this.schemaName + ", tableName: " + this.tableName + ", tableType: " + String.valueOf(this.tableType) + "}";
    }

    private static void validateFields(String catalogName, String schemaName, String tableName, TableType tableType) {
        List<String> missingFields = null;
        missingFields = TableInfo.addFieldIfMissing(missingFields, catalogName, "catalogName");
        missingFields = TableInfo.addFieldIfMissing(missingFields, schemaName, "schemaName");
        missingFields = TableInfo.addFieldIfMissing(missingFields, tableName, "tableName");
        if ((missingFields = TableInfo.addFieldIfMissing(missingFields, tableType, "tableType")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(4);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static CatalogNameStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        @Unsafe
        private String catalogName;
        @Unsafe
        private String schemaName;
        @Unsafe
        private String tableName;
        private TableType tableType;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(TableInfo other) {
            this.checkNotBuilt();
            this.catalogName(other.getCatalogName());
            this.schemaName(other.getSchemaName());
            this.tableName(other.getTableName());
            this.tableType(other.getTableType());
            return this;
        }

        @Override
        @JsonSetter(value="catalogName")
        public Builder catalogName(@Nonnull @Unsafe String catalogName) {
            this.checkNotBuilt();
            this.catalogName = Preconditions.checkNotNull(catalogName, "catalogName cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="schemaName")
        public Builder schemaName(@Nonnull @Unsafe String schemaName) {
            this.checkNotBuilt();
            this.schemaName = Preconditions.checkNotNull(schemaName, "schemaName cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="tableName")
        public Builder tableName(@Nonnull @Unsafe String tableName) {
            this.checkNotBuilt();
            this.tableName = Preconditions.checkNotNull(tableName, "tableName cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="tableType")
        public Builder tableType(@Nonnull TableType tableType) {
            this.checkNotBuilt();
            this.tableType = Preconditions.checkNotNull(tableType, "tableType cannot be null");
            return this;
        }

        @Override
        @CheckReturnValue
        public TableInfo build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new TableInfo(this.catalogName, this.schemaName, this.tableName, this.tableType);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends CatalogNameStageBuilder,
    SchemaNameStageBuilder,
    TableNameStageBuilder,
    TableTypeStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder catalogName(@Nonnull @Unsafe String var1);

        @Override
        public Builder from(TableInfo var1);

        @Override
        public Builder schemaName(@Nonnull @Unsafe String var1);

        @Override
        public Builder tableName(@Nonnull @Unsafe String var1);

        @Override
        public Builder tableType(@Nonnull TableType var1);

        @Override
        @CheckReturnValue
        public TableInfo build();
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public TableInfo build();
    }

    public static interface TableTypeStageBuilder {
        public Completed_StageBuilder tableType(@Nonnull TableType var1);
    }

    public static interface TableNameStageBuilder {
        public TableTypeStageBuilder tableName(@Nonnull @Unsafe String var1);
    }

    public static interface SchemaNameStageBuilder {
        public TableNameStageBuilder schemaName(@Nonnull @Unsafe String var1);
    }

    public static interface CatalogNameStageBuilder {
        public SchemaNameStageBuilder catalogName(@Nonnull @Unsafe String var1);

        public Builder from(TableInfo var1);
    }
}

