/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class TableInfoV2 {
    private final Optional<String> catalogName;
    private final Optional<String> schemaName;
    private final String tableName;
    private int memoizedHashCode;

    private TableInfoV2(Optional<String> catalogName, Optional<String> schemaName, String tableName) {
        TableInfoV2.validateFields(catalogName, schemaName, tableName);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    @JsonProperty(value="catalogName")
    @Unsafe
    public Optional<String> getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty(value="schemaName")
    @Unsafe
    public Optional<String> getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty(value="tableName")
    @Unsafe
    public String getTableName() {
        return this.tableName;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof TableInfoV2 && this.equalTo((TableInfoV2)other);
    }

    private boolean equalTo(TableInfoV2 other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.catalogName.equals(other.catalogName) && this.schemaName.equals(other.schemaName) && this.tableName.equals(other.tableName);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.catalogName.hashCode();
            hash = 31 * hash + this.schemaName.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.tableName.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "TableInfoV2{catalogName: " + String.valueOf(this.catalogName) + ", schemaName: " + String.valueOf(this.schemaName) + ", tableName: " + this.tableName + "}";
    }

    public static TableInfoV2 of(@Unsafe String catalogName, @Unsafe String schemaName, @Unsafe String tableName) {
        return TableInfoV2.builder().tableName(tableName).catalogName(Optional.of(catalogName)).schemaName(Optional.of(schemaName)).build();
    }

    private static void validateFields(Optional<String> catalogName, Optional<String> schemaName, String tableName) {
        List<String> missingFields = null;
        missingFields = TableInfoV2.addFieldIfMissing(missingFields, catalogName, "catalogName");
        missingFields = TableInfoV2.addFieldIfMissing(missingFields, schemaName, "schemaName");
        if ((missingFields = TableInfoV2.addFieldIfMissing(missingFields, tableName, "tableName")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(3);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static TableNameStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        private Optional<@Unsafe String> catalogName = Optional.empty();
        private Optional<@Unsafe String> schemaName = Optional.empty();
        @Unsafe
        private String tableName;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(TableInfoV2 other) {
            this.checkNotBuilt();
            this.catalogName((Optional)other.getCatalogName());
            this.schemaName((Optional)other.getSchemaName());
            this.tableName(other.getTableName());
            return this;
        }

        @Override
        @JsonSetter(value="catalogName", nulls=Nulls.SKIP)
        public Builder catalogName(@Nonnull Optional<@Unsafe String> catalogName) {
            this.checkNotBuilt();
            this.catalogName = Preconditions.checkNotNull(catalogName, "catalogName cannot be null");
            return this;
        }

        @Override
        public Builder catalogName(@Nonnull @Unsafe String catalogName) {
            this.checkNotBuilt();
            this.catalogName = Optional.of(Preconditions.checkNotNull(catalogName, "catalogName cannot be null"));
            return this;
        }

        @Override
        @JsonSetter(value="schemaName", nulls=Nulls.SKIP)
        public Builder schemaName(@Nonnull Optional<@Unsafe String> schemaName) {
            this.checkNotBuilt();
            this.schemaName = Preconditions.checkNotNull(schemaName, "schemaName cannot be null");
            return this;
        }

        @Override
        public Builder schemaName(@Nonnull @Unsafe String schemaName) {
            this.checkNotBuilt();
            this.schemaName = Optional.of(Preconditions.checkNotNull(schemaName, "schemaName cannot be null"));
            return this;
        }

        @Override
        @JsonSetter(value="tableName")
        public Builder tableName(@Nonnull @Unsafe String tableName) {
            this.checkNotBuilt();
            this.tableName = Preconditions.checkNotNull(tableName, "tableName cannot be null");
            return this;
        }

        @Override
        @CheckReturnValue
        public TableInfoV2 build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new TableInfoV2(this.catalogName, this.schemaName, this.tableName);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends TableNameStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder tableName(@Nonnull @Unsafe String var1);

        @Override
        public Builder from(TableInfoV2 var1);

        @Override
        @CheckReturnValue
        public TableInfoV2 build();

        @Override
        public Builder catalogName(@Nonnull Optional<@Unsafe String> var1);

        @Override
        public Builder catalogName(@Nonnull @Unsafe String var1);

        @Override
        public Builder schemaName(@Nonnull Optional<@Unsafe String> var1);

        @Override
        public Builder schemaName(@Nonnull @Unsafe String var1);
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public TableInfoV2 build();

        public Completed_StageBuilder catalogName(@Nonnull Optional<@Unsafe String> var1);

        public Completed_StageBuilder catalogName(@Nonnull @Unsafe String var1);

        public Completed_StageBuilder schemaName(@Nonnull Optional<@Unsafe String> var1);

        public Completed_StageBuilder schemaName(@Nonnull @Unsafe String var1);
    }

    public static interface TableNameStageBuilder {
        public Completed_StageBuilder tableName(@Nonnull @Unsafe String var1);

        public Builder from(TableInfoV2 var1);
    }
}

