/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.google.errorprone.annotations.Immutable;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Safe
@Immutable
public final class TableType {
    public static final TableType TABLE = new TableType(Value.TABLE, "TABLE");
    private static final List<TableType> values = Collections.unmodifiableList(Arrays.asList(TABLE));
    private final Value value;
    private final String string;

    private TableType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value get() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || this.value == Value.UNKNOWN && other instanceof TableType && this.string.equals(((TableType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static TableType valueOf(@Nonnull @Safe String value) {
        String upperCasedValue;
        Preconditions.checkNotNull(value, "value cannot be null");
        switch (upperCasedValue = value.toUpperCase(Locale.ROOT)) {
            case "TABLE": {
                return TABLE;
            }
        }
        return new TableType(Value.UNKNOWN, upperCasedValue);
    }

    public <T> T accept(Visitor<T> visitor) {
        switch (this.value) {
            case TABLE: {
                return visitor.visitTable();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    public static List<TableType> values() {
        return values;
    }

    public static interface Completed_StageVisitorBuilder<T> {
        public Visitor<T> build();
    }

    public static interface UnknownStageVisitorBuilder<T> {
        public Completed_StageVisitorBuilder<T> visitUnknown(@Nonnull Function<@Safe String, T> var1);

        public Completed_StageVisitorBuilder<T> throwOnUnknown();
    }

    public static interface TableStageVisitorBuilder<T> {
        public UnknownStageVisitorBuilder<T> visitTable(@Nonnull Supplier<T> var1);
    }

    private static final class VisitorBuilder<T>
    implements TableStageVisitorBuilder<T>,
    UnknownStageVisitorBuilder<T>,
    Completed_StageVisitorBuilder<T> {
        private Supplier<T> tableVisitor;
        private Function<@Safe String, T> unknownVisitor;

        private VisitorBuilder() {
        }

        @Override
        public UnknownStageVisitorBuilder<T> visitTable(@Nonnull Supplier<T> tableVisitor) {
            Preconditions.checkNotNull(tableVisitor, "tableVisitor cannot be null");
            this.tableVisitor = tableVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> visitUnknown(@Nonnull Function<@Safe String, T> unknownVisitor) {
            Preconditions.checkNotNull(unknownVisitor, "unknownVisitor cannot be null");
            this.unknownVisitor = unknownType -> unknownVisitor.apply((String)unknownType);
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> throwOnUnknown() {
            this.unknownVisitor = unknownType -> {
                throw new SafeIllegalArgumentException("Unknown variant of the 'TableType' union", SafeArg.of("unknownType", unknownType));
            };
            return this;
        }

        @Override
        public Visitor<T> build() {
            final Supplier<T> tableVisitor = this.tableVisitor;
            final Function<@Safe String, T> unknownVisitor = this.unknownVisitor;
            return new Visitor<T>(){

                @Override
                public T visitTable() {
                    return tableVisitor.get();
                }

                @Override
                public T visitUnknown(String unknownType) {
                    return unknownVisitor.apply(unknownType);
                }
            };
        }
    }

    public static interface Visitor<T> {
        public T visitTable();

        public T visitUnknown(String var1);

        public static <T> TableStageVisitorBuilder<T> builder() {
            return new VisitorBuilder();
        }
    }

    public static enum Value {
        TABLE,
        UNKNOWN;

    }
}

