/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.DoNotLog;
import com.palantir.logsafe.Preconditions;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@DoNotLog
public final class Ticket
implements Comparable<Ticket> {
    @DoNotLog
    private final String value;

    private Ticket(@Nonnull @DoNotLog String value) {
        this.value = Preconditions.checkNotNull(value, "value cannot be null");
    }

    @JsonValue
    @DoNotLog
    public String get() {
        return this.value;
    }

    @DoNotLog
    public String toString() {
        return this.value.toString();
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof Ticket && this.equalTo((Ticket)other);
    }

    private boolean equalTo(Ticket other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(Ticket other) {
        return this.value.compareTo(other.get());
    }

    public static Ticket valueOf(@DoNotLog String value) {
        return Ticket.of(value);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static Ticket of(@Nonnull @DoNotLog String value) {
        return new Ticket(value);
    }
}

