/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.DoNotLog;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.lib.SafeLong;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.Ticket;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@DoNotLog
@JsonDeserialize(builder=DefaultBuilder.class)
public final class TicketInfo {
    private final Optional<SafeLong> estimatedSize;
    private final Ticket ticket;
    private int memoizedHashCode;

    private TicketInfo(Optional<SafeLong> estimatedSize, Ticket ticket) {
        TicketInfo.validateFields(estimatedSize, ticket);
        this.estimatedSize = estimatedSize;
        this.ticket = ticket;
    }

    @JsonProperty(value="estimatedSize")
    @Safe
    public Optional<SafeLong> getEstimatedSize() {
        return this.estimatedSize;
    }

    @JsonProperty(value="ticket")
    public Ticket getTicket() {
        return this.ticket;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof TicketInfo && this.equalTo((TicketInfo)other);
    }

    private boolean equalTo(TicketInfo other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.estimatedSize.equals(other.estimatedSize) && this.ticket.equals(other.ticket);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.estimatedSize.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.ticket.hashCode());
        }
        return result;
    }

    @DoNotLog
    public String toString() {
        return "TicketInfo{estimatedSize: " + String.valueOf(this.estimatedSize) + ", ticket: " + String.valueOf(this.ticket) + "}";
    }

    public static TicketInfo of(@Safe SafeLong estimatedSize, Ticket ticket) {
        return TicketInfo.builder().ticket(ticket).estimatedSize(Optional.of(estimatedSize)).build();
    }

    private static void validateFields(Optional<SafeLong> estimatedSize, Ticket ticket) {
        List<String> missingFields = null;
        missingFields = TicketInfo.addFieldIfMissing(missingFields, estimatedSize, "estimatedSize");
        if ((missingFields = TicketInfo.addFieldIfMissing(missingFields, ticket, "ticket")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(2);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static TicketStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        private Optional<@Safe SafeLong> estimatedSize = Optional.empty();
        private Ticket ticket;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(TicketInfo other) {
            this.checkNotBuilt();
            this.estimatedSize((Optional)other.getEstimatedSize());
            this.ticket(other.getTicket());
            return this;
        }

        @Override
        @JsonSetter(value="estimatedSize", nulls=Nulls.SKIP)
        public Builder estimatedSize(@Nonnull Optional<@Safe SafeLong> estimatedSize) {
            this.checkNotBuilt();
            this.estimatedSize = Preconditions.checkNotNull(estimatedSize, "estimatedSize cannot be null");
            return this;
        }

        @Override
        public Builder estimatedSize(@Nonnull @Safe SafeLong estimatedSize) {
            this.checkNotBuilt();
            this.estimatedSize = Optional.of(Preconditions.checkNotNull(estimatedSize, "estimatedSize cannot be null"));
            return this;
        }

        @Override
        @JsonSetter(value="ticket")
        public Builder ticket(@Nonnull Ticket ticket) {
            this.checkNotBuilt();
            this.ticket = Preconditions.checkNotNull(ticket, "ticket cannot be null");
            return this;
        }

        @Override
        @CheckReturnValue
        public TicketInfo build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new TicketInfo(this.estimatedSize, this.ticket);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends TicketStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder ticket(@Nonnull Ticket var1);

        @Override
        public Builder from(TicketInfo var1);

        @Override
        @CheckReturnValue
        public TicketInfo build();

        @Override
        public Builder estimatedSize(@Nonnull Optional<@Safe SafeLong> var1);

        @Override
        public Builder estimatedSize(@Nonnull @Safe SafeLong var1);
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public TicketInfo build();

        public Completed_StageBuilder estimatedSize(@Nonnull Optional<@Safe SafeLong> var1);

        public Completed_StageBuilder estimatedSize(@Nonnull @Safe SafeLong var1);
    }

    public static interface TicketStageBuilder {
        public Completed_StageBuilder ticket(@Nonnull Ticket var1);

        public Builder from(TicketInfo var1);
    }
}

