/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.errors;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.UnsafeArg;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.ErrorType;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.RemoteException;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.ServiceException;
import shadow.palantir.driver.com.palantir.conjure.java.lib.SafeLong;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.JobId;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryCapability;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryId;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SessionId;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SharedQueryId;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlDialect;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.StatementId;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.StreamId;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types.DatasetRid;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types.StartTransactionRid;
import shadow.palantir.driver.com.palantir.ri.ResourceIdentifier;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.org.jetbrains.annotations.Contract;

public final class FoundrySqlServerErrors {
    public static final ErrorType AMBIGUOUS_ONTOLOGY_API_NAME = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:AmbiguousOntologyApiName");
    public static final ErrorType CONTAINS_NAMED_AND_UNNAMED_PARAMETERS = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:ContainsNamedAndUnnamedParameters");
    public static final ErrorType CONTAINS_TABULAR_AND_ONTOLOGY_INPUTS = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:ContainsTabularAndOntologyInputs");
    public static final ErrorType COULD_NOT_EXECUTE_STATEMENT = ErrorType.create(ErrorType.Code.CUSTOM_SERVER, "FoundrySqlServer:CouldNotExecuteStatement");
    public static final ErrorType COULD_NOT_PARSE_QUERY = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:CouldNotParseQuery");
    public static final ErrorType DUPLICATE_LINKED_OBJECT_API_NAMES = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:DuplicateLinkedObjectApiNames");
    public static final ErrorType ENTITY_QUERYABLE_SOURCE_NOT_FOUND = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:EntityQueryableSourceNotFound");
    public static final ErrorType INVALID_DATASET_CANNOT_ACCESS = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:InvalidDatasetCannotAccess");
    public static final ErrorType INVALID_DATASET_EMPTY_VIEW = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:InvalidDatasetEmptyView");
    public static final ErrorType INVALID_DATASET_NO_SCHEMA = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:InvalidDatasetNoSchema");
    public static final ErrorType INVALID_DATASET_PATH_NOT_FOUND = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:InvalidDatasetPathNotFound");
    public static final ErrorType INVALID_IDENTIFIER_NOT_FOUND = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:InvalidIdentifierNotFound");
    public static final ErrorType INVALID_PAGE_TOKEN = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:InvalidPageToken");
    public static final ErrorType INVALID_QUERY_STREAM = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:InvalidQueryStream");
    public static final ErrorType INVALID_SESSION_AUTH_TOKEN_FOR_SESSION = ErrorType.create(ErrorType.Code.PERMISSION_DENIED, "FoundrySqlServer:InvalidSessionAuthTokenForSession");
    public static final ErrorType INVALID_SESSION_AUTH_TOKEN_FOR_STATEMENT = ErrorType.create(ErrorType.Code.PERMISSION_DENIED, "FoundrySqlServer:InvalidSessionAuthTokenForStatement");
    public static final ErrorType INVALID_STREAM_OFFSET = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:InvalidStreamOffset");
    public static final ErrorType INVALID_TICKET = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:InvalidTicket");
    public static final ErrorType INVALID_USER_ID_FOR_SESSION = ErrorType.create(ErrorType.Code.PERMISSION_DENIED, "FoundrySqlServer:InvalidUserIdForSession");
    public static final ErrorType INVALID_USER_ID_FOR_STATEMENT = ErrorType.create(ErrorType.Code.PERMISSION_DENIED, "FoundrySqlServer:InvalidUserIdForStatement");
    public static final ErrorType JOB_NOT_FOUND = ErrorType.create(ErrorType.Code.INTERNAL, "FoundrySqlServer:JobNotFound");
    public static final ErrorType LINK_TYPES_UNSUPPORTED = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:LinkTypesUnsupported");
    public static final ErrorType LLM_GENERATION_FAILED = ErrorType.create(ErrorType.Code.CUSTOM_SERVER, "FoundrySqlServer:LlmGenerationFailed");
    public static final ErrorType MATERIALIZATION_MISSING_PROPERTIES = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:MaterializationMissingProperties");
    public static final ErrorType NOT_AUTHORIZED = ErrorType.create(ErrorType.Code.PERMISSION_DENIED, "FoundrySqlServer:NotAuthorized");
    public static final ErrorType NOT_AUTHORIZED_TO_READ_INPUTS = ErrorType.create(ErrorType.Code.PERMISSION_DENIED, "FoundrySqlServer:NotAuthorizedToReadInputs");
    public static final ErrorType ONTOLOGY_NOT_FOUND = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:OntologyNotFound");
    public static final ErrorType ONTOLOGY_SQL_UNSUPPORTED = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:OntologySqlUnsupported");
    public static final ErrorType PARAMETER_VALUE_NOT_FOUND = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:ParameterValueNotFound");
    public static final ErrorType PARAMETERS_NOT_FOUND = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:ParametersNotFound");
    public static final ErrorType QUERY_ABORTED = ErrorType.create(ErrorType.Code.INTERNAL, "FoundrySqlServer:QueryAborted");
    public static final ErrorType QUERY_CAPABILITIES_NOT_SUPPORTED = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:QueryCapabilitiesNotSupported");
    public static final ErrorType QUERY_FAILED = ErrorType.create(ErrorType.Code.INTERNAL, "FoundrySqlServer:QueryFailed");
    public static final ErrorType QUERY_INVALID = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:QueryInvalid");
    public static final ErrorType QUERY_TIMEOUT = ErrorType.create(ErrorType.Code.TIMEOUT, "FoundrySqlServer:QueryTimeout");
    public static final ErrorType QUERY_WRITE_TIMEOUT = ErrorType.create(ErrorType.Code.TIMEOUT, "FoundrySqlServer:QueryWriteTimeout");
    public static final ErrorType SESSION_IS_ALREADY_CLOSED = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:SessionIsAlreadyClosed");
    public static final ErrorType SESSION_IS_NOT_OPEN = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:SessionIsNotOpen");
    public static final ErrorType SESSION_NOT_FOUND = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:SessionNotFound");
    public static final ErrorType SHARED_QUERY_NOT_FOUND = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:SharedQueryNotFound");
    public static final ErrorType STATEMENT_IS_NOT_IN_EXPECTED_STATE = ErrorType.create(ErrorType.Code.CUSTOM_SERVER, "FoundrySqlServer:StatementIsNotInExpectedState");
    public static final ErrorType STATEMENT_NOT_FOUND = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:StatementNotFound");
    public static final ErrorType TOO_MANY_ROWS = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:TooManyRows");
    public static final ErrorType UNKNOWN_UNION_TYPE = ErrorType.create(ErrorType.Code.CUSTOM_SERVER, "FoundrySqlServer:UnknownUnionType");
    public static final ErrorType UNSUPPORTED_CSV_COLUMNS = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:UnsupportedCsvColumns");
    public static final ErrorType UNSUPPORTED_DRIVER_VERSION = ErrorType.create(ErrorType.Code.INVALID_ARGUMENT, "FoundrySqlServer:UnsupportedDriverVersion");

    private FoundrySqlServerErrors() {
    }

    public static ServiceException ambiguousOntologyApiName(Set<@Safe ResourceIdentifier> ontologyRids, @Unsafe String ontologyApiName, @Unsafe String userFriendlyMessage) {
        return new ServiceException(AMBIGUOUS_ONTOLOGY_API_NAME, SafeArg.of("ontologyRids", ontologyRids), UnsafeArg.of("ontologyApiName", ontologyApiName), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException ambiguousOntologyApiName(@Nullable Throwable cause, Set<@Safe ResourceIdentifier> ontologyRids, @Unsafe String ontologyApiName, @Unsafe String userFriendlyMessage) {
        return new ServiceException(AMBIGUOUS_ONTOLOGY_API_NAME, cause, SafeArg.of("ontologyRids", ontologyRids), UnsafeArg.of("ontologyApiName", ontologyApiName), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException containsNamedAndUnnamedParameters(@Unsafe String userFriendlyMessage) {
        return new ServiceException(CONTAINS_NAMED_AND_UNNAMED_PARAMETERS, UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException containsNamedAndUnnamedParameters(@Nullable Throwable cause, @Unsafe String userFriendlyMessage) {
        return new ServiceException(CONTAINS_NAMED_AND_UNNAMED_PARAMETERS, cause, UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException containsTabularAndOntologyInputs(Set<@Safe ResourceIdentifier> inputRids, @Unsafe String userFriendlyMessage) {
        return new ServiceException(CONTAINS_TABULAR_AND_ONTOLOGY_INPUTS, SafeArg.of("inputRids", inputRids), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException containsTabularAndOntologyInputs(@Nullable Throwable cause, Set<@Safe ResourceIdentifier> inputRids, @Unsafe String userFriendlyMessage) {
        return new ServiceException(CONTAINS_TABULAR_AND_ONTOLOGY_INPUTS, cause, SafeArg.of("inputRids", inputRids), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException couldNotExecuteStatement(@Safe StatementId statementId, @Unsafe String userFriendlyMessage) {
        return new ServiceException(COULD_NOT_EXECUTE_STATEMENT, SafeArg.of("statementId", statementId), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException couldNotExecuteStatement(@Nullable Throwable cause, @Safe StatementId statementId, @Unsafe String userFriendlyMessage) {
        return new ServiceException(COULD_NOT_EXECUTE_STATEMENT, cause, SafeArg.of("statementId", statementId), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException couldNotParseQuery(@Safe SessionId sessionId, @Safe SqlDialect sqlDialect, @Unsafe String userFriendlyMessage) {
        return new ServiceException(COULD_NOT_PARSE_QUERY, SafeArg.of("sessionId", sessionId), SafeArg.of("sqlDialect", sqlDialect), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException couldNotParseQuery(@Nullable Throwable cause, @Safe SessionId sessionId, @Safe SqlDialect sqlDialect, @Unsafe String userFriendlyMessage) {
        return new ServiceException(COULD_NOT_PARSE_QUERY, cause, SafeArg.of("sessionId", sessionId), SafeArg.of("sqlDialect", sqlDialect), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException duplicateLinkedObjectApiNames(@Safe ResourceIdentifier linkTypeRid, List<@Unsafe String> duplicateApiNames, @Unsafe String userFriendlyMessage) {
        return new ServiceException(DUPLICATE_LINKED_OBJECT_API_NAMES, SafeArg.of("linkTypeRid", linkTypeRid), UnsafeArg.of("duplicateApiNames", duplicateApiNames), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException duplicateLinkedObjectApiNames(@Nullable Throwable cause, @Safe ResourceIdentifier linkTypeRid, List<@Unsafe String> duplicateApiNames, @Unsafe String userFriendlyMessage) {
        return new ServiceException(DUPLICATE_LINKED_OBJECT_API_NAMES, cause, SafeArg.of("linkTypeRid", linkTypeRid), UnsafeArg.of("duplicateApiNames", duplicateApiNames), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException entityQueryableSourceNotFound(@Safe ResourceIdentifier ontologyEntityRid, @Unsafe String userFriendlyMessage) {
        return new ServiceException(ENTITY_QUERYABLE_SOURCE_NOT_FOUND, SafeArg.of("ontologyEntityRid", ontologyEntityRid), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException entityQueryableSourceNotFound(@Nullable Throwable cause, @Safe ResourceIdentifier ontologyEntityRid, @Unsafe String userFriendlyMessage) {
        return new ServiceException(ENTITY_QUERYABLE_SOURCE_NOT_FOUND, cause, SafeArg.of("ontologyEntityRid", ontologyEntityRid), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException invalidDatasetCannotAccess(@Safe DatasetRid datasetRid, @Unsafe String userFriendlyMessage) {
        return new ServiceException(INVALID_DATASET_CANNOT_ACCESS, SafeArg.of("datasetRid", datasetRid), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException invalidDatasetCannotAccess(@Nullable Throwable cause, @Safe DatasetRid datasetRid, @Unsafe String userFriendlyMessage) {
        return new ServiceException(INVALID_DATASET_CANNOT_ACCESS, cause, SafeArg.of("datasetRid", datasetRid), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException invalidDatasetEmptyView(@Safe DatasetRid datasetRid, Optional<@Safe StartTransactionRid> startTransactionRid, @Unsafe String userFriendlyMessage, @Unsafe String endRef) {
        return new ServiceException(INVALID_DATASET_EMPTY_VIEW, SafeArg.of("datasetRid", datasetRid), SafeArg.of("startTransactionRid", startTransactionRid), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage), UnsafeArg.of("endRef", endRef));
    }

    public static ServiceException invalidDatasetEmptyView(@Nullable Throwable cause, @Safe DatasetRid datasetRid, Optional<@Safe StartTransactionRid> startTransactionRid, @Unsafe String userFriendlyMessage, @Unsafe String endRef) {
        return new ServiceException(INVALID_DATASET_EMPTY_VIEW, cause, SafeArg.of("datasetRid", datasetRid), SafeArg.of("startTransactionRid", startTransactionRid), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage), UnsafeArg.of("endRef", endRef));
    }

    public static ServiceException invalidDatasetNoSchema(@Safe DatasetRid datasetRid, @Unsafe String userFriendlyMessage) {
        return new ServiceException(INVALID_DATASET_NO_SCHEMA, SafeArg.of("datasetRid", datasetRid), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException invalidDatasetNoSchema(@Nullable Throwable cause, @Safe DatasetRid datasetRid, @Unsafe String userFriendlyMessage) {
        return new ServiceException(INVALID_DATASET_NO_SCHEMA, cause, SafeArg.of("datasetRid", datasetRid), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException invalidDatasetPathNotFound(@Unsafe String path, @Unsafe String userFriendlyMessage) {
        return new ServiceException(INVALID_DATASET_PATH_NOT_FOUND, UnsafeArg.of("path", path), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException invalidDatasetPathNotFound(@Nullable Throwable cause, @Unsafe String path, @Unsafe String userFriendlyMessage) {
        return new ServiceException(INVALID_DATASET_PATH_NOT_FOUND, cause, UnsafeArg.of("path", path), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException invalidIdentifierNotFound(@Unsafe String identifier, @Unsafe String userFriendlyMessage) {
        return new ServiceException(INVALID_IDENTIFIER_NOT_FOUND, UnsafeArg.of("identifier", identifier), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException invalidIdentifierNotFound(@Nullable Throwable cause, @Unsafe String identifier, @Unsafe String userFriendlyMessage) {
        return new ServiceException(INVALID_IDENTIFIER_NOT_FOUND, cause, UnsafeArg.of("identifier", identifier), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException invalidPageToken() {
        return new ServiceException(INVALID_PAGE_TOKEN, new Arg[0]);
    }

    public static ServiceException invalidPageToken(@Nullable Throwable cause) {
        return new ServiceException(INVALID_PAGE_TOKEN, cause, new Arg[0]);
    }

    public static ServiceException invalidQueryStream(@Safe QueryId queryId, @Safe StreamId streamId) {
        return new ServiceException(INVALID_QUERY_STREAM, SafeArg.of("queryId", queryId), SafeArg.of("streamId", streamId));
    }

    public static ServiceException invalidQueryStream(@Nullable Throwable cause, @Safe QueryId queryId, @Safe StreamId streamId) {
        return new ServiceException(INVALID_QUERY_STREAM, cause, SafeArg.of("queryId", queryId), SafeArg.of("streamId", streamId));
    }

    public static ServiceException invalidSessionAuthTokenForSession(@Safe SessionId sessionId) {
        return new ServiceException(INVALID_SESSION_AUTH_TOKEN_FOR_SESSION, SafeArg.of("sessionId", sessionId));
    }

    public static ServiceException invalidSessionAuthTokenForSession(@Nullable Throwable cause, @Safe SessionId sessionId) {
        return new ServiceException(INVALID_SESSION_AUTH_TOKEN_FOR_SESSION, cause, SafeArg.of("sessionId", sessionId));
    }

    public static ServiceException invalidSessionAuthTokenForStatement(@Safe StatementId statementId) {
        return new ServiceException(INVALID_SESSION_AUTH_TOKEN_FOR_STATEMENT, SafeArg.of("statementId", statementId));
    }

    public static ServiceException invalidSessionAuthTokenForStatement(@Nullable Throwable cause, @Safe StatementId statementId) {
        return new ServiceException(INVALID_SESSION_AUTH_TOKEN_FOR_STATEMENT, cause, SafeArg.of("statementId", statementId));
    }

    public static ServiceException invalidStreamOffset(@Safe SafeLong bufferEnd, @Safe SafeLong bufferStart, @Safe SafeLong currentOffset, @Safe SafeLong requestedOffset) {
        return new ServiceException(INVALID_STREAM_OFFSET, SafeArg.of("bufferEnd", bufferEnd), SafeArg.of("bufferStart", bufferStart), SafeArg.of("currentOffset", currentOffset), SafeArg.of("requestedOffset", requestedOffset));
    }

    public static ServiceException invalidStreamOffset(@Nullable Throwable cause, @Safe SafeLong bufferEnd, @Safe SafeLong bufferStart, @Safe SafeLong currentOffset, @Safe SafeLong requestedOffset) {
        return new ServiceException(INVALID_STREAM_OFFSET, cause, SafeArg.of("bufferEnd", bufferEnd), SafeArg.of("bufferStart", bufferStart), SafeArg.of("currentOffset", currentOffset), SafeArg.of("requestedOffset", requestedOffset));
    }

    public static ServiceException invalidTicket() {
        return new ServiceException(INVALID_TICKET, new Arg[0]);
    }

    public static ServiceException invalidTicket(@Nullable Throwable cause) {
        return new ServiceException(INVALID_TICKET, cause, new Arg[0]);
    }

    public static ServiceException invalidUserIdForSession(@Safe SessionId sessionId) {
        return new ServiceException(INVALID_USER_ID_FOR_SESSION, SafeArg.of("sessionId", sessionId));
    }

    public static ServiceException invalidUserIdForSession(@Nullable Throwable cause, @Safe SessionId sessionId) {
        return new ServiceException(INVALID_USER_ID_FOR_SESSION, cause, SafeArg.of("sessionId", sessionId));
    }

    public static ServiceException invalidUserIdForStatement(@Safe StatementId statementId) {
        return new ServiceException(INVALID_USER_ID_FOR_STATEMENT, SafeArg.of("statementId", statementId));
    }

    public static ServiceException invalidUserIdForStatement(@Nullable Throwable cause, @Safe StatementId statementId) {
        return new ServiceException(INVALID_USER_ID_FOR_STATEMENT, cause, SafeArg.of("statementId", statementId));
    }

    public static ServiceException jobNotFound(@Safe JobId jobId) {
        return new ServiceException(JOB_NOT_FOUND, SafeArg.of("jobId", jobId));
    }

    public static ServiceException jobNotFound(@Nullable Throwable cause, @Safe JobId jobId) {
        return new ServiceException(JOB_NOT_FOUND, cause, SafeArg.of("jobId", jobId));
    }

    public static ServiceException linkTypesUnsupported(@Safe ResourceIdentifier rid, @Unsafe String userFriendlyMessage) {
        return new ServiceException(LINK_TYPES_UNSUPPORTED, SafeArg.of("rid", rid), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException linkTypesUnsupported(@Nullable Throwable cause, @Safe ResourceIdentifier rid, @Unsafe String userFriendlyMessage) {
        return new ServiceException(LINK_TYPES_UNSUPPORTED, cause, SafeArg.of("rid", rid), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException llmGenerationFailed(Optional<@Unsafe String> userInput, Optional<@Unsafe String> generatedOutput, @Unsafe String userFriendlyMessage) {
        return new ServiceException(LLM_GENERATION_FAILED, UnsafeArg.of("userInput", userInput), UnsafeArg.of("generatedOutput", generatedOutput), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException llmGenerationFailed(@Nullable Throwable cause, Optional<@Unsafe String> userInput, Optional<@Unsafe String> generatedOutput, @Unsafe String userFriendlyMessage) {
        return new ServiceException(LLM_GENERATION_FAILED, cause, UnsafeArg.of("userInput", userInput), UnsafeArg.of("generatedOutput", generatedOutput), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException materializationMissingProperties(Set<@Unsafe String> expectedProperties, Set<@Unsafe String> materializationProperties, @Unsafe String userFriendlyMessage) {
        return new ServiceException(MATERIALIZATION_MISSING_PROPERTIES, UnsafeArg.of("expectedProperties", expectedProperties), UnsafeArg.of("materializationProperties", materializationProperties), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException materializationMissingProperties(@Nullable Throwable cause, Set<@Unsafe String> expectedProperties, Set<@Unsafe String> materializationProperties, @Unsafe String userFriendlyMessage) {
        return new ServiceException(MATERIALIZATION_MISSING_PROPERTIES, cause, UnsafeArg.of("expectedProperties", expectedProperties), UnsafeArg.of("materializationProperties", materializationProperties), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException notAuthorized(Set<@Safe String> operations) {
        return new ServiceException(NOT_AUTHORIZED, SafeArg.of("operations", operations));
    }

    public static ServiceException notAuthorized(@Nullable Throwable cause, Set<@Safe String> operations) {
        return new ServiceException(NOT_AUTHORIZED, cause, SafeArg.of("operations", operations));
    }

    public static ServiceException notAuthorizedToReadInputs(Set<@Safe ResourceIdentifier> inputRids) {
        return new ServiceException(NOT_AUTHORIZED_TO_READ_INPUTS, SafeArg.of("inputRids", inputRids));
    }

    public static ServiceException notAuthorizedToReadInputs(@Nullable Throwable cause, Set<@Safe ResourceIdentifier> inputRids) {
        return new ServiceException(NOT_AUTHORIZED_TO_READ_INPUTS, cause, SafeArg.of("inputRids", inputRids));
    }

    public static ServiceException ontologyNotFound(@Unsafe String ontologyApiName, @Unsafe String userFriendlyMessage) {
        return new ServiceException(ONTOLOGY_NOT_FOUND, UnsafeArg.of("ontologyApiName", ontologyApiName), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException ontologyNotFound(@Nullable Throwable cause, @Unsafe String ontologyApiName, @Unsafe String userFriendlyMessage) {
        return new ServiceException(ONTOLOGY_NOT_FOUND, cause, UnsafeArg.of("ontologyApiName", ontologyApiName), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException ontologySqlUnsupported(@Safe String userFriendlyMessage) {
        return new ServiceException(ONTOLOGY_SQL_UNSUPPORTED, SafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException ontologySqlUnsupported(@Nullable Throwable cause, @Safe String userFriendlyMessage) {
        return new ServiceException(ONTOLOGY_SQL_UNSUPPORTED, cause, SafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException parameterValueNotFound(@Unsafe String parameterName) {
        return new ServiceException(PARAMETER_VALUE_NOT_FOUND, UnsafeArg.of("parameterName", parameterName));
    }

    public static ServiceException parameterValueNotFound(@Nullable Throwable cause, @Unsafe String parameterName) {
        return new ServiceException(PARAMETER_VALUE_NOT_FOUND, cause, UnsafeArg.of("parameterName", parameterName));
    }

    public static ServiceException parametersNotFound() {
        return new ServiceException(PARAMETERS_NOT_FOUND, new Arg[0]);
    }

    public static ServiceException parametersNotFound(@Nullable Throwable cause) {
        return new ServiceException(PARAMETERS_NOT_FOUND, cause, new Arg[0]);
    }

    public static ServiceException queryAborted(@Safe QueryId queryId, @Unsafe String userFriendlyMessage) {
        return new ServiceException(QUERY_ABORTED, SafeArg.of("queryId", queryId), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException queryAborted(@Nullable Throwable cause, @Safe QueryId queryId, @Unsafe String userFriendlyMessage) {
        return new ServiceException(QUERY_ABORTED, cause, SafeArg.of("queryId", queryId), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException queryCapabilitiesNotSupported(Set<@Safe QueryCapability> capabilities, @Unsafe String userFriendlyMessage) {
        return new ServiceException(QUERY_CAPABILITIES_NOT_SUPPORTED, SafeArg.of("capabilities", capabilities), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException queryCapabilitiesNotSupported(@Nullable Throwable cause, Set<@Safe QueryCapability> capabilities, @Unsafe String userFriendlyMessage) {
        return new ServiceException(QUERY_CAPABILITIES_NOT_SUPPORTED, cause, SafeArg.of("capabilities", capabilities), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException queryFailed(@Safe QueryId queryId, @Unsafe String userFriendlyMessage) {
        return new ServiceException(QUERY_FAILED, SafeArg.of("queryId", queryId), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException queryFailed(@Nullable Throwable cause, @Safe QueryId queryId, @Unsafe String userFriendlyMessage) {
        return new ServiceException(QUERY_FAILED, cause, SafeArg.of("queryId", queryId), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException queryInvalid(@Safe SqlDialect sqlDialect, @Unsafe String userFriendlyMessage) {
        return new ServiceException(QUERY_INVALID, SafeArg.of("sqlDialect", sqlDialect), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException queryInvalid(@Nullable Throwable cause, @Safe SqlDialect sqlDialect, @Unsafe String userFriendlyMessage) {
        return new ServiceException(QUERY_INVALID, cause, SafeArg.of("sqlDialect", sqlDialect), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException queryTimeout(@Safe QueryId queryId, @Unsafe String userFriendlyMessage) {
        return new ServiceException(QUERY_TIMEOUT, SafeArg.of("queryId", queryId), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException queryTimeout(@Nullable Throwable cause, @Safe QueryId queryId, @Unsafe String userFriendlyMessage) {
        return new ServiceException(QUERY_TIMEOUT, cause, SafeArg.of("queryId", queryId), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException queryWriteTimeout(@Safe QueryId queryId, @Unsafe String userFriendlyMessage) {
        return new ServiceException(QUERY_WRITE_TIMEOUT, SafeArg.of("queryId", queryId), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException queryWriteTimeout(@Nullable Throwable cause, @Safe QueryId queryId, @Unsafe String userFriendlyMessage) {
        return new ServiceException(QUERY_WRITE_TIMEOUT, cause, SafeArg.of("queryId", queryId), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException sessionIsAlreadyClosed(@Safe SessionId sessionId) {
        return new ServiceException(SESSION_IS_ALREADY_CLOSED, SafeArg.of("sessionId", sessionId));
    }

    public static ServiceException sessionIsAlreadyClosed(@Nullable Throwable cause, @Safe SessionId sessionId) {
        return new ServiceException(SESSION_IS_ALREADY_CLOSED, cause, SafeArg.of("sessionId", sessionId));
    }

    public static ServiceException sessionIsNotOpen(@Safe SessionId sessionId) {
        return new ServiceException(SESSION_IS_NOT_OPEN, SafeArg.of("sessionId", sessionId));
    }

    public static ServiceException sessionIsNotOpen(@Nullable Throwable cause, @Safe SessionId sessionId) {
        return new ServiceException(SESSION_IS_NOT_OPEN, cause, SafeArg.of("sessionId", sessionId));
    }

    public static ServiceException sessionNotFound(@Safe SessionId sessionId) {
        return new ServiceException(SESSION_NOT_FOUND, SafeArg.of("sessionId", sessionId));
    }

    public static ServiceException sessionNotFound(@Nullable Throwable cause, @Safe SessionId sessionId) {
        return new ServiceException(SESSION_NOT_FOUND, cause, SafeArg.of("sessionId", sessionId));
    }

    public static ServiceException sharedQueryNotFound(Set<@Safe SharedQueryId> sharedQueryId, @Unsafe String userFriendlyMessage) {
        return new ServiceException(SHARED_QUERY_NOT_FOUND, SafeArg.of("sharedQueryId", sharedQueryId), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException sharedQueryNotFound(@Nullable Throwable cause, Set<@Safe SharedQueryId> sharedQueryId, @Unsafe String userFriendlyMessage) {
        return new ServiceException(SHARED_QUERY_NOT_FOUND, cause, SafeArg.of("sharedQueryId", sharedQueryId), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException statementIsNotInExpectedState(@Safe StatementId statementId, Set<@Safe String> expectedStates, @Safe String actualState) {
        return new ServiceException(STATEMENT_IS_NOT_IN_EXPECTED_STATE, SafeArg.of("statementId", statementId), SafeArg.of("expectedStates", expectedStates), SafeArg.of("actualState", actualState));
    }

    public static ServiceException statementIsNotInExpectedState(@Nullable Throwable cause, @Safe StatementId statementId, Set<@Safe String> expectedStates, @Safe String actualState) {
        return new ServiceException(STATEMENT_IS_NOT_IN_EXPECTED_STATE, cause, SafeArg.of("statementId", statementId), SafeArg.of("expectedStates", expectedStates), SafeArg.of("actualState", actualState));
    }

    public static ServiceException statementNotFound(@Safe StatementId statementId) {
        return new ServiceException(STATEMENT_NOT_FOUND, SafeArg.of("statementId", statementId));
    }

    public static ServiceException statementNotFound(@Nullable Throwable cause, @Safe StatementId statementId) {
        return new ServiceException(STATEMENT_NOT_FOUND, cause, SafeArg.of("statementId", statementId));
    }

    public static ServiceException tooManyRows(@Safe int limit, @Unsafe String userFriendlyMessage) {
        return new ServiceException(TOO_MANY_ROWS, SafeArg.of("limit", limit), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException tooManyRows(@Nullable Throwable cause, @Safe int limit, @Unsafe String userFriendlyMessage) {
        return new ServiceException(TOO_MANY_ROWS, cause, SafeArg.of("limit", limit), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException unknownUnionType(@Safe String safeUnknownTypeName, @Safe String parentType) {
        return new ServiceException(UNKNOWN_UNION_TYPE, SafeArg.of("safeUnknownTypeName", safeUnknownTypeName), SafeArg.of("parentType", parentType));
    }

    public static ServiceException unknownUnionType(@Nullable Throwable cause, @Safe String safeUnknownTypeName, @Safe String parentType) {
        return new ServiceException(UNKNOWN_UNION_TYPE, cause, SafeArg.of("safeUnknownTypeName", safeUnknownTypeName), SafeArg.of("parentType", parentType));
    }

    public static ServiceException unsupportedCsvColumns(List<@Unsafe String> columns) {
        return new ServiceException(UNSUPPORTED_CSV_COLUMNS, UnsafeArg.of("columns", columns));
    }

    public static ServiceException unsupportedCsvColumns(@Nullable Throwable cause, List<@Unsafe String> columns) {
        return new ServiceException(UNSUPPORTED_CSV_COLUMNS, cause, UnsafeArg.of("columns", columns));
    }

    public static ServiceException unsupportedDriverVersion(@Safe String driverVersion, @Unsafe String userFriendlyMessage) {
        return new ServiceException(UNSUPPORTED_DRIVER_VERSION, SafeArg.of("driverVersion", driverVersion), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    public static ServiceException unsupportedDriverVersion(@Nullable Throwable cause, @Safe String driverVersion, @Unsafe String userFriendlyMessage) {
        return new ServiceException(UNSUPPORTED_DRIVER_VERSION, cause, SafeArg.of("driverVersion", driverVersion), UnsafeArg.of("userFriendlyMessage", userFriendlyMessage));
    }

    @Contract(value="true, _, _, _ -> fail")
    public static void throwIfAmbiguousOntologyApiName(boolean shouldThrow, @Safe Set<ResourceIdentifier> ontologyRids, @Unsafe String ontologyApiName, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.ambiguousOntologyApiName(ontologyRids, ontologyApiName, userFriendlyMessage);
        }
    }

    @Contract(value="true, _ -> fail")
    public static void throwIfContainsNamedAndUnnamedParameters(boolean shouldThrow, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.containsNamedAndUnnamedParameters(userFriendlyMessage);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void throwIfContainsTabularAndOntologyInputs(boolean shouldThrow, @Safe Set<ResourceIdentifier> inputRids, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.containsTabularAndOntologyInputs(inputRids, userFriendlyMessage);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void throwIfCouldNotExecuteStatement(boolean shouldThrow, @Safe StatementId statementId, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.couldNotExecuteStatement(statementId, userFriendlyMessage);
        }
    }

    @Contract(value="true, _, _, _ -> fail")
    public static void throwIfCouldNotParseQuery(boolean shouldThrow, @Safe SessionId sessionId, @Safe SqlDialect sqlDialect, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.couldNotParseQuery(sessionId, sqlDialect, userFriendlyMessage);
        }
    }

    @Contract(value="true, _, _, _ -> fail")
    public static void throwIfDuplicateLinkedObjectApiNames(boolean shouldThrow, @Safe ResourceIdentifier linkTypeRid, @Unsafe List<String> duplicateApiNames, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.duplicateLinkedObjectApiNames(linkTypeRid, duplicateApiNames, userFriendlyMessage);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void throwIfEntityQueryableSourceNotFound(boolean shouldThrow, @Safe ResourceIdentifier ontologyEntityRid, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.entityQueryableSourceNotFound(ontologyEntityRid, userFriendlyMessage);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void throwIfInvalidDatasetCannotAccess(boolean shouldThrow, @Safe DatasetRid datasetRid, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.invalidDatasetCannotAccess(datasetRid, userFriendlyMessage);
        }
    }

    @Contract(value="true, _, _, _, _ -> fail")
    public static void throwIfInvalidDatasetEmptyView(boolean shouldThrow, @Safe DatasetRid datasetRid, @Safe Optional<StartTransactionRid> startTransactionRid, @Unsafe String userFriendlyMessage, @Unsafe String endRef) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.invalidDatasetEmptyView(datasetRid, startTransactionRid, userFriendlyMessage, endRef);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void throwIfInvalidDatasetNoSchema(boolean shouldThrow, @Safe DatasetRid datasetRid, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.invalidDatasetNoSchema(datasetRid, userFriendlyMessage);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void throwIfInvalidDatasetPathNotFound(boolean shouldThrow, @Unsafe String path, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.invalidDatasetPathNotFound(path, userFriendlyMessage);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void throwIfInvalidIdentifierNotFound(boolean shouldThrow, @Unsafe String identifier, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.invalidIdentifierNotFound(identifier, userFriendlyMessage);
        }
    }

    @Contract(value="true -> fail")
    public static void throwIfInvalidPageToken(boolean shouldThrow) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.invalidPageToken();
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void throwIfInvalidQueryStream(boolean shouldThrow, @Safe QueryId queryId, @Safe StreamId streamId) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.invalidQueryStream(queryId, streamId);
        }
    }

    @Contract(value="true, _ -> fail")
    public static void throwIfInvalidSessionAuthTokenForSession(boolean shouldThrow, @Safe SessionId sessionId) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.invalidSessionAuthTokenForSession(sessionId);
        }
    }

    @Contract(value="true, _ -> fail")
    public static void throwIfInvalidSessionAuthTokenForStatement(boolean shouldThrow, @Safe StatementId statementId) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.invalidSessionAuthTokenForStatement(statementId);
        }
    }

    @Contract(value="true, _, _, _, _ -> fail")
    public static void throwIfInvalidStreamOffset(boolean shouldThrow, @Safe SafeLong bufferEnd, @Safe SafeLong bufferStart, @Safe SafeLong currentOffset, @Safe SafeLong requestedOffset) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.invalidStreamOffset(bufferEnd, bufferStart, currentOffset, requestedOffset);
        }
    }

    @Contract(value="true -> fail")
    public static void throwIfInvalidTicket(boolean shouldThrow) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.invalidTicket();
        }
    }

    @Contract(value="true, _ -> fail")
    public static void throwIfInvalidUserIdForSession(boolean shouldThrow, @Safe SessionId sessionId) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.invalidUserIdForSession(sessionId);
        }
    }

    @Contract(value="true, _ -> fail")
    public static void throwIfInvalidUserIdForStatement(boolean shouldThrow, @Safe StatementId statementId) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.invalidUserIdForStatement(statementId);
        }
    }

    @Contract(value="true, _ -> fail")
    public static void throwIfJobNotFound(boolean shouldThrow, @Safe JobId jobId) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.jobNotFound(jobId);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void throwIfLinkTypesUnsupported(boolean shouldThrow, @Safe ResourceIdentifier rid, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.linkTypesUnsupported(rid, userFriendlyMessage);
        }
    }

    @Contract(value="true, _, _, _ -> fail")
    public static void throwIfLlmGenerationFailed(boolean shouldThrow, @Unsafe Optional<String> userInput, @Unsafe Optional<String> generatedOutput, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.llmGenerationFailed(userInput, generatedOutput, userFriendlyMessage);
        }
    }

    @Contract(value="true, _, _, _ -> fail")
    public static void throwIfMaterializationMissingProperties(boolean shouldThrow, @Unsafe Set<String> expectedProperties, @Unsafe Set<String> materializationProperties, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.materializationMissingProperties(expectedProperties, materializationProperties, userFriendlyMessage);
        }
    }

    @Contract(value="true, _ -> fail")
    public static void throwIfNotAuthorized(boolean shouldThrow, @Safe Set<String> operations) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.notAuthorized(operations);
        }
    }

    @Contract(value="true, _ -> fail")
    public static void throwIfNotAuthorizedToReadInputs(boolean shouldThrow, @Safe Set<ResourceIdentifier> inputRids) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.notAuthorizedToReadInputs(inputRids);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void throwIfOntologyNotFound(boolean shouldThrow, @Unsafe String ontologyApiName, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.ontologyNotFound(ontologyApiName, userFriendlyMessage);
        }
    }

    @Contract(value="true, _ -> fail")
    public static void throwIfOntologySqlUnsupported(boolean shouldThrow, @Safe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.ontologySqlUnsupported(userFriendlyMessage);
        }
    }

    @Contract(value="true, _ -> fail")
    public static void throwIfParameterValueNotFound(boolean shouldThrow, @Unsafe String parameterName) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.parameterValueNotFound(parameterName);
        }
    }

    @Contract(value="true -> fail")
    public static void throwIfParametersNotFound(boolean shouldThrow) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.parametersNotFound();
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void throwIfQueryAborted(boolean shouldThrow, @Safe QueryId queryId, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.queryAborted(queryId, userFriendlyMessage);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void throwIfQueryCapabilitiesNotSupported(boolean shouldThrow, @Safe Set<QueryCapability> capabilities, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.queryCapabilitiesNotSupported(capabilities, userFriendlyMessage);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void throwIfQueryFailed(boolean shouldThrow, @Safe QueryId queryId, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.queryFailed(queryId, userFriendlyMessage);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void throwIfQueryInvalid(boolean shouldThrow, @Safe SqlDialect sqlDialect, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.queryInvalid(sqlDialect, userFriendlyMessage);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void throwIfQueryTimeout(boolean shouldThrow, @Safe QueryId queryId, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.queryTimeout(queryId, userFriendlyMessage);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void throwIfQueryWriteTimeout(boolean shouldThrow, @Safe QueryId queryId, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.queryWriteTimeout(queryId, userFriendlyMessage);
        }
    }

    @Contract(value="true, _ -> fail")
    public static void throwIfSessionIsAlreadyClosed(boolean shouldThrow, @Safe SessionId sessionId) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.sessionIsAlreadyClosed(sessionId);
        }
    }

    @Contract(value="true, _ -> fail")
    public static void throwIfSessionIsNotOpen(boolean shouldThrow, @Safe SessionId sessionId) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.sessionIsNotOpen(sessionId);
        }
    }

    @Contract(value="true, _ -> fail")
    public static void throwIfSessionNotFound(boolean shouldThrow, @Safe SessionId sessionId) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.sessionNotFound(sessionId);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void throwIfSharedQueryNotFound(boolean shouldThrow, @Safe Set<SharedQueryId> sharedQueryId, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.sharedQueryNotFound(sharedQueryId, userFriendlyMessage);
        }
    }

    @Contract(value="true, _, _, _ -> fail")
    public static void throwIfStatementIsNotInExpectedState(boolean shouldThrow, @Safe StatementId statementId, @Safe Set<String> expectedStates, @Safe String actualState) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.statementIsNotInExpectedState(statementId, expectedStates, actualState);
        }
    }

    @Contract(value="true, _ -> fail")
    public static void throwIfStatementNotFound(boolean shouldThrow, @Safe StatementId statementId) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.statementNotFound(statementId);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void throwIfTooManyRows(boolean shouldThrow, @Safe int limit, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.tooManyRows(limit, userFriendlyMessage);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void throwIfUnknownUnionType(boolean shouldThrow, @Safe String safeUnknownTypeName, @Safe String parentType) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.unknownUnionType(safeUnknownTypeName, parentType);
        }
    }

    @Contract(value="true, _ -> fail")
    public static void throwIfUnsupportedCsvColumns(boolean shouldThrow, @Unsafe List<String> columns) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.unsupportedCsvColumns(columns);
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void throwIfUnsupportedDriverVersion(boolean shouldThrow, @Safe String driverVersion, @Unsafe String userFriendlyMessage) {
        if (shouldThrow) {
            throw FoundrySqlServerErrors.unsupportedDriverVersion(driverVersion, userFriendlyMessage);
        }
    }

    public static boolean isAmbiguousOntologyApiName(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return AMBIGUOUS_ONTOLOGY_API_NAME.name().equals(remoteException.getError().errorName());
    }

    public static boolean isContainsNamedAndUnnamedParameters(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return CONTAINS_NAMED_AND_UNNAMED_PARAMETERS.name().equals(remoteException.getError().errorName());
    }

    public static boolean isContainsTabularAndOntologyInputs(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return CONTAINS_TABULAR_AND_ONTOLOGY_INPUTS.name().equals(remoteException.getError().errorName());
    }

    public static boolean isCouldNotExecuteStatement(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return COULD_NOT_EXECUTE_STATEMENT.name().equals(remoteException.getError().errorName());
    }

    public static boolean isCouldNotParseQuery(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return COULD_NOT_PARSE_QUERY.name().equals(remoteException.getError().errorName());
    }

    public static boolean isDuplicateLinkedObjectApiNames(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return DUPLICATE_LINKED_OBJECT_API_NAMES.name().equals(remoteException.getError().errorName());
    }

    public static boolean isEntityQueryableSourceNotFound(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return ENTITY_QUERYABLE_SOURCE_NOT_FOUND.name().equals(remoteException.getError().errorName());
    }

    public static boolean isInvalidDatasetCannotAccess(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return INVALID_DATASET_CANNOT_ACCESS.name().equals(remoteException.getError().errorName());
    }

    public static boolean isInvalidDatasetEmptyView(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return INVALID_DATASET_EMPTY_VIEW.name().equals(remoteException.getError().errorName());
    }

    public static boolean isInvalidDatasetNoSchema(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return INVALID_DATASET_NO_SCHEMA.name().equals(remoteException.getError().errorName());
    }

    public static boolean isInvalidDatasetPathNotFound(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return INVALID_DATASET_PATH_NOT_FOUND.name().equals(remoteException.getError().errorName());
    }

    public static boolean isInvalidIdentifierNotFound(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return INVALID_IDENTIFIER_NOT_FOUND.name().equals(remoteException.getError().errorName());
    }

    public static boolean isInvalidPageToken(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return INVALID_PAGE_TOKEN.name().equals(remoteException.getError().errorName());
    }

    public static boolean isInvalidQueryStream(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return INVALID_QUERY_STREAM.name().equals(remoteException.getError().errorName());
    }

    public static boolean isInvalidSessionAuthTokenForSession(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return INVALID_SESSION_AUTH_TOKEN_FOR_SESSION.name().equals(remoteException.getError().errorName());
    }

    public static boolean isInvalidSessionAuthTokenForStatement(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return INVALID_SESSION_AUTH_TOKEN_FOR_STATEMENT.name().equals(remoteException.getError().errorName());
    }

    public static boolean isInvalidStreamOffset(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return INVALID_STREAM_OFFSET.name().equals(remoteException.getError().errorName());
    }

    public static boolean isInvalidTicket(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return INVALID_TICKET.name().equals(remoteException.getError().errorName());
    }

    public static boolean isInvalidUserIdForSession(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return INVALID_USER_ID_FOR_SESSION.name().equals(remoteException.getError().errorName());
    }

    public static boolean isInvalidUserIdForStatement(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return INVALID_USER_ID_FOR_STATEMENT.name().equals(remoteException.getError().errorName());
    }

    public static boolean isJobNotFound(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return JOB_NOT_FOUND.name().equals(remoteException.getError().errorName());
    }

    public static boolean isLinkTypesUnsupported(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return LINK_TYPES_UNSUPPORTED.name().equals(remoteException.getError().errorName());
    }

    public static boolean isLlmGenerationFailed(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return LLM_GENERATION_FAILED.name().equals(remoteException.getError().errorName());
    }

    public static boolean isMaterializationMissingProperties(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return MATERIALIZATION_MISSING_PROPERTIES.name().equals(remoteException.getError().errorName());
    }

    public static boolean isNotAuthorized(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return NOT_AUTHORIZED.name().equals(remoteException.getError().errorName());
    }

    public static boolean isNotAuthorizedToReadInputs(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return NOT_AUTHORIZED_TO_READ_INPUTS.name().equals(remoteException.getError().errorName());
    }

    public static boolean isOntologyNotFound(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return ONTOLOGY_NOT_FOUND.name().equals(remoteException.getError().errorName());
    }

    public static boolean isOntologySqlUnsupported(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return ONTOLOGY_SQL_UNSUPPORTED.name().equals(remoteException.getError().errorName());
    }

    public static boolean isParameterValueNotFound(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return PARAMETER_VALUE_NOT_FOUND.name().equals(remoteException.getError().errorName());
    }

    public static boolean isParametersNotFound(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return PARAMETERS_NOT_FOUND.name().equals(remoteException.getError().errorName());
    }

    public static boolean isQueryAborted(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return QUERY_ABORTED.name().equals(remoteException.getError().errorName());
    }

    public static boolean isQueryCapabilitiesNotSupported(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return QUERY_CAPABILITIES_NOT_SUPPORTED.name().equals(remoteException.getError().errorName());
    }

    public static boolean isQueryFailed(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return QUERY_FAILED.name().equals(remoteException.getError().errorName());
    }

    public static boolean isQueryInvalid(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return QUERY_INVALID.name().equals(remoteException.getError().errorName());
    }

    public static boolean isQueryTimeout(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return QUERY_TIMEOUT.name().equals(remoteException.getError().errorName());
    }

    public static boolean isQueryWriteTimeout(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return QUERY_WRITE_TIMEOUT.name().equals(remoteException.getError().errorName());
    }

    public static boolean isSessionIsAlreadyClosed(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return SESSION_IS_ALREADY_CLOSED.name().equals(remoteException.getError().errorName());
    }

    public static boolean isSessionIsNotOpen(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return SESSION_IS_NOT_OPEN.name().equals(remoteException.getError().errorName());
    }

    public static boolean isSessionNotFound(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return SESSION_NOT_FOUND.name().equals(remoteException.getError().errorName());
    }

    public static boolean isSharedQueryNotFound(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return SHARED_QUERY_NOT_FOUND.name().equals(remoteException.getError().errorName());
    }

    public static boolean isStatementIsNotInExpectedState(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return STATEMENT_IS_NOT_IN_EXPECTED_STATE.name().equals(remoteException.getError().errorName());
    }

    public static boolean isStatementNotFound(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return STATEMENT_NOT_FOUND.name().equals(remoteException.getError().errorName());
    }

    public static boolean isTooManyRows(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return TOO_MANY_ROWS.name().equals(remoteException.getError().errorName());
    }

    public static boolean isUnknownUnionType(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return UNKNOWN_UNION_TYPE.name().equals(remoteException.getError().errorName());
    }

    public static boolean isUnsupportedCsvColumns(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return UNSUPPORTED_CSV_COLUMNS.name().equals(remoteException.getError().errorName());
    }

    public static boolean isUnsupportedDriverVersion(RemoteException remoteException) {
        Preconditions.checkNotNull(remoteException, "remote exception must not be null");
        return UNSUPPORTED_DRIVER_VERSION.name().equals(remoteException.getError().errorName());
    }
}

