/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.palantir.ri.ResourceIdentifier;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Safe
public final class DatasetRid {
    @Safe
    private final ResourceIdentifier value;

    private DatasetRid(@Nonnull @Safe ResourceIdentifier value) {
        this.value = Preconditions.checkNotNull(value, "value cannot be null");
    }

    @JsonValue
    @Safe
    public ResourceIdentifier get() {
        return this.value;
    }

    @Safe
    public String toString() {
        return this.value.toString();
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof DatasetRid && this.equalTo((DatasetRid)other);
    }

    private boolean equalTo(DatasetRid other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public static DatasetRid valueOf(@Safe String value) {
        return DatasetRid.of(ResourceIdentifier.valueOf(value));
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static DatasetRid of(@Nonnull @Safe ResourceIdentifier value) {
        return new DatasetRid(value);
    }
}

