/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.geojson;

import com.palantir.logsafe.Preconditions;
import shadow.palantir.driver.com.google.common.collect.Iterators;
import shadow.palantir.driver.com.google.common.collect.PeekingIterator;
import shadow.palantir.driver.com.palantir.geojson.CoordinateIterator;
import shadow.palantir.driver.com.palantir.geojson.LngLatAlt;

final class GenericCoordinateIterator
implements CoordinateIterator {
    private final PeekingIterator<? extends LngLatAlt> iterator;
    private int index;

    GenericCoordinateIterator(Iterable<? extends LngLatAlt> iterable) {
        this.iterator = Iterators.peekingIterator(iterable.iterator());
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public double getLng() {
        return this.iterator.peek().getLongitude();
    }

    @Override
    public double getLat() {
        return this.iterator.peek().getLatitude();
    }

    @Override
    public double getAltitude() {
        return this.iterator.peek().getAltitude();
    }

    @Override
    public void next() {
        Preconditions.checkState(this.isValid(), "Iterator is not valid");
        ++this.index;
        this.iterator.next();
    }

    @Override
    public boolean isValid() {
        return this.iterator.hasNext();
    }
}

