/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.geojson;

import java.util.List;
import shadow.palantir.driver.com.palantir.geojson.Feature;
import shadow.palantir.driver.com.palantir.geojson.FeatureCollection;
import shadow.palantir.driver.com.palantir.geojson.GeoJsonObject;
import shadow.palantir.driver.com.palantir.geojson.GeoJsonObjectVisitor;
import shadow.palantir.driver.com.palantir.geojson.Geometry;
import shadow.palantir.driver.com.palantir.geojson.GeometryCollection;
import shadow.palantir.driver.com.palantir.geojson.LineString;
import shadow.palantir.driver.com.palantir.geojson.LngLatAlt;
import shadow.palantir.driver.com.palantir.geojson.MultiLineString;
import shadow.palantir.driver.com.palantir.geojson.MultiPoint;
import shadow.palantir.driver.com.palantir.geojson.MultiPolygon;
import shadow.palantir.driver.com.palantir.geojson.Point;
import shadow.palantir.driver.com.palantir.geojson.Polygon;

public interface GeoJsonLeafVisitor<T> {
    public T visit(Point var1);

    public T visit(LineString var1);

    public T visit(Polygon var1);

    public static void visitLeaves(GeoJsonObject object, GeoJsonLeafVisitor<?> visitor) {
        visitor.visitLeaves(object);
    }

    default public void visitLeaves(GeoJsonObject object) {
        object.accept(new GeoJsonObjectVisitor<Void>(){

            @Override
            public Void visit(Feature feature) {
                if (feature.getGeometry() != null) {
                    feature.getGeometry().accept(this);
                }
                return null;
            }

            @Override
            public Void visit(FeatureCollection featureCollection) {
                for (Feature feature : featureCollection) {
                    feature.accept(this);
                }
                return null;
            }

            @Override
            public Void visit(GeometryCollection geometryCollection) {
                for (Geometry child : geometryCollection.getGeometries()) {
                    child.accept(this);
                }
                return null;
            }

            @Override
            public Void visit(MultiLineString multiLineString) {
                for (List<LngLatAlt> line : multiLineString.getCoordinates()) {
                    GeoJsonLeafVisitor.this.visit(LineString.of(line));
                }
                return null;
            }

            @Override
            public Void visit(MultiPoint multiPoint) {
                for (LngLatAlt point : multiPoint.getCoordinates()) {
                    GeoJsonLeafVisitor.this.visit(Point.of(point));
                }
                return null;
            }

            @Override
            public Void visit(MultiPolygon multiPolygon) {
                for (List<List<LngLatAlt>> polygon : multiPolygon.getCoordinates()) {
                    GeoJsonLeafVisitor.this.visit(Polygon.ofAll(polygon));
                }
                return null;
            }

            @Override
            public Void visit(Point point) {
                GeoJsonLeafVisitor.this.visit(point);
                return null;
            }

            @Override
            public Void visit(LineString lineString) {
                GeoJsonLeafVisitor.this.visit(lineString);
                return null;
            }

            @Override
            public Void visit(Polygon polygon) {
                GeoJsonLeafVisitor.this.visit(polygon);
                return null;
            }
        });
    }
}

