/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.geojson;

import java.util.Iterator;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.palantir.geojson.Geometry;
import shadow.palantir.driver.com.palantir.geojson.GeometryVisitor;
import shadow.palantir.driver.com.palantir.geojson.ImmutableGeometryCollection;
import shadow.palantir.driver.com.palantir.geojson.RecursiveImmutableListDeserializer;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonTypeName(value="GeometryCollection")
@JsonSerialize(as=ImmutableGeometryCollection.class)
@JsonDeserialize(as=ImmutableGeometryCollection.class)
@Value.Immutable
public abstract class GeometryCollection
implements Geometry,
Iterable<Geometry> {
    public static final String TYPE = "GeometryCollection";

    public static ImmutableGeometryCollection of(Iterable<? extends Geometry> geometries) {
        if (geometries instanceof ImmutableGeometryCollection) {
            return (ImmutableGeometryCollection)geometries;
        }
        return ImmutableGeometryCollection.of(ImmutableList.copyOf(geometries));
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGeometryCollection fromJson(ImmutableGeometryCollection.Json json) {
        ImmutableGeometryCollection result = ImmutableGeometryCollection.of(json.geometries == null ? ImmutableList.of() : json.geometries);
        if (json.bbox != null && json.bbox.length > 0) {
            result = result.withBbox(json.bbox);
        }
        return result;
    }

    @JsonDeserialize(using=RecursiveImmutableListDeserializer.class)
    @Value.Parameter
    public abstract List<Geometry> getGeometries();

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public <T> T accept(GeometryVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    @Nonnull
    public Iterator<Geometry> iterator() {
        return this.getGeometries().iterator();
    }
}

