/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.geojson;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonInclude;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.geojson.Feature;
import shadow.palantir.driver.com.palantir.geojson.GeoJsonObject;
import shadow.palantir.driver.com.palantir.geojson.PropertiesNullValueConverter;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Feature", generator="Immutables")
@Immutable
public final class ImmutableFeature
extends Feature {
    private final double[] bbox;
    @Nullable
    private final GeoJsonObject geometry;
    private final ImmutableMap<String, Object> properties;
    @Nullable
    private final String id;

    private ImmutableFeature(@Nullable GeoJsonObject geometry) {
        this.geometry = geometry;
        this.properties = ImmutableMap.of();
        this.id = null;
        this.bbox = (double[])super.getBbox().clone();
    }

    private ImmutableFeature(Builder builder) {
        this.geometry = builder.geometry;
        this.properties = builder.properties.build();
        this.id = builder.id;
        this.bbox = builder.bbox != null ? builder.bbox : (double[])super.getBbox().clone();
    }

    private ImmutableFeature(double[] bbox, @Nullable GeoJsonObject geometry, ImmutableMap<String, Object> properties, @Nullable String id) {
        this.bbox = bbox;
        this.geometry = geometry;
        this.properties = properties;
        this.id = id;
    }

    @Override
    @JsonProperty(value="bbox")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public double[] getBbox() {
        return (double[])this.bbox.clone();
    }

    @Override
    @JsonProperty(value="geometry")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @Nullable
    public GeoJsonObject getGeometry() {
        return this.geometry;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonDeserialize(converter=PropertiesNullValueConverter.class)
    public ImmutableMap<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public String getId() {
        return this.id;
    }

    public final ImmutableFeature withBbox(double ... elements) {
        double[] newValue = (double[])elements.clone();
        return new ImmutableFeature(newValue, this.geometry, this.properties, this.id);
    }

    public final ImmutableFeature withGeometry(@Nullable GeoJsonObject value) {
        if (this.geometry == value) {
            return this;
        }
        return new ImmutableFeature(this.bbox, value, this.properties, this.id);
    }

    public final ImmutableFeature withProperties(Map<String, ? extends Object> entries) {
        if (this.properties == entries) {
            return this;
        }
        ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableFeature(this.bbox, this.geometry, newValue, this.id);
    }

    public final ImmutableFeature withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableFeature(this.bbox, this.geometry, this.properties, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeature && this.equalTo(0, (ImmutableFeature)another);
    }

    private boolean equalTo(int synthetic, ImmutableFeature another) {
        return Arrays.equals(this.bbox, another.bbox) && Objects.equals(this.geometry, another.geometry) && this.properties.equals(another.properties) && Objects.equals(this.id, another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.bbox);
        h += (h << 5) + Objects.hashCode(this.geometry);
        h += (h << 5) + this.properties.hashCode();
        h += (h << 5) + Objects.hashCode(this.id);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Feature").omitNullValues().add("bbox", Arrays.toString(this.bbox)).add("geometry", this.geometry).add("properties", this.properties).add("id", this.id).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFeature fromJson(Json json) {
        Builder builder = ImmutableFeature.builder();
        if (json.bbox != null) {
            builder.bbox(json.bbox);
        }
        if (json.geometry != null) {
            builder.geometry(json.geometry);
        }
        if (json.properties != null) {
            builder.putAllProperties(json.properties);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        return builder.build();
    }

    public static ImmutableFeature of(@Nullable GeoJsonObject geometry) {
        return new ImmutableFeature(geometry);
    }

    public static ImmutableFeature copyOf(Feature instance) {
        if (instance instanceof ImmutableFeature) {
            return (ImmutableFeature)instance;
        }
        return ImmutableFeature.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Feature", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private double[] bbox;
        @Nullable
        private GeoJsonObject geometry;
        private ImmutableMap.Builder<String, Object> properties = ImmutableMap.builder();
        @Nullable
        private String id;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GeoJsonObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Feature instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            GeoJsonObject instance;
            if (object instanceof GeoJsonObject) {
                instance = (GeoJsonObject)object;
                this.bbox(instance.getBbox());
            }
            if (object instanceof Feature) {
                instance = (Feature)object;
                GeoJsonObject geometryValue = ((Feature)instance).getGeometry();
                if (geometryValue != null) {
                    this.geometry(geometryValue);
                }
                this.putAllProperties(((Feature)instance).getProperties());
                String idValue = ((Feature)instance).getId();
                if (idValue != null) {
                    this.id(idValue);
                }
            }
        }

        @JsonProperty(value="bbox")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @CanIgnoreReturnValue
        public final Builder bbox(double ... bbox) {
            this.bbox = (double[])bbox.clone();
            return this;
        }

        @JsonProperty(value="geometry")
        @JsonInclude(value=JsonInclude.Include.ALWAYS)
        @CanIgnoreReturnValue
        public final Builder geometry(@Nullable GeoJsonObject geometry) {
            this.geometry = geometry;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(String key, Object value) {
            this.properties.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(Map.Entry<String, ? extends Object> entry) {
            this.properties.put(entry);
            return this;
        }

        @JsonProperty(value="properties")
        @JsonInclude(value=JsonInclude.Include.ALWAYS)
        @JsonDeserialize(converter=PropertiesNullValueConverter.class)
        @CanIgnoreReturnValue
        public final Builder properties(Map<String, ? extends Object> entries) {
            this.properties = ImmutableMap.builder();
            return this.putAllProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllProperties(Map<String, ? extends Object> entries) {
            this.properties.putAll(entries);
            return this;
        }

        @JsonProperty(value="id")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @CanIgnoreReturnValue
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        public ImmutableFeature build() {
            return new ImmutableFeature(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Feature", generator="Immutables")
    static final class Json
    extends Feature {
        @Nullable
        double[] bbox;
        @Nullable
        GeoJsonObject geometry;
        @Nullable
        Map<String, Object> properties = ImmutableMap.of();
        @Nullable
        String id;

        Json() {
        }

        @JsonProperty(value="bbox")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setBbox(double[] bbox) {
            this.bbox = bbox;
        }

        @JsonProperty(value="geometry")
        @JsonInclude(value=JsonInclude.Include.ALWAYS)
        public void setGeometry(@Nullable GeoJsonObject geometry) {
            this.geometry = geometry;
        }

        @JsonProperty(value="properties")
        @JsonInclude(value=JsonInclude.Include.ALWAYS)
        @JsonDeserialize(converter=PropertiesNullValueConverter.class)
        public void setProperties(Map<String, Object> properties) {
            this.properties = properties;
        }

        @JsonProperty(value="id")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @Override
        public double[] getBbox() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GeoJsonObject getGeometry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }
    }
}

