/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.geojson;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonInclude;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.geojson.Feature;
import shadow.palantir.driver.com.palantir.geojson.FeatureCollection;
import shadow.palantir.driver.com.palantir.geojson.GeoJsonObject;
import shadow.palantir.driver.com.palantir.geojson.RecursiveImmutableListDeserializer;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeatureCollection", generator="Immutables")
@Immutable
public final class ImmutableFeatureCollection
extends FeatureCollection {
    private final double[] bbox;
    private final ImmutableList<Feature> features;

    private ImmutableFeatureCollection(Iterable<? extends Feature> features) {
        this.features = ImmutableList.copyOf(features);
        this.bbox = (double[])super.getBbox().clone();
    }

    private ImmutableFeatureCollection(Builder builder) {
        this.features = builder.features.build();
        this.bbox = builder.bbox != null ? builder.bbox : (double[])super.getBbox().clone();
    }

    private ImmutableFeatureCollection(double[] bbox, ImmutableList<Feature> features) {
        this.bbox = bbox;
        this.features = features;
    }

    @Override
    @JsonProperty(value="bbox")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public double[] getBbox() {
        return (double[])this.bbox.clone();
    }

    @JsonProperty(value="features")
    @JsonDeserialize(using=RecursiveImmutableListDeserializer.class)
    public ImmutableList<Feature> getFeatures() {
        return this.features;
    }

    public final ImmutableFeatureCollection withBbox(double ... elements) {
        double[] newValue = (double[])elements.clone();
        return new ImmutableFeatureCollection(newValue, this.features);
    }

    public final ImmutableFeatureCollection withFeatures(Feature ... elements) {
        ImmutableList<Feature> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeatureCollection(this.bbox, newValue);
    }

    public final ImmutableFeatureCollection withFeatures(Iterable<? extends Feature> elements) {
        if (this.features == elements) {
            return this;
        }
        ImmutableList<Feature> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeatureCollection(this.bbox, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeatureCollection && this.equalTo(0, (ImmutableFeatureCollection)another);
    }

    private boolean equalTo(int synthetic, ImmutableFeatureCollection another) {
        return Arrays.equals(this.bbox, another.bbox) && this.features.equals(another.features);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.bbox);
        h += (h << 5) + this.features.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FeatureCollection").omitNullValues().add("bbox", Arrays.toString(this.bbox)).add("features", this.features).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFeatureCollection fromJson(Json json) {
        Builder builder = ImmutableFeatureCollection.builder();
        if (json.bbox != null) {
            builder.bbox(json.bbox);
        }
        if (json.features != null) {
            builder.addAllFeatures(json.features);
        }
        return builder.build();
    }

    public static ImmutableFeatureCollection of(List<Feature> features) {
        return ImmutableFeatureCollection.of(features);
    }

    public static ImmutableFeatureCollection of(Iterable<? extends Feature> features) {
        return new ImmutableFeatureCollection(features);
    }

    public static ImmutableFeatureCollection copyOf(FeatureCollection instance) {
        if (instance instanceof ImmutableFeatureCollection) {
            return (ImmutableFeatureCollection)instance;
        }
        return ImmutableFeatureCollection.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FeatureCollection", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private double[] bbox;
        private ImmutableList.Builder<Feature> features = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GeoJsonObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(FeatureCollection instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            GeoJsonObject instance;
            long bits = 0L;
            if (object instanceof GeoJsonObject) {
                instance = (GeoJsonObject)object;
                if ((bits & 1L) == 0L) {
                    this.bbox(instance.getBbox());
                    bits |= 1L;
                }
            }
            if (object instanceof FeatureCollection) {
                instance = (FeatureCollection)object;
                this.addAllFeatures(((FeatureCollection)instance).getFeatures());
                if ((bits & 1L) == 0L) {
                    this.bbox(instance.getBbox());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder bbox(double ... bbox) {
            this.bbox = (double[])bbox.clone();
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFeatures(Feature element) {
            this.features.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFeatures(Feature ... elements) {
            this.features.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder features(Iterable<? extends Feature> elements) {
            this.features = ImmutableList.builder();
            return this.addAllFeatures(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFeatures(Iterable<? extends Feature> elements) {
            this.features.addAll(elements);
            return this;
        }

        public ImmutableFeatureCollection build() {
            return new ImmutableFeatureCollection(this);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FeatureCollection", generator="Immutables")
    static final class Json
    extends FeatureCollection {
        @Nullable
        double[] bbox;
        @Nullable
        List<Feature> features = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="bbox")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setBbox(double[] bbox) {
            this.bbox = bbox;
        }

        @JsonProperty(value="features")
        @JsonDeserialize(using=RecursiveImmutableListDeserializer.class)
        public void setFeatures(List<Feature> features) {
            this.features = features;
        }

        @Override
        public double[] getBbox() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Feature> getFeatures() {
            throw new UnsupportedOperationException();
        }
    }
}

