/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.geojson;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonInclude;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.geojson.GeoJsonObject;
import shadow.palantir.driver.com.palantir.geojson.Geometry;
import shadow.palantir.driver.com.palantir.geojson.GeometryCollection;
import shadow.palantir.driver.com.palantir.geojson.RecursiveImmutableListDeserializer;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GeometryCollection", generator="Immutables")
@Immutable
public final class ImmutableGeometryCollection
extends GeometryCollection {
    private final double[] bbox;
    private final ImmutableList<Geometry> geometries;

    private ImmutableGeometryCollection(Iterable<? extends Geometry> geometries) {
        this.geometries = ImmutableList.copyOf(geometries);
        this.bbox = (double[])super.getBbox().clone();
    }

    private ImmutableGeometryCollection(Builder builder) {
        this.geometries = builder.geometries.build();
        this.bbox = builder.bbox != null ? builder.bbox : (double[])super.getBbox().clone();
    }

    private ImmutableGeometryCollection(double[] bbox, ImmutableList<Geometry> geometries) {
        this.bbox = bbox;
        this.geometries = geometries;
    }

    @Override
    @JsonProperty(value="bbox")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public double[] getBbox() {
        return (double[])this.bbox.clone();
    }

    @JsonProperty(value="geometries")
    @JsonDeserialize(using=RecursiveImmutableListDeserializer.class)
    public ImmutableList<Geometry> getGeometries() {
        return this.geometries;
    }

    public final ImmutableGeometryCollection withBbox(double ... elements) {
        double[] newValue = (double[])elements.clone();
        return new ImmutableGeometryCollection(newValue, this.geometries);
    }

    public final ImmutableGeometryCollection withGeometries(Geometry ... elements) {
        ImmutableList<Geometry> newValue = ImmutableList.copyOf(elements);
        return new ImmutableGeometryCollection(this.bbox, newValue);
    }

    public final ImmutableGeometryCollection withGeometries(Iterable<? extends Geometry> elements) {
        if (this.geometries == elements) {
            return this;
        }
        ImmutableList<Geometry> newValue = ImmutableList.copyOf(elements);
        return new ImmutableGeometryCollection(this.bbox, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGeometryCollection && this.equalTo(0, (ImmutableGeometryCollection)another);
    }

    private boolean equalTo(int synthetic, ImmutableGeometryCollection another) {
        return Arrays.equals(this.bbox, another.bbox) && this.geometries.equals(another.geometries);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.bbox);
        h += (h << 5) + this.geometries.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("GeometryCollection").omitNullValues().add("bbox", Arrays.toString(this.bbox)).add("geometries", this.geometries).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGeometryCollection fromJson(Json json) {
        Builder builder = ImmutableGeometryCollection.builder();
        if (json.bbox != null) {
            builder.bbox(json.bbox);
        }
        if (json.geometries != null) {
            builder.addAllGeometries(json.geometries);
        }
        return builder.build();
    }

    public static ImmutableGeometryCollection of(List<Geometry> geometries) {
        return ImmutableGeometryCollection.of(geometries);
    }

    public static ImmutableGeometryCollection of(Iterable<? extends Geometry> geometries) {
        return new ImmutableGeometryCollection(geometries);
    }

    public static ImmutableGeometryCollection copyOf(GeometryCollection instance) {
        if (instance instanceof ImmutableGeometryCollection) {
            return (ImmutableGeometryCollection)instance;
        }
        return ImmutableGeometryCollection.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GeometryCollection", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private double[] bbox;
        private ImmutableList.Builder<Geometry> geometries = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Geometry instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(GeoJsonObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(GeometryCollection instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            GeoJsonObject instance;
            long bits = 0L;
            if (object instanceof Geometry) {
                instance = (Geometry)object;
                if ((bits & 1L) == 0L) {
                    this.bbox(instance.getBbox());
                    bits |= 1L;
                }
            }
            if (object instanceof GeoJsonObject) {
                instance = (GeoJsonObject)object;
                if ((bits & 1L) == 0L) {
                    this.bbox(instance.getBbox());
                    bits |= 1L;
                }
            }
            if (object instanceof GeometryCollection) {
                instance = (GeometryCollection)object;
                if ((bits & 1L) == 0L) {
                    this.bbox(instance.getBbox());
                    bits |= 1L;
                }
                this.addAllGeometries(((GeometryCollection)instance).getGeometries());
            }
        }

        @JsonProperty(value="bbox")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @CanIgnoreReturnValue
        public final Builder bbox(double ... bbox) {
            this.bbox = (double[])bbox.clone();
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGeometries(Geometry element) {
            this.geometries.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGeometries(Geometry ... elements) {
            this.geometries.add(elements);
            return this;
        }

        @JsonProperty(value="geometries")
        @JsonDeserialize(using=RecursiveImmutableListDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder geometries(Iterable<? extends Geometry> elements) {
            this.geometries = ImmutableList.builder();
            return this.addAllGeometries(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGeometries(Iterable<? extends Geometry> elements) {
            this.geometries.addAll(elements);
            return this;
        }

        public ImmutableGeometryCollection build() {
            return new ImmutableGeometryCollection(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GeometryCollection", generator="Immutables")
    static final class Json
    extends GeometryCollection {
        @Nullable
        double[] bbox;
        @Nullable
        List<Geometry> geometries = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="bbox")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setBbox(double[] bbox) {
            this.bbox = bbox;
        }

        @JsonProperty(value="geometries")
        @JsonDeserialize(using=RecursiveImmutableListDeserializer.class)
        public void setGeometries(List<Geometry> geometries) {
            this.geometries = geometries;
        }

        @Override
        public double[] getBbox() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Geometry> getGeometries() {
            throw new UnsupportedOperationException();
        }
    }
}

