/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.geojson;

import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.palantir.geojson.LngLatAlt;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LngLatAlt", generator="Immutables")
@Immutable
public final class ImmutableLngLatAlt
extends LngLatAlt {
    private final double longitude;
    private final double latitude;
    private final double altitude;

    private ImmutableLngLatAlt(double longitude, double latitude, double altitude) {
        this.longitude = longitude;
        this.latitude = latitude;
        this.altitude = altitude;
    }

    @Override
    @JsonProperty(value="longitude")
    public double getLongitude() {
        return this.longitude;
    }

    @Override
    @JsonProperty(value="latitude")
    public double getLatitude() {
        return this.latitude;
    }

    @Override
    @JsonProperty(value="altitude")
    public double getAltitude() {
        return this.altitude;
    }

    public final ImmutableLngLatAlt withLongitude(double value) {
        if (Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableLngLatAlt(value, this.latitude, this.altitude);
    }

    public final ImmutableLngLatAlt withLatitude(double value) {
        if (Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableLngLatAlt(this.longitude, value, this.altitude);
    }

    public final ImmutableLngLatAlt withAltitude(double value) {
        if (Double.doubleToLongBits(this.altitude) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableLngLatAlt(this.longitude, this.latitude, value);
    }

    public String toString() {
        return MoreObjects.toStringHelper("LngLatAlt").omitNullValues().add("longitude", this.longitude).add("latitude", this.latitude).add("altitude", this.altitude).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLngLatAlt fromJson(Json json) {
        ImmutableLngLatAlt instance = ImmutableLngLatAlt.of(json.longitude, json.latitude, json.altitude);
        return instance;
    }

    public static ImmutableLngLatAlt of(double longitude, double latitude, double altitude) {
        return new ImmutableLngLatAlt(longitude, latitude, altitude);
    }

    public static ImmutableLngLatAlt copyOf(LngLatAlt instance) {
        if (instance instanceof ImmutableLngLatAlt) {
            return (ImmutableLngLatAlt)instance;
        }
        return ImmutableLngLatAlt.of(instance.getLongitude(), instance.getLatitude(), instance.getAltitude());
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LngLatAlt", generator="Immutables")
    static final class Json
    extends LngLatAlt {
        double longitude;
        boolean longitudeIsSet;
        double latitude;
        boolean latitudeIsSet;
        double altitude;
        boolean altitudeIsSet;

        Json() {
        }

        @JsonProperty(value="longitude")
        public void setLongitude(double longitude) {
            this.longitude = longitude;
            this.longitudeIsSet = true;
        }

        @JsonProperty(value="latitude")
        public void setLatitude(double latitude) {
            this.latitude = latitude;
            this.latitudeIsSet = true;
        }

        @JsonProperty(value="altitude")
        public void setAltitude(double altitude) {
            this.altitude = altitude;
            this.altitudeIsSet = true;
        }

        @Override
        public double getLongitude() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getLatitude() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getAltitude() {
            throw new UnsupportedOperationException();
        }
    }
}

