/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.geojson;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonInclude;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.geojson.GeoJsonObject;
import shadow.palantir.driver.com.palantir.geojson.Geometry;
import shadow.palantir.driver.com.palantir.geojson.LngLatAlt;
import shadow.palantir.driver.com.palantir.geojson.MultiLineString;
import shadow.palantir.driver.com.palantir.geojson.RecursiveImmutableListDeserializer;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MultiLineString", generator="Immutables")
@Immutable
public final class ImmutableMultiLineString
extends MultiLineString {
    private final double[] bbox;
    private final ImmutableList<List<LngLatAlt>> coordinates;

    private ImmutableMultiLineString(Iterable<? extends List<LngLatAlt>> coordinates) {
        this.coordinates = ImmutableList.copyOf(coordinates);
        this.bbox = (double[])super.getBbox().clone();
    }

    private ImmutableMultiLineString(Builder builder) {
        this.coordinates = builder.coordinates.build();
        this.bbox = builder.bbox != null ? builder.bbox : (double[])super.getBbox().clone();
    }

    private ImmutableMultiLineString(double[] bbox, ImmutableList<List<LngLatAlt>> coordinates) {
        this.bbox = bbox;
        this.coordinates = coordinates;
    }

    @Override
    @JsonProperty(value="bbox")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public double[] getBbox() {
        return (double[])this.bbox.clone();
    }

    @JsonProperty(value="coordinates")
    @JsonDeserialize(using=RecursiveImmutableListDeserializer.class)
    public ImmutableList<List<LngLatAlt>> getCoordinates() {
        return this.coordinates;
    }

    public final ImmutableMultiLineString withBbox(double ... elements) {
        double[] newValue = (double[])elements.clone();
        return new ImmutableMultiLineString(newValue, this.coordinates);
    }

    @SafeVarargs
    public final ImmutableMultiLineString withCoordinates(List<LngLatAlt> ... elements) {
        ImmutableList<List<LngLatAlt>> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMultiLineString(this.bbox, newValue);
    }

    public final ImmutableMultiLineString withCoordinates(Iterable<? extends List<LngLatAlt>> elements) {
        if (this.coordinates == elements) {
            return this;
        }
        ImmutableList<List<LngLatAlt>> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMultiLineString(this.bbox, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMultiLineString && this.equalTo(0, (ImmutableMultiLineString)another);
    }

    private boolean equalTo(int synthetic, ImmutableMultiLineString another) {
        return Arrays.equals(this.bbox, another.bbox) && this.coordinates.equals(another.coordinates);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.bbox);
        h += (h << 5) + this.coordinates.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MultiLineString").omitNullValues().add("bbox", Arrays.toString(this.bbox)).add("coordinates", this.coordinates).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMultiLineString fromJson(Json json) {
        Builder builder = ImmutableMultiLineString.builder();
        if (json.bbox != null) {
            builder.bbox(json.bbox);
        }
        if (json.coordinates != null) {
            builder.addAllCoordinates(json.coordinates);
        }
        return builder.build();
    }

    public static ImmutableMultiLineString of(List<List<LngLatAlt>> coordinates) {
        return ImmutableMultiLineString.of(coordinates);
    }

    public static ImmutableMultiLineString of(Iterable<? extends List<LngLatAlt>> coordinates) {
        return new ImmutableMultiLineString(coordinates);
    }

    public static ImmutableMultiLineString copyOf(MultiLineString instance) {
        if (instance instanceof ImmutableMultiLineString) {
            return (ImmutableMultiLineString)instance;
        }
        return ImmutableMultiLineString.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MultiLineString", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private double[] bbox;
        private ImmutableList.Builder<List<LngLatAlt>> coordinates = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Geometry instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(GeoJsonObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(MultiLineString instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            GeoJsonObject instance;
            long bits = 0L;
            if (object instanceof Geometry) {
                instance = (Geometry)object;
                if ((bits & 1L) == 0L) {
                    this.bbox(instance.getBbox());
                    bits |= 1L;
                }
            }
            if (object instanceof GeoJsonObject) {
                instance = (GeoJsonObject)object;
                if ((bits & 1L) == 0L) {
                    this.bbox(instance.getBbox());
                    bits |= 1L;
                }
            }
            if (object instanceof MultiLineString) {
                instance = (MultiLineString)object;
                this.addAllCoordinates(((MultiLineString)instance).getCoordinates());
                if ((bits & 1L) == 0L) {
                    this.bbox(instance.getBbox());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder bbox(double ... bbox) {
            this.bbox = (double[])bbox.clone();
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCoordinates(List<LngLatAlt> element) {
            this.coordinates.add((Object)element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addCoordinates(List<LngLatAlt> ... elements) {
            this.coordinates.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder coordinates(Iterable<? extends List<LngLatAlt>> elements) {
            this.coordinates = ImmutableList.builder();
            return this.addAllCoordinates(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCoordinates(Iterable<? extends List<LngLatAlt>> elements) {
            this.coordinates.addAll(elements);
            return this;
        }

        public ImmutableMultiLineString build() {
            return new ImmutableMultiLineString(this);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MultiLineString", generator="Immutables")
    static final class Json
    extends MultiLineString {
        @Nullable
        double[] bbox;
        @Nullable
        List<List<LngLatAlt>> coordinates = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="bbox")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setBbox(double[] bbox) {
            this.bbox = bbox;
        }

        @JsonProperty(value="coordinates")
        @JsonDeserialize(using=RecursiveImmutableListDeserializer.class)
        public void setCoordinates(List<List<LngLatAlt>> coordinates) {
            this.coordinates = coordinates;
        }

        @Override
        public double[] getBbox() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<List<LngLatAlt>> getCoordinates() {
            throw new UnsupportedOperationException();
        }
    }
}

