/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.geojson;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonInclude;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.geojson.GeoJsonObject;
import shadow.palantir.driver.com.palantir.geojson.Geometry;
import shadow.palantir.driver.com.palantir.geojson.LngLatAlt;
import shadow.palantir.driver.com.palantir.geojson.MultiPoint;
import shadow.palantir.driver.com.palantir.geojson.PackedLngLatAltList;
import shadow.palantir.driver.com.palantir.geojson.RecursiveImmutableListDeserializer;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MultiPoint", generator="Immutables")
@Immutable
public final class ImmutableMultiPoint
extends MultiPoint {
    private final double[] bbox;
    private final PackedLngLatAltList coordinates;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMultiPoint(Iterable<? extends LngLatAlt> coordinates) {
        this.coordinates = PackedLngLatAltList.packedCopyOf(coordinates);
        this.bbox = this.initShim.getBbox();
        this.initShim = null;
    }

    private ImmutableMultiPoint(Builder builder) {
        this.coordinates = builder.coordinates_build();
        if (builder.bbox != null) {
            this.initShim.bbox(builder.bbox);
        }
        this.bbox = this.initShim.getBbox();
        this.initShim = null;
    }

    private ImmutableMultiPoint(double[] bbox, PackedLngLatAltList coordinates) {
        this.bbox = bbox;
        this.coordinates = coordinates;
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="bbox")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public double[] getBbox() {
        InitShim shim = this.initShim;
        return shim != null ? (double[])shim.getBbox().clone() : (double[])this.bbox.clone();
    }

    @Override
    @JsonProperty(value="coordinates")
    @JsonDeserialize(using=RecursiveImmutableListDeserializer.class)
    public List<LngLatAlt> getCoordinates() {
        return this.coordinates;
    }

    public final ImmutableMultiPoint withBbox(double ... elements) {
        double[] newValue = (double[])elements.clone();
        return new ImmutableMultiPoint(newValue, this.coordinates);
    }

    public ImmutableMultiPoint withCoordinates(Iterable<? extends LngLatAlt> init) {
        PackedLngLatAltList newValue = PackedLngLatAltList.packedCopyOf(init);
        if (this.coordinates == newValue) {
            return this;
        }
        return new ImmutableMultiPoint(this.bbox, newValue);
    }

    public ImmutableMultiPoint withCoordinates(LngLatAlt ... init) {
        PackedLngLatAltList newValue = PackedLngLatAltList.packedOf(init);
        if (this.coordinates == newValue) {
            return this;
        }
        return new ImmutableMultiPoint(this.bbox, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMultiPoint && this.equalTo(0, (ImmutableMultiPoint)another);
    }

    private boolean equalTo(int synthetic, ImmutableMultiPoint another) {
        return Arrays.equals(this.bbox, another.bbox) && this.getCoordinates().equals(another.getCoordinates());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.bbox);
        h += (h << 5) + this.getCoordinates().hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MultiPoint").omitNullValues().add("bbox", Arrays.toString(this.bbox)).add("coordinates", this.getCoordinates().toString()).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMultiPoint fromJson(Json json) {
        Builder builder = ImmutableMultiPoint.builder();
        if (json.bbox != null) {
            builder.bbox(json.bbox);
        }
        if (json.coordinates != null) {
            builder.coordinates(json.coordinates);
        }
        return builder.build();
    }

    public static ImmutableMultiPoint of(Iterable<? extends LngLatAlt> coordinates) {
        return new ImmutableMultiPoint(coordinates);
    }

    public static ImmutableMultiPoint copyOf(MultiPoint instance) {
        if (instance instanceof ImmutableMultiPoint) {
            return (ImmutableMultiPoint)instance;
        }
        return ImmutableMultiPoint.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MultiPoint", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private PackedLngLatAltList coordinates_value = null;
        private PackedLngLatAltList.PackedBuilder coordinates_builder = null;
        @Nullable
        private double[] bbox;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MultiPoint instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Geometry instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(GeoJsonObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            GeoJsonObject instance;
            long bits = 0L;
            if (object instanceof MultiPoint) {
                instance = (MultiPoint)object;
                this.coordinates(((MultiPoint)instance).getCoordinates());
                if ((bits & 1L) == 0L) {
                    this.bbox(instance.getBbox());
                    bits |= 1L;
                }
            }
            if (object instanceof Geometry) {
                instance = (Geometry)object;
                if ((bits & 1L) == 0L) {
                    this.bbox(instance.getBbox());
                    bits |= 1L;
                }
            }
            if (object instanceof GeoJsonObject) {
                instance = (GeoJsonObject)object;
                if ((bits & 1L) == 0L) {
                    this.bbox(instance.getBbox());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder bbox(double ... bbox) {
            this.bbox = (double[])bbox.clone();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder coordinates(Iterable<? extends LngLatAlt> init) {
            if (init instanceof Collection && ((Collection)init).isEmpty()) {
                this.coordinates_builder = null;
                this.coordinates_value = null;
            } else if (init instanceof PackedLngLatAltList) {
                this.coordinates_builder = null;
                this.coordinates_value = (PackedLngLatAltList)init;
            } else {
                this.coordinates_value = null;
                this.coordinates_builder = PackedLngLatAltList.packedBuilder().addAll(init);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addCoordinates(LngLatAlt pt) {
            this.coordinates_builder().add(pt);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addCoordinates(double lng, double lat) {
            this.coordinates_builder().add(lng, lat);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addCoordinates(double lng, double lat, double alt) {
            this.coordinates_builder().add(lng, lat, alt);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addCoordinates(LngLatAlt ... pt) {
            this.coordinates_builder().addAll(pt);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllCoordinates(Iterable<? extends LngLatAlt> points) {
            if (this.coordinates_builder == null && this.coordinates_value == null && points instanceof PackedLngLatAltList) {
                this.coordinates_value = (PackedLngLatAltList)points;
            } else {
                this.coordinates_builder().addAll(points);
            }
            return this;
        }

        public ImmutableMultiPoint build() {
            return new ImmutableMultiPoint(this);
        }

        private PackedLngLatAltList coordinates_build() {
            if (this.coordinates_value != null) {
                if (this.coordinates_builder != null) {
                    throw new SafeIllegalStateException("When value is set builder must not be set", new Arg[0]);
                }
                return this.coordinates_value;
            }
            if (this.coordinates_builder != null) {
                return this.coordinates_builder.build();
            }
            return PackedLngLatAltList.empty();
        }

        private PackedLngLatAltList.PackedBuilder coordinates_builder() {
            if (this.coordinates_builder == null) {
                this.coordinates_builder = PackedLngLatAltList.packedBuilder();
                if (this.coordinates_value != null) {
                    this.coordinates_builder.addAll(this.coordinates_value);
                    this.coordinates_value = null;
                }
            }
            if (this.coordinates_value != null) {
                throw new SafeIllegalStateException("When builder is set value must not be set", new Arg[0]);
            }
            return this.coordinates_builder;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MultiPoint", generator="Immutables")
    static final class Json
    extends MultiPoint {
        @Nullable
        double[] bbox;
        @Nullable
        List<LngLatAlt> coordinates;

        Json() {
        }

        @JsonProperty(value="bbox")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setBbox(double[] bbox) {
            this.bbox = bbox;
        }

        @JsonProperty(value="coordinates")
        @JsonDeserialize(using=RecursiveImmutableListDeserializer.class)
        public void setCoordinates(List<LngLatAlt> coordinates) {
            this.coordinates = coordinates;
        }

        @Override
        public double[] getBbox() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<LngLatAlt> getCoordinates() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="MultiPoint", generator="Immutables")
    private final class InitShim {
        private byte bboxBuildStage = 0;
        private double[] bbox;

        private InitShim() {
        }

        double[] getBbox() {
            if (this.bboxBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bboxBuildStage == 0) {
                this.bboxBuildStage = (byte)-1;
                this.bbox = (double[])ImmutableMultiPoint.super.getBbox().clone();
                this.bboxBuildStage = 1;
            }
            return this.bbox;
        }

        void bbox(double[] bbox) {
            this.bbox = bbox;
            this.bboxBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.bboxBuildStage == -1) {
                attributes.add("bbox");
            }
            return "Cannot build MultiPoint, attribute initializers form cycle " + attributes;
        }
    }
}

