/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.geojson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonInclude;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.geojson.GeoJsonObject;
import shadow.palantir.driver.com.palantir.geojson.Geometry;
import shadow.palantir.driver.com.palantir.geojson.LeafGeometry;
import shadow.palantir.driver.com.palantir.geojson.LngLatAlt;
import shadow.palantir.driver.com.palantir.geojson.Point;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Point", generator="Immutables")
@Immutable
public final class ImmutablePoint
extends Point {
    private final double[] bbox;
    private final LngLatAlt coordinates;

    private ImmutablePoint(LngLatAlt coordinates) {
        this.coordinates = Objects.requireNonNull(coordinates, "coordinates");
        this.bbox = (double[])super.getBbox().clone();
    }

    private ImmutablePoint(Builder builder) {
        this.coordinates = builder.coordinates;
        this.bbox = builder.bbox != null ? builder.bbox : (double[])super.getBbox().clone();
    }

    private ImmutablePoint(double[] bbox, LngLatAlt coordinates) {
        this.bbox = bbox;
        this.coordinates = coordinates;
    }

    @Override
    @JsonProperty(value="bbox")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public double[] getBbox() {
        return (double[])this.bbox.clone();
    }

    @Override
    @JsonProperty(value="coordinates")
    public LngLatAlt getCoordinates() {
        return this.coordinates;
    }

    public final ImmutablePoint withBbox(double ... elements) {
        double[] newValue = (double[])elements.clone();
        return new ImmutablePoint(newValue, this.coordinates);
    }

    public final ImmutablePoint withCoordinates(LngLatAlt value) {
        if (this.coordinates == value) {
            return this;
        }
        LngLatAlt newValue = Objects.requireNonNull(value, "coordinates");
        return new ImmutablePoint(this.bbox, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePoint && this.equalTo(0, (ImmutablePoint)another);
    }

    private boolean equalTo(int synthetic, ImmutablePoint another) {
        return Arrays.equals(this.bbox, another.bbox) && this.coordinates.equals(another.coordinates);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.bbox);
        h += (h << 5) + this.coordinates.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Point").omitNullValues().add("bbox", Arrays.toString(this.bbox)).add("coordinates", this.coordinates).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePoint fromJson(Json json) {
        Builder builder = ImmutablePoint.builder();
        if (json.bbox != null) {
            builder.bbox(json.bbox);
        }
        if (json.coordinates != null) {
            builder.coordinates(json.coordinates);
        }
        return builder.build();
    }

    public static ImmutablePoint of(LngLatAlt coordinates) {
        return new ImmutablePoint(coordinates);
    }

    public static ImmutablePoint copyOf(Point instance) {
        if (instance instanceof ImmutablePoint) {
            return (ImmutablePoint)instance;
        }
        return ImmutablePoint.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Point", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COORDINATES = 1L;
        private long initBits = 1L;
        @Nullable
        private double[] bbox;
        @Nullable
        private LngLatAlt coordinates;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Point instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Geometry instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(GeoJsonObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(LeafGeometry instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            GeoJsonObject instance;
            long bits = 0L;
            if (object instanceof Point) {
                instance = (Point)object;
                this.coordinates(((Point)instance).getCoordinates());
            }
            if (object instanceof Geometry) {
                instance = (Geometry)object;
                if ((bits & 1L) == 0L) {
                    this.bbox(instance.getBbox());
                    bits |= 1L;
                }
            }
            if (object instanceof GeoJsonObject) {
                instance = (GeoJsonObject)object;
                if ((bits & 1L) == 0L) {
                    this.bbox(instance.getBbox());
                    bits |= 1L;
                }
            }
            if (object instanceof LeafGeometry) {
                instance = (LeafGeometry)object;
                if ((bits & 1L) == 0L) {
                    this.bbox(instance.getBbox());
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="bbox")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @CanIgnoreReturnValue
        public final Builder bbox(double ... bbox) {
            this.bbox = (double[])bbox.clone();
            return this;
        }

        @JsonProperty(value="coordinates")
        @CanIgnoreReturnValue
        public final Builder coordinates(LngLatAlt coordinates) {
            this.coordinates = Objects.requireNonNull(coordinates, "coordinates");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePoint build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePoint(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("coordinates");
            }
            return "Cannot build Point, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Point", generator="Immutables")
    static final class Json
    extends Point {
        @Nullable
        double[] bbox;
        @Nullable
        LngLatAlt coordinates;

        Json() {
        }

        @JsonProperty(value="bbox")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setBbox(double[] bbox) {
            this.bbox = bbox;
        }

        @JsonProperty(value="coordinates")
        public void setCoordinates(LngLatAlt coordinates) {
            this.coordinates = coordinates;
        }

        @Override
        public double[] getBbox() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LngLatAlt getCoordinates() {
            throw new UnsupportedOperationException();
        }
    }
}

