/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.geojson;

import java.util.Iterator;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.palantir.geojson.GeoJsonLeafVisitor;
import shadow.palantir.driver.com.palantir.geojson.ImmutableLineString;
import shadow.palantir.driver.com.palantir.geojson.LeafGeometry;
import shadow.palantir.driver.com.palantir.geojson.LngLatAlt;
import shadow.palantir.driver.com.palantir.geojson.RecursiveImmutableListDeserializer;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonTypeName(value="LineString")
@JsonSerialize(as=ImmutableLineString.class)
@Value.Immutable
public abstract class LineString
implements LeafGeometry,
Iterable<LngLatAlt> {
    public static final String TYPE = "LineString";

    public static ImmutableLineString of(Iterable<? extends LngLatAlt> points) {
        if (points instanceof ImmutableLineString) {
            return (ImmutableLineString)points;
        }
        return ImmutableLineString.of(points);
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLineString fromJson(ImmutableLineString.Json json) {
        ImmutableLineString result = ImmutableLineString.of(json.coordinates == null ? ImmutableList.of() : json.coordinates);
        if (json.bbox != null && json.bbox.length > 0) {
            result = result.withBbox(json.bbox);
        }
        return result;
    }

    @JsonDeserialize(using=RecursiveImmutableListDeserializer.class)
    @Value.Parameter
    public abstract List<LngLatAlt> getCoordinates();

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public <T> T accept(GeoJsonLeafVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    @Nonnull
    public Iterator<LngLatAlt> iterator() {
        return this.getCoordinates().iterator();
    }
}

