/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.geojson;

import java.io.IOException;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonGenerator;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonParser;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonToken;
import shadow.palantir.driver.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.palantir.driver.com.fasterxml.jackson.databind.JsonDeserializer;
import shadow.palantir.driver.com.fasterxml.jackson.databind.JsonSerializer;
import shadow.palantir.driver.com.fasterxml.jackson.databind.SerializerProvider;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.google.common.primitives.Doubles;
import shadow.palantir.driver.com.palantir.geojson.ImmutableLngLatAlt;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
@Value.Immutable(builder=false)
@Value.Style(allParameters=true, builderVisibility=Value.Style.BuilderVisibility.PACKAGE)
public abstract class LngLatAlt {
    public static LngLatAlt of(double longitude, double latitude) {
        return ImmutableLngLatAlt.of(longitude, latitude, Double.NaN);
    }

    public static LngLatAlt of(double longitude, double latitude, double altitude) {
        return ImmutableLngLatAlt.of(longitude, latitude, altitude);
    }

    public abstract double getLongitude();

    public abstract double getLatitude();

    @Value.Default
    public double getAltitude() {
        return Double.NaN;
    }

    public boolean hasAltitude() {
        return !Double.isNaN(this.getAltitude());
    }

    public final boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof LngLatAlt && this.equalTo((LngLatAlt)another);
    }

    public final int hashCode() {
        return LngLatAlt.hashCode(this.getLongitude(), this.getLatitude(), this.getAltitude());
    }

    public static int hashCode(double longitude, double latitude, double altitude) {
        int hash = 5381;
        hash += (hash << 5) + Doubles.hashCode(longitude);
        hash += (hash << 5) + Doubles.hashCode(latitude);
        hash += (hash << 5) + Doubles.hashCode(altitude);
        return hash;
    }

    private boolean equalTo(LngLatAlt another) {
        return Double.doubleToLongBits(this.getLongitude()) == Double.doubleToLongBits(another.getLongitude()) && Double.doubleToLongBits(this.getLatitude()) == Double.doubleToLongBits(another.getLatitude()) && Double.doubleToLongBits(this.getAltitude()) == Double.doubleToLongBits(another.getAltitude());
    }

    static class Deserializer
    extends JsonDeserializer<LngLatAlt> {
        Deserializer() {
        }

        @Override
        public LngLatAlt deserialize(JsonParser jp, DeserializationContext _ctxt) throws IOException {
            if (jp.getCurrentToken() == JsonToken.START_ARRAY) {
                jp.nextToken();
            }
            double longitude = jp.getDoubleValue();
            jp.nextToken();
            double latitude = jp.getDoubleValue();
            if (jp.nextToken() == JsonToken.END_ARRAY) {
                return LngLatAlt.of(longitude, latitude);
            }
            double altitude = jp.getDoubleValue();
            jp.nextToken();
            return LngLatAlt.of(longitude, latitude, altitude);
        }
    }

    static class Serializer
    extends JsonSerializer<LngLatAlt> {
        Serializer() {
        }

        @Override
        public void serialize(LngLatAlt value, JsonGenerator jgen, SerializerProvider _provider) throws IOException {
            jgen.writeStartArray();
            jgen.writeNumber(value.getLongitude());
            jgen.writeNumber(value.getLatitude());
            if (value.hasAltitude()) {
                jgen.writeNumber(value.getAltitude());
            }
            jgen.writeEndArray();
        }
    }
}

