/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.geojson;

import java.util.Iterator;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.palantir.geojson.Geometry;
import shadow.palantir.driver.com.palantir.geojson.GeometryVisitor;
import shadow.palantir.driver.com.palantir.geojson.ImmutableMultiPolygon;
import shadow.palantir.driver.com.palantir.geojson.LngLatAlt;
import shadow.palantir.driver.com.palantir.geojson.RecursiveImmutableListDeserializer;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonTypeName(value="MultiPolygon")
@JsonSerialize(as=ImmutableMultiPolygon.class)
@Value.Immutable
public abstract class MultiPolygon
implements Geometry,
Iterable<List<List<LngLatAlt>>> {
    public static final String TYPE = "MultiPolygon";

    public static ImmutableMultiPolygon of(Iterable<? extends List<List<LngLatAlt>>> polygons) {
        if (polygons instanceof ImmutableMultiPolygon) {
            return (ImmutableMultiPolygon)polygons;
        }
        return ImmutableMultiPolygon.of(ImmutableList.copyOf(polygons));
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMultiPolygon fromJson(ImmutableMultiPolygon.Json json) {
        ImmutableMultiPolygon result = ImmutableMultiPolygon.of(json.coordinates == null ? ImmutableList.of() : json.coordinates);
        if (json.bbox != null && json.bbox.length > 0) {
            result = result.withBbox(json.bbox);
        }
        return result;
    }

    @JsonDeserialize(using=RecursiveImmutableListDeserializer.class)
    @Value.Parameter
    public abstract List<List<List<LngLatAlt>>> getCoordinates();

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public <T> T accept(GeometryVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    @Nonnull
    public Iterator<List<List<LngLatAlt>>> iterator() {
        return this.getCoordinates().iterator();
    }
}

