/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.geojson;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonGenerator;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonParser;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonToken;
import shadow.palantir.driver.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.palantir.driver.com.fasterxml.jackson.databind.SerializerProvider;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import shadow.palantir.driver.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import shadow.palantir.driver.com.fasterxml.jackson.databind.util.ArrayBuilders;
import shadow.palantir.driver.com.palantir.geojson.CoordinateIterator;
import shadow.palantir.driver.com.palantir.geojson.LngLatAlt;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.jetbrains.annotations.Nullable;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class PackedLngLatAltList
extends AbstractList<LngLatAlt>
implements RandomAccess {
    private static final PackedLngLatAltList EMPTY = new PackedLngLatAltList(DoubleBuffer.allocate(0), 2);
    private final DoubleBuffer buffer;
    private final int stride;
    private final int size;

    private PackedLngLatAltList(DoubleBuffer buffer, int stride) {
        this.buffer = buffer.slice();
        this.stride = stride;
        if (stride < 2) {
            throw new SafeIllegalArgumentException("Stride must be at least two", SafeArg.of("stride", stride));
        }
        if (this.buffer.capacity() % stride != 0) {
            throw new SafeIllegalArgumentException("Packed coordinate array has extra elements", SafeArg.of("packedSize", buffer.capacity()), SafeArg.of("stride", stride));
        }
        this.size = this.buffer.capacity() / stride;
    }

    public static PackedLngLatAltList empty() {
        return EMPTY;
    }

    public static PackedLngLatAltList packedOf(LngLatAlt ... points) {
        if (points.length == 0) {
            return PackedLngLatAltList.empty();
        }
        return PackedLngLatAltList.packedBuilder().addAll(Arrays.asList(points)).build();
    }

    public static PackedLngLatAltList packedCopyOf(Iterable<? extends LngLatAlt> points) {
        if (points instanceof Collection && ((Collection)points).isEmpty()) {
            return PackedLngLatAltList.empty();
        }
        if (points instanceof PackedLngLatAltList) {
            return (PackedLngLatAltList)points;
        }
        return PackedLngLatAltList.packedBuilder().addAll(points).build();
    }

    public static PackedLngLatAltList packedCopyOf(DoubleBuffer packedCoordinates, int stride) {
        double[] target = new double[packedCoordinates.remaining()];
        packedCoordinates.slice().get(target);
        return new PackedLngLatAltList(DoubleBuffer.wrap(target), stride);
    }

    @Override
    public int size() {
        return this.size;
    }

    public void copyTo(DoubleBuffer target, int targetStride, boolean fillMissing) {
        if (this.stride == targetStride) {
            target.put(this.buffer.duplicate());
            return;
        }
        int minStride = Math.min(this.stride, targetStride);
        int srcI = 0;
        int dstI = target.position();
        while (srcI < this.buffer.capacity()) {
            for (int i = 0; i < minStride; ++i) {
                target.put(dstI + i, this.buffer.get(srcI + i));
            }
            for (int j = minStride; fillMissing && j < targetStride; ++j) {
                target.put(dstI + j, Double.NaN);
            }
            srcI += this.stride;
            dstI += targetStride;
        }
        target.position(target.position() + this.size() * targetStride);
    }

    public double getLng(int index) {
        return this.buffer.get(index * this.stride);
    }

    public double getLat(int index) {
        return this.buffer.get(index * this.stride + 1);
    }

    private double getAltitudeInternal(int offset) {
        return this.stride >= 3 ? this.buffer.get(offset + 2) : Double.NaN;
    }

    public double getAltitude(int index) {
        return this.stride >= 3 ? this.buffer.get(index * this.stride + 2) : Double.NaN;
    }

    public boolean hasAltitude(int index) {
        return Double.isNaN(this.getAltitude(index));
    }

    @Override
    public LngLatAlt get(int index) {
        int offset = index * this.stride;
        return LngLatAlt.of(this.buffer.get(offset), this.buffer.get(offset + 1), this.getAltitudeInternal(offset));
    }

    @Nonnull
    public PackedLngLatAltList subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size || toIndex < fromIndex) {
            throw new SafeIllegalArgumentException("Invalid range", SafeArg.of("fromIndex", fromIndex), SafeArg.of("toIndex", toIndex), SafeArg.of("size", this.size));
        }
        return new PackedLngLatAltList(this.buffer.duplicate().limit(toIndex * this.stride).position(fromIndex * this.stride), this.stride);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof PackedLngLatAltList) {
            return this.packedEquals((PackedLngLatAltList)obj);
        }
        return super.equals(obj);
    }

    private boolean packedEquals(PackedLngLatAltList other) {
        if (other.size() != this.size()) {
            return false;
        }
        DoubleBuffer otherBuffer = other.buffer;
        if (other.stride == this.stride) {
            return otherBuffer.equals(this.buffer);
        }
        int capacity = this.buffer.capacity();
        int thisI = 0;
        int otherI = 0;
        while (thisI < capacity) {
            if (PackedLngLatAltList.doublesDiffer(this.buffer.get(thisI), otherBuffer.get(otherI))) {
                return false;
            }
            if (PackedLngLatAltList.doublesDiffer(this.buffer.get(thisI + 1), otherBuffer.get(otherI + 1))) {
                return false;
            }
            if (PackedLngLatAltList.doublesDiffer(this.getAltitudeInternal(thisI), other.getAltitudeInternal(otherI))) {
                return false;
            }
            thisI += this.stride;
            otherI += other.stride;
        }
        return true;
    }

    private static boolean doublesDiffer(double left, double right) {
        return Double.doubleToLongBits(left) != Double.doubleToLongBits(right);
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int count = this.buffer.capacity();
        for (int i = 0; i < count; i += this.stride) {
            hashCode = 31 * hashCode + LngLatAlt.hashCode(this.buffer.get(i), this.buffer.get(i + 1), this.getAltitudeInternal(i));
        }
        return hashCode;
    }

    public PackedIterator packedIterator() {
        return new PackedIterator();
    }

    public static PackedBuilder packedBuilder() {
        return new PackedBuilder(new ArrayBuilders.DoubleBuilder());
    }

    public final class PackedIterator
    implements CoordinateIterator {
        private int index;
        private int offset;

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public double getLng() {
            return PackedLngLatAltList.this.buffer.get(this.offset);
        }

        @Override
        public double getLat() {
            return PackedLngLatAltList.this.buffer.get(this.offset + 1);
        }

        @Override
        public double getAltitude() {
            return PackedLngLatAltList.this.getAltitudeInternal(this.offset);
        }

        @Override
        public void next() {
            Preconditions.checkState(this.isValid(), "Iterator is not valid");
            ++this.index;
            this.offset += PackedLngLatAltList.this.stride;
        }

        @Override
        public boolean isValid() {
            return this.index < PackedLngLatAltList.this.size;
        }
    }

    public static final class Deserializer
    extends StdDeserializer<PackedLngLatAltList> {
        public Deserializer() {
            super(PackedLngLatAltList.class);
        }

        @Override
        public PackedLngLatAltList deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
            JsonToken token;
            PackedBuilder builder = new PackedBuilder(ctxt.getArrayBuilders().getDoubleBuilder());
            while ((token = parser.nextToken()) != JsonToken.END_ARRAY) {
                if (token != JsonToken.START_ARRAY) {
                    return (PackedLngLatAltList)ctxt.handleUnexpectedToken(LngLatAlt.class, token, parser, "Expected start array token for LngLatAlt", new Object[0]);
                }
                parser.nextToken();
                double lng = this._parseDoublePrimitive(parser, ctxt);
                parser.nextToken();
                double lat = this._parseDoublePrimitive(parser, ctxt);
                token = parser.nextToken();
                double alt = Double.NaN;
                if (token != JsonToken.END_ARRAY) {
                    alt = this._parseDoublePrimitive(parser, ctxt);
                    token = parser.nextToken();
                }
                if (token != JsonToken.END_ARRAY) {
                    return (PackedLngLatAltList)ctxt.handleUnexpectedToken(LngLatAlt.class, token, parser, "Expected 2 or 3 component array for LngLatAlt", new Object[0]);
                }
                builder.add(lng, lat, alt);
            }
            return builder.build();
        }
    }

    public static final class Serializer
    extends StdSerializer<PackedLngLatAltList> {
        public Serializer() {
            super(PackedLngLatAltList.class);
        }

        @Override
        public void serialize(PackedLngLatAltList value, JsonGenerator gen, SerializerProvider _provider) throws IOException {
            gen.writeStartArray(value, value.size());
            DoubleBuffer buf = value.buffer;
            boolean hasAlt = value.stride >= 3;
            for (int i = 0; i < buf.capacity(); i += value.stride) {
                double alt;
                gen.writeStartArray();
                gen.writeNumber(buf.get(i));
                gen.writeNumber(buf.get(i + 1));
                if (hasAlt && !Double.isNaN(alt = buf.get(i + 2))) {
                    gen.writeNumber(alt);
                }
                gen.writeEndArray();
            }
            gen.writeEndArray();
        }
    }

    @NotThreadSafe
    public static final class PackedBuilder {
        private boolean hasAltitudes;
        private final ArrayBuilders.DoubleBuilder arrayBuilder;
        private int ix;
        private double[] chunk;

        PackedBuilder(ArrayBuilders.DoubleBuilder arrayBuilder) {
            this.arrayBuilder = arrayBuilder;
            this.hasAltitudes = false;
            this.resetAndStart();
        }

        private int stride() {
            return this.hasAltitudes ? 3 : 2;
        }

        private void resetAndStart() {
            this.chunk = (double[])this.arrayBuilder.resetAndStart();
            this.ix = 0;
        }

        private void ensureElevations() {
            if (this.hasAltitudes) {
                return;
            }
            double[] full = this.arrayBuilder.completeAndClearBuffer(this.chunk, this.ix);
            this.resetAndStart();
            for (int i = 0; i < full.length; i += 2) {
                this.add(full[i]);
                this.add(full[i + 1]);
                this.add(Double.NaN);
            }
            this.hasAltitudes = true;
        }

        private void add(double value) {
            if (this.ix >= this.chunk.length) {
                this.chunk = this.arrayBuilder.appendCompletedChunk(this.chunk, this.ix);
                this.ix = 0;
            }
            this.chunk[this.ix++] = value;
        }

        public PackedBuilder add(double lng, double lat) {
            this.add(lng);
            this.add(lat);
            if (this.hasAltitudes) {
                this.add(Double.NaN);
            }
            return this;
        }

        public PackedBuilder add(double lng, double lat, double alt) {
            if (!Double.isNaN(alt)) {
                this.ensureElevations();
            }
            this.add(lng);
            this.add(lat);
            if (this.hasAltitudes) {
                this.add(alt);
            }
            return this;
        }

        public PackedBuilder add(LngLatAlt pt) {
            return this.add(pt.getLongitude(), pt.getLatitude(), pt.getAltitude());
        }

        public PackedBuilder addAll(LngLatAlt ... pts) {
            for (LngLatAlt pt : pts) {
                this.add(pt);
            }
            return this;
        }

        public PackedBuilder addAll(Iterable<? extends LngLatAlt> pts) {
            if (pts instanceof PackedLngLatAltList) {
                this.addAllPacked((PackedLngLatAltList)pts);
            } else {
                for (LngLatAlt lngLatAlt : pts) {
                    this.add(lngLatAlt);
                }
            }
            return this;
        }

        private void addAllPacked(PackedLngLatAltList packed) {
            DoubleBuffer buf = packed.buffer;
            int srcI = 0;
            int limit = buf.capacity();
            while (this.stride() != packed.stride) {
                if (srcI >= limit) {
                    return;
                }
                if (packed.stride >= 3) {
                    this.add(buf.get(srcI), buf.get(srcI + 1), buf.get(srcI + 2));
                } else {
                    this.add(buf.get(srcI), buf.get(srcI + 1));
                }
                srcI += packed.stride;
            }
            DoubleBuffer src = buf.duplicate().position(srcI);
            while (true) {
                int chunkRemaining;
                int srcRemaining;
                if ((srcRemaining = src.remaining()) < (chunkRemaining = this.chunk.length - this.ix)) {
                    src.get(this.chunk, this.ix, srcRemaining);
                    this.ix += srcRemaining;
                    return;
                }
                src.get(this.chunk, this.ix, chunkRemaining);
                this.chunk = this.arrayBuilder.appendCompletedChunk(this.chunk, this.ix + chunkRemaining);
                this.ix = 0;
            }
        }

        public PackedLngLatAltList build() {
            if (this.ix + this.arrayBuilder.bufferedSize() == 0) {
                return PackedLngLatAltList.empty();
            }
            return new PackedLngLatAltList(DoubleBuffer.wrap(this.arrayBuilder.completeAndClearBuffer(this.chunk, this.ix)), this.stride());
        }
    }
}

