/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.geojson;

import java.util.Iterator;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.palantir.geojson.GeoJsonLeafVisitor;
import shadow.palantir.driver.com.palantir.geojson.ImmutablePolygon;
import shadow.palantir.driver.com.palantir.geojson.LeafGeometry;
import shadow.palantir.driver.com.palantir.geojson.LngLatAlt;
import shadow.palantir.driver.com.palantir.geojson.RecursiveImmutableListDeserializer;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonTypeName(value="Polygon")
@JsonSerialize(as=ImmutablePolygon.class)
@Value.Immutable
@Value.Style(of="ofAll")
public abstract class Polygon
implements LeafGeometry,
Iterable<List<LngLatAlt>> {
    public static final String TYPE = "Polygon";

    public static ImmutablePolygon of(List<LngLatAlt> exterior) {
        return ImmutablePolygon.ofAll(ImmutableList.of(exterior));
    }

    public static ImmutablePolygon of(List<LngLatAlt> exterior, Iterable<? extends List<LngLatAlt>> interior) {
        ImmutablePolygon.Builder builder = ImmutablePolygon.builder().addCoordinates(exterior);
        for (List<LngLatAlt> list : interior) {
            builder.addCoordinates(list);
        }
        return builder.build();
    }

    public static ImmutablePolygon ofAll(Iterable<? extends List<LngLatAlt>> rings) {
        if (rings instanceof ImmutablePolygon) {
            return (ImmutablePolygon)rings;
        }
        return ImmutablePolygon.ofAll(ImmutableList.copyOf(rings));
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePolygon fromJson(ImmutablePolygon.Json json) {
        ImmutablePolygon result = ImmutablePolygon.ofAll(json.coordinates == null ? ImmutableList.of() : json.coordinates);
        if (json.bbox != null && json.bbox.length > 0) {
            result = result.withBbox(json.bbox);
        }
        return result;
    }

    @JsonDeserialize(using=RecursiveImmutableListDeserializer.class)
    @Value.Parameter
    public abstract List<List<LngLatAlt>> getCoordinates();

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public <T> T accept(GeoJsonLeafVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    @Nonnull
    public Iterator<List<LngLatAlt>> iterator() {
        return this.getCoordinates().iterator();
    }

    @JsonIgnore
    public List<LngLatAlt> getExteriorRing() {
        return this.getCoordinates().get(0);
    }

    @JsonIgnore
    public List<List<LngLatAlt>> getInteriorRings() {
        return this.getCoordinates().subList(1, this.getCoordinates().size());
    }
}

