/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.geojson;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonParser;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonToken;
import shadow.palantir.driver.com.fasterxml.jackson.databind.BeanProperty;
import shadow.palantir.driver.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.palantir.driver.com.fasterxml.jackson.databind.JavaType;
import shadow.palantir.driver.com.fasterxml.jackson.databind.JsonDeserializer;
import shadow.palantir.driver.com.fasterxml.jackson.databind.JsonMappingException;
import shadow.palantir.driver.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import shadow.palantir.driver.com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import shadow.palantir.driver.com.fasterxml.jackson.databind.type.SimpleType;
import shadow.palantir.driver.com.fasterxml.jackson.databind.util.ObjectBuffer;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.palantir.geojson.LngLatAlt;
import shadow.palantir.driver.com.palantir.geojson.PackedLngLatAltList;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

final class RecursiveImmutableListDeserializer
extends ContainerDeserializerBase<List<?>>
implements ContextualDeserializer {
    @Nullable
    private final JsonDeserializer<?> valueDeserializer;

    RecursiveImmutableListDeserializer() {
        this(SimpleType.constructUnsafe(List.class), null);
    }

    private RecursiveImmutableListDeserializer(JavaType selfType, @Nullable JsonDeserializer<?> valueDeserializer) {
        super(selfType);
        this.valueDeserializer = valueDeserializer;
    }

    @Override
    @Nullable
    public JsonDeserializer<Object> getContentDeserializer() {
        return this.valueDeserializer;
    }

    @Override
    @Nullable
    public List<?> deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        if (parser.isExpectedStartArrayToken()) {
            JsonToken token;
            JsonDeserializer<?> valueDe = Preconditions.checkNotNull(this.valueDeserializer, "Deserializer isn't contextualized");
            ObjectBuffer objectBuffer = ctxt.leaseObjectBuffer();
            int idx = 0;
            Object[] page = objectBuffer.resetAndStart();
            while ((token = parser.nextToken()) != JsonToken.END_ARRAY) {
                if (token == JsonToken.VALUE_NULL) continue;
                Object value = valueDe.deserialize(parser, ctxt);
                if (idx >= page.length) {
                    page = objectBuffer.appendCompletedChunk(page);
                    idx = 0;
                }
                page[idx++] = value;
            }
            return RecursiveImmutableListDeserializer.createWithoutCopy(objectBuffer.completeAndClearBuffer(page, idx));
        }
        return (List)ctxt.handleUnexpectedToken(this.getValueType(ctxt), parser);
    }

    private static ImmutableList<Object> createWithoutCopy(final Object[] finalValues) {
        return ImmutableList.copyOf(new AbstractCollection<Object>(){

            @Override
            @Nonnull
            public Iterator<Object> iterator() {
                throw new SafeRuntimeException("Collection is not made to be iterated", new Arg[0]);
            }

            @Override
            @Nonnull
            public Object[] toArray() {
                return finalValues;
            }

            @Override
            public int size() {
                return finalValues.length;
            }
        });
    }

    private static JsonDeserializer<?> createDeserializer(DeserializationContext ctxt, JavaType type) throws JsonMappingException {
        JsonDeserializer<Object> newValueDeserializer;
        JavaType content = type.getContentType();
        if (content.getRawClass().equals(List.class)) {
            newValueDeserializer = RecursiveImmutableListDeserializer.createDeserializer(ctxt, content);
        } else {
            if (content.getRawClass().equals(LngLatAlt.class)) {
                return new PackedLngLatAltList.Deserializer();
            }
            newValueDeserializer = ctxt.findRootValueDeserializer(content);
        }
        return new RecursiveImmutableListDeserializer(type, newValueDeserializer);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        return RecursiveImmutableListDeserializer.createDeserializer(ctxt, property.getType());
    }
}

