/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.humanreadabletypes;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.google.errorprone.annotations.DoNotCall;

public final class HumanReadableByteCount
implements Comparable<HumanReadableByteCount>,
Serializable {
    private static final long serialVersionUID = -1847327625440651894L;
    private static final Pattern BYTE_COUNT_PATTERN = Pattern.compile("([0-9]+)\\s?([a-rt-z]+)?s?");
    private static final Map<String, ByteUnit> SUFFIXES = HumanReadableByteCount.createSuffixes();
    private final long size;
    private final ByteUnit unit;

    private static Map<String, ByteUnit> createSuffixes() {
        HashMap<String, ByteUnit> suffixes = new HashMap<String, ByteUnit>();
        suffixes.put("b", ByteUnit.BYTE);
        suffixes.put("byte", ByteUnit.BYTE);
        suffixes.put("k", ByteUnit.KiB);
        suffixes.put("kb", ByteUnit.KiB);
        suffixes.put("kibibyte", ByteUnit.KiB);
        suffixes.put("m", ByteUnit.MiB);
        suffixes.put("mb", ByteUnit.MiB);
        suffixes.put("mibibyte", ByteUnit.MiB);
        suffixes.put("mebibyte", ByteUnit.MiB);
        suffixes.put("g", ByteUnit.GiB);
        suffixes.put("gb", ByteUnit.GiB);
        suffixes.put("gibibyte", ByteUnit.GiB);
        suffixes.put("t", ByteUnit.TiB);
        suffixes.put("tb", ByteUnit.TiB);
        suffixes.put("tebibyte", ByteUnit.TiB);
        suffixes.put("p", ByteUnit.PiB);
        suffixes.put("pb", ByteUnit.PiB);
        suffixes.put("pebibyte", ByteUnit.PiB);
        return suffixes;
    }

    public static HumanReadableByteCount bytes(long size) {
        return new HumanReadableByteCount(size, ByteUnit.BYTE);
    }

    public static HumanReadableByteCount kibibytes(long size) {
        return new HumanReadableByteCount(size, ByteUnit.KiB);
    }

    public static HumanReadableByteCount mebibytes(long size) {
        return new HumanReadableByteCount(size, ByteUnit.MiB);
    }

    public static HumanReadableByteCount gibibytes(long size) {
        return new HumanReadableByteCount(size, ByteUnit.GiB);
    }

    public static HumanReadableByteCount tebibytes(long size) {
        return new HumanReadableByteCount(size, ByteUnit.TiB);
    }

    public static HumanReadableByteCount pebibytes(long size) {
        return new HumanReadableByteCount(size, ByteUnit.PiB);
    }

    @JsonCreator
    public static HumanReadableByteCount valueOf(String byteCount) {
        String lower = byteCount.toLowerCase(Locale.ROOT).trim();
        try {
            Matcher matcher = BYTE_COUNT_PATTERN.matcher(lower);
            Preconditions.checkArgument(matcher.matches(), "Invalid byte string", SafeArg.of("byteCount", byteCount));
            long size = Long.parseLong(matcher.group(1));
            String suffix = matcher.group(2);
            if (suffix != null && !SUFFIXES.containsKey(suffix)) {
                throw new IllegalArgumentException("Invalid byte string: " + byteCount + ". Wrong byte unit");
            }
            return new HumanReadableByteCount(size, suffix != null ? SUFFIXES.get(suffix) : ByteUnit.BYTE);
        }
        catch (NumberFormatException e) {
            String byteError = "Size must be specified as bytes (b), kibibytes (k), mebibytes (m), gibibytes (g), tebibytes (t), or pebibytes(p). E.g. 50b, 100k, or 250m.";
            throw new NumberFormatException(byteError + "\n" + e.getMessage());
        }
    }

    private HumanReadableByteCount(long size, ByteUnit unit) {
        this.size = size;
        this.unit = Preconditions.checkNotNull(unit, "unit must not be null");
    }

    public <T> T map(SizeFunction<T> function) {
        Preconditions.checkNotNull(function, "function must not be null");
        return Preconditions.checkNotNull(function.apply(this.size, this.unit), "result must not be null");
    }

    @Deprecated
    @DoNotCall
    public long getSize() {
        return this.size;
    }

    @Deprecated
    @DoNotCall
    public ByteUnit getUnit() {
        return this.unit;
    }

    public long toBytes() {
        return this.unit.toBytes(this.size);
    }

    @Override
    public int compareTo(HumanReadableByteCount otherByteCount) {
        if (this.unit == otherByteCount.unit) {
            return Long.compare(this.size, otherByteCount.size);
        }
        return Long.compare(this.toBytes(), otherByteCount.toBytes());
    }

    public boolean equals(Object otherByteCount) {
        if (this == otherByteCount) {
            return true;
        }
        if (otherByteCount == null || this.getClass() != otherByteCount.getClass()) {
            return false;
        }
        HumanReadableByteCount other = (HumanReadableByteCount)otherByteCount;
        if (this.unit == other.unit) {
            return this.size == other.size;
        }
        return this.toBytes() == other.toBytes();
    }

    public int hashCode() {
        long bytes = this.toBytes();
        return (int)(bytes ^ bytes >>> 32);
    }

    @JsonValue
    public String toString() {
        String units = this.unit.toString().toLowerCase(Locale.ENGLISH);
        if (this.size == 1L) {
            units = units.substring(0, units.length() - 1);
        }
        return Long.toString(this.size) + " " + units;
    }

    public static enum ByteUnit {
        BYTE(1L, "bytes"),
        KiB(1024L, "kibibytes"),
        MiB((long)Math.pow(1024.0, 2.0), "mebibytes"),
        GiB((long)Math.pow(1024.0, 3.0), "gibibytes"),
        TiB((long)Math.pow(1024.0, 4.0), "tebibytes"),
        PiB((long)Math.pow(1024.0, 5.0), "pebibytes");

        private final long multiplier;
        private final String suffix;

        private ByteUnit(long multiplier, String suffix) {
            this.multiplier = multiplier;
            this.suffix = suffix;
        }

        public long toBytes(long sizeValue) {
            Preconditions.checkArgument(sizeValue >= 0L, "Negative size value. Size must be positive", SafeArg.of("size", sizeValue));
            return sizeValue * this.multiplier;
        }

        public String toString() {
            return this.suffix;
        }
    }

    @FunctionalInterface
    public static interface SizeFunction<T> {
        public T apply(long var1, ByteUnit var3);
    }
}

