/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.logreceiver.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.palantir.conjure.java.lib.SafeLong;
import shadow.palantir.driver.com.palantir.logreceiver.api.Endpoint;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public final class Annotation {
    private final SafeLong timestamp;
    private final String value;
    private final Endpoint endpoint;
    private int memoizedHashCode;

    private Annotation(SafeLong timestamp, String value, Endpoint endpoint) {
        Annotation.validateFields(timestamp, value, endpoint);
        this.timestamp = timestamp;
        this.value = value;
        this.endpoint = endpoint;
    }

    @JsonProperty(value="timestamp")
    @Safe
    public SafeLong getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="value")
    @Safe
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="endpoint")
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof Annotation && this.equalTo((Annotation)other);
    }

    private boolean equalTo(Annotation other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.timestamp.equals(other.timestamp) && this.value.equals(other.value) && this.endpoint.equals(other.endpoint);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.timestamp.hashCode();
            hash = 31 * hash + this.value.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.endpoint.hashCode());
        }
        return result;
    }

    public String toString() {
        return "Annotation{timestamp: " + this.timestamp + ", value: " + this.value + ", endpoint: " + this.endpoint + "}";
    }

    public static Annotation of(@Safe SafeLong timestamp, @Safe String value, Endpoint endpoint) {
        return Annotation.builder().timestamp(timestamp).value(value).endpoint(endpoint).build();
    }

    private static void validateFields(SafeLong timestamp, String value, Endpoint endpoint) {
        List<String> missingFields = null;
        missingFields = Annotation.addFieldIfMissing(missingFields, timestamp, "timestamp");
        missingFields = Annotation.addFieldIfMissing(missingFields, value, "value");
        if ((missingFields = Annotation.addFieldIfMissing(missingFields, endpoint, "endpoint")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(3);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        @Safe
        private SafeLong timestamp;
        @Safe
        private String value;
        private Endpoint endpoint;

        private Builder() {
        }

        public Builder from(Annotation other) {
            this.checkNotBuilt();
            this.timestamp(other.getTimestamp());
            this.value(other.getValue());
            this.endpoint(other.getEndpoint());
            return this;
        }

        @JsonSetter(value="timestamp")
        public Builder timestamp(@Nonnull @Safe SafeLong timestamp) {
            this.checkNotBuilt();
            this.timestamp = Preconditions.checkNotNull(timestamp, "timestamp cannot be null");
            return this;
        }

        @JsonSetter(value="value")
        public Builder value(@Nonnull @Safe String value) {
            this.checkNotBuilt();
            this.value = Preconditions.checkNotNull(value, "value cannot be null");
            return this;
        }

        @JsonSetter(value="endpoint")
        public Builder endpoint(@Nonnull Endpoint endpoint) {
            this.checkNotBuilt();
            this.endpoint = Preconditions.checkNotNull(endpoint, "endpoint cannot be null");
            return this;
        }

        public Annotation build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new Annotation(this.timestamp, this.value, this.endpoint);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

