/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.logreceiver.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public final class Endpoint {
    private final String serviceName;
    private final Optional<String> ipv4;
    private final Optional<String> ipv6;
    private int memoizedHashCode;

    private Endpoint(String serviceName, Optional<String> ipv4, Optional<String> ipv6) {
        Endpoint.validateFields(serviceName, ipv4, ipv6);
        this.serviceName = serviceName;
        this.ipv4 = ipv4;
        this.ipv6 = ipv6;
    }

    @JsonProperty(value="serviceName")
    @Safe
    public String getServiceName() {
        return this.serviceName;
    }

    @JsonProperty(value="ipv4")
    public Optional<String> getIpv4() {
        return this.ipv4;
    }

    @JsonProperty(value="ipv6")
    public Optional<String> getIpv6() {
        return this.ipv6;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof Endpoint && this.equalTo((Endpoint)other);
    }

    private boolean equalTo(Endpoint other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.serviceName.equals(other.serviceName) && this.ipv4.equals(other.ipv4) && this.ipv6.equals(other.ipv6);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.serviceName.hashCode();
            hash = 31 * hash + this.ipv4.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.ipv6.hashCode());
        }
        return result;
    }

    public String toString() {
        return "Endpoint{serviceName: " + this.serviceName + ", ipv4: " + this.ipv4 + ", ipv6: " + this.ipv6 + "}";
    }

    public static Endpoint of(@Safe String serviceName, String ipv4, String ipv6) {
        return Endpoint.builder().serviceName(serviceName).ipv4(Optional.of(ipv4)).ipv6(Optional.of(ipv6)).build();
    }

    private static void validateFields(String serviceName, Optional<String> ipv4, Optional<String> ipv6) {
        List<String> missingFields = null;
        missingFields = Endpoint.addFieldIfMissing(missingFields, serviceName, "serviceName");
        missingFields = Endpoint.addFieldIfMissing(missingFields, ipv4, "ipv4");
        if ((missingFields = Endpoint.addFieldIfMissing(missingFields, ipv6, "ipv6")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(3);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        @Safe
        private String serviceName;
        private Optional<String> ipv4 = Optional.empty();
        private Optional<String> ipv6 = Optional.empty();

        private Builder() {
        }

        public Builder from(Endpoint other) {
            this.checkNotBuilt();
            this.serviceName(other.getServiceName());
            this.ipv4(other.getIpv4());
            this.ipv6(other.getIpv6());
            return this;
        }

        @JsonSetter(value="serviceName")
        public Builder serviceName(@Nonnull @Safe String serviceName) {
            this.checkNotBuilt();
            this.serviceName = Preconditions.checkNotNull(serviceName, "serviceName cannot be null");
            return this;
        }

        @JsonSetter(value="ipv4", nulls=Nulls.SKIP)
        public Builder ipv4(@Nonnull Optional<String> ipv4) {
            this.checkNotBuilt();
            this.ipv4 = Preconditions.checkNotNull(ipv4, "ipv4 cannot be null");
            return this;
        }

        public Builder ipv4(@Nonnull String ipv4) {
            this.checkNotBuilt();
            this.ipv4 = Optional.of(Preconditions.checkNotNull(ipv4, "ipv4 cannot be null"));
            return this;
        }

        @JsonSetter(value="ipv6", nulls=Nulls.SKIP)
        public Builder ipv6(@Nonnull Optional<String> ipv6) {
            this.checkNotBuilt();
            this.ipv6 = Preconditions.checkNotNull(ipv6, "ipv6 cannot be null");
            return this;
        }

        public Builder ipv6(@Nonnull String ipv6) {
            this.checkNotBuilt();
            this.ipv6 = Optional.of(Preconditions.checkNotNull(ipv6, "ipv6 cannot be null"));
            return this;
        }

        public Endpoint build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new Endpoint(this.serviceName, this.ipv4, this.ipv6);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

