/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.logreceiver.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.palantir.logreceiver.api.SessionId;
import shadow.palantir.driver.com.palantir.logreceiver.api.TokenId;
import shadow.palantir.driver.com.palantir.logreceiver.api.TraceId;
import shadow.palantir.driver.com.palantir.logreceiver.api.UserId;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public final class EventLogV2 {
    private final String type;
    private final OffsetDateTime time;
    private final String eventName;
    private final Map<String, Object> values;
    private final Optional<UserId> uid;
    private final Optional<SessionId> sid;
    private final Optional<TokenId> tokenId;
    private final Optional<TraceId> traceId;
    private final Map<String, Object> unsafeParams;
    private int memoizedHashCode;

    private EventLogV2(String type, OffsetDateTime time, String eventName, Map<String, Object> values, Optional<UserId> uid, Optional<SessionId> sid, Optional<TokenId> tokenId, Optional<TraceId> traceId, Map<String, Object> unsafeParams) {
        EventLogV2.validateFields(type, time, eventName, values, uid, sid, tokenId, traceId, unsafeParams);
        this.type = type;
        this.time = time;
        this.eventName = eventName;
        this.values = Collections.unmodifiableMap(values);
        this.uid = uid;
        this.sid = sid;
        this.tokenId = tokenId;
        this.traceId = traceId;
        this.unsafeParams = Collections.unmodifiableMap(unsafeParams);
    }

    @JsonProperty(value="type")
    @Safe
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="time")
    @Safe
    public OffsetDateTime getTime() {
        return this.time;
    }

    @JsonProperty(value="eventName")
    @Safe
    public String getEventName() {
        return this.eventName;
    }

    @JsonProperty(value="values")
    public Map<String, Object> getValues() {
        return this.values;
    }

    @JsonProperty(value="uid")
    public Optional<UserId> getUid() {
        return this.uid;
    }

    @JsonProperty(value="sid")
    public Optional<SessionId> getSid() {
        return this.sid;
    }

    @JsonProperty(value="tokenId")
    public Optional<TokenId> getTokenId() {
        return this.tokenId;
    }

    @JsonProperty(value="traceId")
    public Optional<TraceId> getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="unsafeParams")
    public Map<String, Object> getUnsafeParams() {
        return this.unsafeParams;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof EventLogV2 && this.equalTo((EventLogV2)other);
    }

    private boolean equalTo(EventLogV2 other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.type.equals(other.type) && this.time.isEqual(other.time) && this.eventName.equals(other.eventName) && this.values.equals(other.values) && this.uid.equals(other.uid) && this.sid.equals(other.sid) && this.tokenId.equals(other.tokenId) && this.traceId.equals(other.traceId) && this.unsafeParams.equals(other.unsafeParams);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.type.hashCode();
            hash = 31 * hash + this.time.toInstant().hashCode();
            hash = 31 * hash + this.eventName.hashCode();
            hash = 31 * hash + this.values.hashCode();
            hash = 31 * hash + this.uid.hashCode();
            hash = 31 * hash + this.sid.hashCode();
            hash = 31 * hash + this.tokenId.hashCode();
            hash = 31 * hash + this.traceId.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.unsafeParams.hashCode());
        }
        return result;
    }

    public String toString() {
        return "EventLogV2{type: " + this.type + ", time: " + this.time + ", eventName: " + this.eventName + ", values: " + this.values + ", uid: " + this.uid + ", sid: " + this.sid + ", tokenId: " + this.tokenId + ", traceId: " + this.traceId + ", unsafeParams: " + this.unsafeParams + "}";
    }

    private static void validateFields(String type, OffsetDateTime time, String eventName, Map<String, Object> values, Optional<UserId> uid, Optional<SessionId> sid, Optional<TokenId> tokenId, Optional<TraceId> traceId, Map<String, Object> unsafeParams) {
        List<String> missingFields = null;
        missingFields = EventLogV2.addFieldIfMissing(missingFields, type, "type");
        missingFields = EventLogV2.addFieldIfMissing(missingFields, time, "time");
        missingFields = EventLogV2.addFieldIfMissing(missingFields, eventName, "eventName");
        missingFields = EventLogV2.addFieldIfMissing(missingFields, values, "values");
        missingFields = EventLogV2.addFieldIfMissing(missingFields, uid, "uid");
        missingFields = EventLogV2.addFieldIfMissing(missingFields, sid, "sid");
        missingFields = EventLogV2.addFieldIfMissing(missingFields, tokenId, "tokenId");
        missingFields = EventLogV2.addFieldIfMissing(missingFields, traceId, "traceId");
        if ((missingFields = EventLogV2.addFieldIfMissing(missingFields, unsafeParams, "unsafeParams")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(9);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        @Safe
        private String type;
        @Safe
        private OffsetDateTime time;
        @Safe
        private String eventName;
        private Map<String, Object> values = new LinkedHashMap<String, Object>();
        private Optional<UserId> uid = Optional.empty();
        private Optional<SessionId> sid = Optional.empty();
        private Optional<TokenId> tokenId = Optional.empty();
        private Optional<TraceId> traceId = Optional.empty();
        private Map<String, Object> unsafeParams = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        public Builder from(EventLogV2 other) {
            this.checkNotBuilt();
            this.type(other.getType());
            this.time(other.getTime());
            this.eventName(other.getEventName());
            this.values(other.getValues());
            this.uid(other.getUid());
            this.sid(other.getSid());
            this.tokenId(other.getTokenId());
            this.traceId(other.getTraceId());
            this.unsafeParams(other.getUnsafeParams());
            return this;
        }

        @JsonSetter(value="type")
        public Builder type(@Nonnull @Safe String type) {
            this.checkNotBuilt();
            this.type = Preconditions.checkNotNull(type, "type cannot be null");
            return this;
        }

        @JsonSetter(value="time")
        public Builder time(@Nonnull @Safe OffsetDateTime time) {
            this.checkNotBuilt();
            this.time = Preconditions.checkNotNull(time, "time cannot be null");
            return this;
        }

        @JsonSetter(value="eventName")
        public Builder eventName(@Nonnull @Safe String eventName) {
            this.checkNotBuilt();
            this.eventName = Preconditions.checkNotNull(eventName, "eventName cannot be null");
            return this;
        }

        @JsonSetter(value="values", nulls=Nulls.SKIP)
        public Builder values(@Nonnull Map<String, Object> values) {
            this.checkNotBuilt();
            this.values = new LinkedHashMap<String, Object>(Preconditions.checkNotNull(values, "values cannot be null"));
            return this;
        }

        public Builder putAllValues(@Nonnull Map<String, Object> values) {
            this.checkNotBuilt();
            this.values.putAll(Preconditions.checkNotNull(values, "values cannot be null"));
            return this;
        }

        public Builder values(String key, Object value) {
            this.checkNotBuilt();
            this.values.put(key, value);
            return this;
        }

        @JsonSetter(value="uid", nulls=Nulls.SKIP)
        public Builder uid(@Nonnull Optional<UserId> uid) {
            this.checkNotBuilt();
            this.uid = Preconditions.checkNotNull(uid, "uid cannot be null");
            return this;
        }

        public Builder uid(@Nonnull UserId uid) {
            this.checkNotBuilt();
            this.uid = Optional.of(Preconditions.checkNotNull(uid, "uid cannot be null"));
            return this;
        }

        @JsonSetter(value="sid", nulls=Nulls.SKIP)
        public Builder sid(@Nonnull Optional<SessionId> sid) {
            this.checkNotBuilt();
            this.sid = Preconditions.checkNotNull(sid, "sid cannot be null");
            return this;
        }

        public Builder sid(@Nonnull SessionId sid) {
            this.checkNotBuilt();
            this.sid = Optional.of(Preconditions.checkNotNull(sid, "sid cannot be null"));
            return this;
        }

        @JsonSetter(value="tokenId", nulls=Nulls.SKIP)
        public Builder tokenId(@Nonnull Optional<TokenId> tokenId) {
            this.checkNotBuilt();
            this.tokenId = Preconditions.checkNotNull(tokenId, "tokenId cannot be null");
            return this;
        }

        public Builder tokenId(@Nonnull TokenId tokenId) {
            this.checkNotBuilt();
            this.tokenId = Optional.of(Preconditions.checkNotNull(tokenId, "tokenId cannot be null"));
            return this;
        }

        @JsonSetter(value="traceId", nulls=Nulls.SKIP)
        public Builder traceId(@Nonnull Optional<TraceId> traceId) {
            this.checkNotBuilt();
            this.traceId = Preconditions.checkNotNull(traceId, "traceId cannot be null");
            return this;
        }

        public Builder traceId(@Nonnull TraceId traceId) {
            this.checkNotBuilt();
            this.traceId = Optional.of(Preconditions.checkNotNull(traceId, "traceId cannot be null"));
            return this;
        }

        @JsonSetter(value="unsafeParams", nulls=Nulls.SKIP)
        public Builder unsafeParams(@Nonnull Map<String, Object> unsafeParams) {
            this.checkNotBuilt();
            this.unsafeParams = new LinkedHashMap<String, Object>(Preconditions.checkNotNull(unsafeParams, "unsafeParams cannot be null"));
            return this;
        }

        public Builder putAllUnsafeParams(@Nonnull Map<String, Object> unsafeParams) {
            this.checkNotBuilt();
            this.unsafeParams.putAll(Preconditions.checkNotNull(unsafeParams, "unsafeParams cannot be null"));
            return this;
        }

        public Builder unsafeParams(String key, Object value) {
            this.checkNotBuilt();
            this.unsafeParams.put(key, value);
            return this;
        }

        public EventLogV2 build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new EventLogV2(this.type, this.time, this.eventName, this.values, this.uid, this.sid, this.tokenId, this.traceId, this.unsafeParams);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

