/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.logreceiver.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.google.errorprone.annotations.Immutable;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Safe
@Immutable
public final class LogLevel {
    public static final LogLevel FATAL = new LogLevel(Value.FATAL, "FATAL");
    public static final LogLevel ERROR = new LogLevel(Value.ERROR, "ERROR");
    public static final LogLevel WARN = new LogLevel(Value.WARN, "WARN");
    public static final LogLevel INFO = new LogLevel(Value.INFO, "INFO");
    public static final LogLevel DEBUG = new LogLevel(Value.DEBUG, "DEBUG");
    public static final LogLevel TRACE = new LogLevel(Value.TRACE, "TRACE");
    private static final List<LogLevel> values = Collections.unmodifiableList(Arrays.asList(FATAL, ERROR, WARN, INFO, DEBUG, TRACE));
    private final Value value;
    private final String string;

    private LogLevel(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value get() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || this.value == Value.UNKNOWN && other instanceof LogLevel && this.string.equals(((LogLevel)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static LogLevel valueOf(@Nonnull @Safe String value) {
        String upperCasedValue;
        Preconditions.checkNotNull(value, "value cannot be null");
        switch (upperCasedValue = value.toUpperCase(Locale.ROOT)) {
            case "FATAL": {
                return FATAL;
            }
            case "ERROR": {
                return ERROR;
            }
            case "WARN": {
                return WARN;
            }
            case "INFO": {
                return INFO;
            }
            case "DEBUG": {
                return DEBUG;
            }
            case "TRACE": {
                return TRACE;
            }
        }
        return new LogLevel(Value.UNKNOWN, upperCasedValue);
    }

    public <T> T accept(Visitor<T> visitor) {
        switch (this.value) {
            case FATAL: {
                return visitor.visitFatal();
            }
            case ERROR: {
                return visitor.visitError();
            }
            case WARN: {
                return visitor.visitWarn();
            }
            case INFO: {
                return visitor.visitInfo();
            }
            case DEBUG: {
                return visitor.visitDebug();
            }
            case TRACE: {
                return visitor.visitTrace();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    public static List<LogLevel> values() {
        return values;
    }

    public static interface Visitor<T> {
        public T visitFatal();

        public T visitError();

        public T visitWarn();

        public T visitInfo();

        public T visitDebug();

        public T visitTrace();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE,
        UNKNOWN;

    }
}

