/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.logreceiver.api;

import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ClientEndpoint;
import shadow.palantir.driver.com.palantir.dialogue.Channel;
import shadow.palantir.driver.com.palantir.dialogue.ConjureRuntime;
import shadow.palantir.driver.com.palantir.dialogue.Deserializer;
import shadow.palantir.driver.com.palantir.dialogue.DialogueService;
import shadow.palantir.driver.com.palantir.dialogue.DialogueServiceFactory;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannel;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannelFactory;
import shadow.palantir.driver.com.palantir.dialogue.PlainSerDe;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Serializer;
import shadow.palantir.driver.com.palantir.dialogue.TypeMarker;
import shadow.palantir.driver.com.palantir.logreceiver.api.DialogueLogReceiverEndpoints;
import shadow.palantir.driver.com.palantir.logreceiver.api.WrappedTelemetryBatch;
import shadow.palantir.driver.com.palantir.tokens.auth.AuthHeader;

@DialogueService(value=Factory.class)
public interface LogReceiverServiceAsync {
    @ClientEndpoint(method="POST", path="/logs")
    public ListenableFuture<Void> logs(AuthHeader var1, WrappedTelemetryBatch var2);

    public static LogReceiverServiceAsync of(final EndpointChannelFactory _endpointChannelFactory, final ConjureRuntime _runtime) {
        return new LogReceiverServiceAsync(){
            private final PlainSerDe _plainSerDe;
            private final Serializer<WrappedTelemetryBatch> logsSerializer;
            private final EndpointChannel logsChannel;
            private final Deserializer<Void> logsDeserializer;
            {
                this._plainSerDe = _runtime.plainSerDe();
                this.logsSerializer = _runtime.bodySerDe().serializer(new TypeMarker<WrappedTelemetryBatch>(){});
                this.logsChannel = _endpointChannelFactory.endpoint(DialogueLogReceiverEndpoints.logs);
                this.logsDeserializer = _runtime.bodySerDe().emptyBodyDeserializer();
            }

            @Override
            public ListenableFuture<Void> logs(AuthHeader authHeader, WrappedTelemetryBatch batch) {
                Request.Builder _request = Request.builder();
                _request.putHeaderParams("Authorization", authHeader.toString());
                _request.body(this.logsSerializer.serialize(batch));
                return _runtime.clients().call(this.logsChannel, _request.build(), this.logsDeserializer);
            }

            public String toString() {
                return "LogReceiverServiceAsync{_endpointChannelFactory=" + _endpointChannelFactory + ", runtime=" + _runtime + "}";
            }
        };
    }

    public static LogReceiverServiceAsync of(final Channel _channel, final ConjureRuntime _runtime) {
        if (_channel instanceof EndpointChannelFactory) {
            return LogReceiverServiceAsync.of((EndpointChannelFactory)((Object)_channel), _runtime);
        }
        return LogReceiverServiceAsync.of(new EndpointChannelFactory(){

            @Override
            public EndpointChannel endpoint(Endpoint endpoint) {
                return _runtime.clients().bind(_channel, endpoint);
            }
        }, _runtime);
    }

    public static final class Factory
    implements DialogueServiceFactory<LogReceiverServiceAsync> {
        @Override
        public LogReceiverServiceAsync create(EndpointChannelFactory endpointChannelFactory, ConjureRuntime runtime) {
            return LogReceiverServiceAsync.of(endpointChannelFactory, runtime);
        }
    }
}

