/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.logreceiver.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.palantir.logreceiver.api.MetricUpdateOperation;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public final class MetricUpdate {
    private final String metricName;
    private final Map<String, String> safeTags;
    private final MetricUpdateOperation operation;
    private int memoizedHashCode;

    private MetricUpdate(String metricName, Map<String, String> safeTags, MetricUpdateOperation operation) {
        MetricUpdate.validateFields(metricName, safeTags, operation);
        this.metricName = metricName;
        this.safeTags = Collections.unmodifiableMap(safeTags);
        this.operation = operation;
    }

    @JsonProperty(value="metricName")
    @Safe
    public String getMetricName() {
        return this.metricName;
    }

    @JsonProperty(value="safeTags")
    public Map<String, String> getSafeTags() {
        return this.safeTags;
    }

    @JsonProperty(value="operation")
    public MetricUpdateOperation getOperation() {
        return this.operation;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof MetricUpdate && this.equalTo((MetricUpdate)other);
    }

    private boolean equalTo(MetricUpdate other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.metricName.equals(other.metricName) && this.safeTags.equals(other.safeTags) && this.operation.equals(other.operation);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.metricName.hashCode();
            hash = 31 * hash + this.safeTags.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.operation.hashCode());
        }
        return result;
    }

    public String toString() {
        return "MetricUpdate{metricName: " + this.metricName + ", safeTags: " + this.safeTags + ", operation: " + this.operation + "}";
    }

    public static MetricUpdate of(@Safe String metricName, Map<String, String> safeTags, MetricUpdateOperation operation) {
        return MetricUpdate.builder().metricName(metricName).safeTags(safeTags).operation(operation).build();
    }

    private static void validateFields(String metricName, Map<String, String> safeTags, MetricUpdateOperation operation) {
        List<String> missingFields = null;
        missingFields = MetricUpdate.addFieldIfMissing(missingFields, metricName, "metricName");
        missingFields = MetricUpdate.addFieldIfMissing(missingFields, safeTags, "safeTags");
        if ((missingFields = MetricUpdate.addFieldIfMissing(missingFields, operation, "operation")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(3);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        @Safe
        private String metricName;
        private Map<String, String> safeTags = new LinkedHashMap<String, String>();
        private MetricUpdateOperation operation;

        private Builder() {
        }

        public Builder from(MetricUpdate other) {
            this.checkNotBuilt();
            this.metricName(other.getMetricName());
            this.safeTags(other.getSafeTags());
            this.operation(other.getOperation());
            return this;
        }

        @JsonSetter(value="metricName")
        public Builder metricName(@Nonnull @Safe String metricName) {
            this.checkNotBuilt();
            this.metricName = Preconditions.checkNotNull(metricName, "metricName cannot be null");
            return this;
        }

        @JsonSetter(value="safeTags", nulls=Nulls.SKIP)
        public Builder safeTags(@Nonnull Map<String, String> safeTags) {
            this.checkNotBuilt();
            this.safeTags = new LinkedHashMap<String, String>(Preconditions.checkNotNull(safeTags, "safeTags cannot be null"));
            return this;
        }

        public Builder putAllSafeTags(@Nonnull Map<String, String> safeTags) {
            this.checkNotBuilt();
            this.safeTags.putAll(Preconditions.checkNotNull(safeTags, "safeTags cannot be null"));
            return this;
        }

        public Builder safeTags(String key, String value) {
            this.checkNotBuilt();
            this.safeTags.put(key, value);
            return this;
        }

        @JsonSetter(value="operation")
        public Builder operation(@Nonnull MetricUpdateOperation operation) {
            this.checkNotBuilt();
            this.operation = Preconditions.checkNotNull(operation, "operation cannot be null");
            return this;
        }

        public MetricUpdate build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new MetricUpdate(this.metricName, this.safeTags, this.operation);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

