/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.logreceiver.api;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAnyGetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAnySetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSubTypes;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.palantir.conjure.java.lib.SafeLong;
import shadow.palantir.driver.com.palantir.logreceiver.api.DurationMicroseconds;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

public final class MetricUpdateOperation {
    private final Base value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private MetricUpdateOperation(Base value) {
        this.value = value;
    }

    @JsonValue
    private Base getValue() {
        return this.value;
    }

    public static MetricUpdateOperation counter(@Safe SafeLong value) {
        return new MetricUpdateOperation(new CounterWrapper(value));
    }

    public static MetricUpdateOperation histogram(@Safe SafeLong value) {
        return new MetricUpdateOperation(new HistogramWrapper(value));
    }

    public static MetricUpdateOperation meter(@Safe int value) {
        return new MetricUpdateOperation(new MeterWrapper(value));
    }

    public static MetricUpdateOperation timer(DurationMicroseconds value) {
        return new MetricUpdateOperation(new TimerWrapper(value));
    }

    public static MetricUpdateOperation unknown(@Safe String type, Object value) {
        switch (Preconditions.checkNotNull(type, "Type is required")) {
            case "counter": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: counter", new Arg[0]);
            }
            case "histogram": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: histogram", new Arg[0]);
            }
            case "meter": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: meter", new Arg[0]);
            }
            case "timer": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: timer", new Arg[0]);
            }
        }
        return new MetricUpdateOperation(new UnknownWrapper(type, Collections.singletonMap(type, value)));
    }

    public <T> T accept(Visitor<T> visitor) {
        return this.value.accept(visitor);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof MetricUpdateOperation && this.equalTo((MetricUpdateOperation)other);
    }

    private boolean equalTo(MetricUpdateOperation other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "MetricUpdateOperation{value: " + this.value + "}";
    }

    private static final class UnknownWrapper
    implements Base {
        private final String type;
        private final Map<String, Object> value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private UnknownWrapper(@JsonProperty(value="type") String type) {
            this(type, new HashMap<String, Object>());
        }

        private UnknownWrapper(@Nonnull String type, @Nonnull Map<String, Object> value) {
            Preconditions.checkNotNull(type, "type cannot be null");
            Preconditions.checkNotNull(value, "value cannot be null");
            this.type = type;
            this.value = value;
        }

        @JsonProperty
        private String getType() {
            return this.type;
        }

        @JsonAnyGetter
        private Map<String, Object> getValue() {
            return this.value;
        }

        @JsonAnySetter
        private void put(String key, Object val) {
            this.value.put(key, val);
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitUnknown(this.type);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof UnknownWrapper && this.equalTo((UnknownWrapper)other);
        }

        private boolean equalTo(UnknownWrapper other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            int hash = 1;
            hash = 31 * hash + this.type.hashCode();
            hash = 31 * hash + this.value.hashCode();
            return hash;
        }

        public String toString() {
            return "UnknownWrapper{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="timer")
    private static final class TimerWrapper
    implements Base {
        private final DurationMicroseconds value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private TimerWrapper(@JsonSetter(value="timer") @Nonnull DurationMicroseconds value) {
            Preconditions.checkNotNull(value, "timer cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "timer";
        }

        @JsonProperty(value="timer")
        private DurationMicroseconds getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitTimer(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof TimerWrapper && this.equalTo((TimerWrapper)other);
        }

        private boolean equalTo(TimerWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "TimerWrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="meter")
    private static final class MeterWrapper
    implements Base {
        private final int value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private MeterWrapper(@JsonSetter(value="meter") @Nonnull int value) {
            Preconditions.checkNotNull(value, "meter cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "meter";
        }

        @JsonProperty(value="meter")
        private int getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitMeter(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof MeterWrapper && this.equalTo((MeterWrapper)other);
        }

        private boolean equalTo(MeterWrapper other) {
            return this.value == other.value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            return "MeterWrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="histogram")
    private static final class HistogramWrapper
    implements Base {
        private final SafeLong value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private HistogramWrapper(@JsonSetter(value="histogram") @Nonnull SafeLong value) {
            Preconditions.checkNotNull(value, "histogram cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "histogram";
        }

        @JsonProperty(value="histogram")
        private SafeLong getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitHistogram(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof HistogramWrapper && this.equalTo((HistogramWrapper)other);
        }

        private boolean equalTo(HistogramWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "HistogramWrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="counter")
    private static final class CounterWrapper
    implements Base {
        private final SafeLong value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private CounterWrapper(@JsonSetter(value="counter") @Nonnull SafeLong value) {
            Preconditions.checkNotNull(value, "counter cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "counter";
        }

        @JsonProperty(value="counter")
        private SafeLong getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitCounter(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof CounterWrapper && this.equalTo((CounterWrapper)other);
        }

        private boolean equalTo(CounterWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "CounterWrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=UnknownWrapper.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=CounterWrapper.class), @JsonSubTypes.Type(value=HistogramWrapper.class), @JsonSubTypes.Type(value=MeterWrapper.class), @JsonSubTypes.Type(value=TimerWrapper.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Base {
        public <T> T accept(Visitor<T> var1);
    }

    public static interface Completed_StageVisitorBuilder<T> {
        public Visitor<T> build();
    }

    public static interface UnknownStageVisitorBuilder<T> {
        public Completed_StageVisitorBuilder<T> unknown(@Nonnull Function<String, T> var1);

        public Completed_StageVisitorBuilder<T> throwOnUnknown();
    }

    public static interface TimerStageVisitorBuilder<T> {
        public UnknownStageVisitorBuilder<T> timer(@Nonnull Function<DurationMicroseconds, T> var1);
    }

    public static interface MeterStageVisitorBuilder<T> {
        public TimerStageVisitorBuilder<T> meter(@Nonnull IntFunction<T> var1);
    }

    public static interface HistogramStageVisitorBuilder<T> {
        public MeterStageVisitorBuilder<T> histogram(@Nonnull Function<@Safe SafeLong, T> var1);
    }

    public static interface CounterStageVisitorBuilder<T> {
        public HistogramStageVisitorBuilder<T> counter(@Nonnull Function<@Safe SafeLong, T> var1);
    }

    private static final class VisitorBuilder<T>
    implements CounterStageVisitorBuilder<T>,
    HistogramStageVisitorBuilder<T>,
    MeterStageVisitorBuilder<T>,
    TimerStageVisitorBuilder<T>,
    UnknownStageVisitorBuilder<T>,
    Completed_StageVisitorBuilder<T> {
        private Function<@Safe SafeLong, T> counterVisitor;
        private Function<@Safe SafeLong, T> histogramVisitor;
        private IntFunction<T> meterVisitor;
        private Function<DurationMicroseconds, T> timerVisitor;
        private Function<String, T> unknownVisitor;

        private VisitorBuilder() {
        }

        @Override
        public HistogramStageVisitorBuilder<T> counter(@Nonnull Function<@Safe SafeLong, T> counterVisitor) {
            Preconditions.checkNotNull(counterVisitor, "counterVisitor cannot be null");
            this.counterVisitor = counterVisitor;
            return this;
        }

        @Override
        public MeterStageVisitorBuilder<T> histogram(@Nonnull Function<@Safe SafeLong, T> histogramVisitor) {
            Preconditions.checkNotNull(histogramVisitor, "histogramVisitor cannot be null");
            this.histogramVisitor = histogramVisitor;
            return this;
        }

        @Override
        public TimerStageVisitorBuilder<T> meter(@Nonnull IntFunction<T> meterVisitor) {
            Preconditions.checkNotNull(meterVisitor, "meterVisitor cannot be null");
            this.meterVisitor = meterVisitor;
            return this;
        }

        @Override
        public UnknownStageVisitorBuilder<T> timer(@Nonnull Function<DurationMicroseconds, T> timerVisitor) {
            Preconditions.checkNotNull(timerVisitor, "timerVisitor cannot be null");
            this.timerVisitor = timerVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> unknown(@Nonnull Function<String, T> unknownVisitor) {
            Preconditions.checkNotNull(unknownVisitor, "unknownVisitor cannot be null");
            this.unknownVisitor = unknownVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> throwOnUnknown() {
            this.unknownVisitor = unknownType -> {
                throw new SafeIllegalArgumentException("Unknown variant of the 'MetricUpdateOperation' union", SafeArg.of("unknownType", unknownType));
            };
            return this;
        }

        @Override
        public Visitor<T> build() {
            final Function<@Safe SafeLong, T> counterVisitor = this.counterVisitor;
            final Function<@Safe SafeLong, T> histogramVisitor = this.histogramVisitor;
            final IntFunction<T> meterVisitor = this.meterVisitor;
            final Function<DurationMicroseconds, T> timerVisitor = this.timerVisitor;
            final Function<String, T> unknownVisitor = this.unknownVisitor;
            return new Visitor<T>(){

                @Override
                public T visitCounter(@Safe SafeLong value) {
                    return counterVisitor.apply(value);
                }

                @Override
                public T visitHistogram(@Safe SafeLong value) {
                    return histogramVisitor.apply(value);
                }

                @Override
                public T visitMeter(@Safe int value) {
                    return meterVisitor.apply(value);
                }

                @Override
                public T visitTimer(DurationMicroseconds value) {
                    return timerVisitor.apply(value);
                }

                @Override
                public T visitUnknown(String value) {
                    return unknownVisitor.apply(value);
                }
            };
        }
    }

    public static interface Visitor<T> {
        public T visitCounter(@Safe SafeLong var1);

        public T visitHistogram(@Safe SafeLong var1);

        public T visitMeter(@Safe int var1);

        public T visitTimer(DurationMicroseconds var1);

        public T visitUnknown(@Safe String var1);

        public static <T> CounterStageVisitorBuilder<T> builder() {
            return new VisitorBuilder();
        }
    }
}

