/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.logreceiver.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.palantir.logreceiver.api.LogLevel;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public final class ServiceLogV1 {
    private final LogLevel level;
    private final OffsetDateTime time;
    private final Optional<String> origin;
    private final Optional<String> thread;
    private final String message;
    private final Optional<Boolean> safe;
    private final Map<String, Object> params;
    private final Optional<String> uid;
    private final Optional<String> sid;
    private final Optional<String> tokenId;
    private final Optional<String> traceId;
    private final Optional<String> stacktrace;
    private final Map<String, Object> unsafeParams;
    private final Map<String, String> tags;
    private int memoizedHashCode;

    private ServiceLogV1(LogLevel level, OffsetDateTime time, Optional<String> origin, Optional<String> thread, String message, Optional<Boolean> safe, Map<String, Object> params, Optional<String> uid, Optional<String> sid, Optional<String> tokenId, Optional<String> traceId, Optional<String> stacktrace, Map<String, Object> unsafeParams, Map<String, String> tags) {
        ServiceLogV1.validateFields(level, time, origin, thread, message, safe, params, uid, sid, tokenId, traceId, stacktrace, unsafeParams, tags);
        this.level = level;
        this.time = time;
        this.origin = origin;
        this.thread = thread;
        this.message = message;
        this.safe = safe;
        this.params = Collections.unmodifiableMap(params);
        this.uid = uid;
        this.sid = sid;
        this.tokenId = tokenId;
        this.traceId = traceId;
        this.stacktrace = stacktrace;
        this.unsafeParams = Collections.unmodifiableMap(unsafeParams);
        this.tags = Collections.unmodifiableMap(tags);
    }

    @JsonProperty(value="level")
    public LogLevel getLevel() {
        return this.level;
    }

    @JsonProperty(value="time")
    @Safe
    public OffsetDateTime getTime() {
        return this.time;
    }

    @JsonProperty(value="origin")
    @Safe
    public Optional<String> getOrigin() {
        return this.origin;
    }

    @JsonProperty(value="thread")
    @Safe
    public Optional<String> getThread() {
        return this.thread;
    }

    @JsonProperty(value="message")
    @Safe
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="safe")
    @Safe
    public Optional<Boolean> getSafe() {
        return this.safe;
    }

    @JsonProperty(value="params")
    public Map<String, Object> getParams() {
        return this.params;
    }

    @JsonProperty(value="uid")
    @Safe
    public Optional<String> getUid() {
        return this.uid;
    }

    @JsonProperty(value="sid")
    @Safe
    public Optional<String> getSid() {
        return this.sid;
    }

    @JsonProperty(value="tokenId")
    @Safe
    public Optional<String> getTokenId() {
        return this.tokenId;
    }

    @JsonProperty(value="traceId")
    @Safe
    public Optional<String> getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="stacktrace")
    @Safe
    public Optional<String> getStacktrace() {
        return this.stacktrace;
    }

    @JsonProperty(value="unsafeParams")
    public Map<String, Object> getUnsafeParams() {
        return this.unsafeParams;
    }

    @JsonProperty(value="tags")
    public Map<String, String> getTags() {
        return this.tags;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ServiceLogV1 && this.equalTo((ServiceLogV1)other);
    }

    private boolean equalTo(ServiceLogV1 other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.level.equals(other.level) && this.time.isEqual(other.time) && this.origin.equals(other.origin) && this.thread.equals(other.thread) && this.message.equals(other.message) && this.safe.equals(other.safe) && this.params.equals(other.params) && this.uid.equals(other.uid) && this.sid.equals(other.sid) && this.tokenId.equals(other.tokenId) && this.traceId.equals(other.traceId) && this.stacktrace.equals(other.stacktrace) && this.unsafeParams.equals(other.unsafeParams) && this.tags.equals(other.tags);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.level.hashCode();
            hash = 31 * hash + this.time.toInstant().hashCode();
            hash = 31 * hash + this.origin.hashCode();
            hash = 31 * hash + this.thread.hashCode();
            hash = 31 * hash + this.message.hashCode();
            hash = 31 * hash + this.safe.hashCode();
            hash = 31 * hash + this.params.hashCode();
            hash = 31 * hash + this.uid.hashCode();
            hash = 31 * hash + this.sid.hashCode();
            hash = 31 * hash + this.tokenId.hashCode();
            hash = 31 * hash + this.traceId.hashCode();
            hash = 31 * hash + this.stacktrace.hashCode();
            hash = 31 * hash + this.unsafeParams.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.tags.hashCode());
        }
        return result;
    }

    public String toString() {
        return "ServiceLogV1{level: " + this.level + ", time: " + this.time + ", origin: " + this.origin + ", thread: " + this.thread + ", message: " + this.message + ", safe: " + this.safe + ", params: " + this.params + ", uid: " + this.uid + ", sid: " + this.sid + ", tokenId: " + this.tokenId + ", traceId: " + this.traceId + ", stacktrace: " + this.stacktrace + ", unsafeParams: " + this.unsafeParams + ", tags: " + this.tags + "}";
    }

    private static void validateFields(LogLevel level, OffsetDateTime time, Optional<String> origin, Optional<String> thread, String message, Optional<Boolean> safe, Map<String, Object> params, Optional<String> uid, Optional<String> sid, Optional<String> tokenId, Optional<String> traceId, Optional<String> stacktrace, Map<String, Object> unsafeParams, Map<String, String> tags) {
        List<String> missingFields = null;
        missingFields = ServiceLogV1.addFieldIfMissing(missingFields, level, "level");
        missingFields = ServiceLogV1.addFieldIfMissing(missingFields, time, "time");
        missingFields = ServiceLogV1.addFieldIfMissing(missingFields, origin, "origin");
        missingFields = ServiceLogV1.addFieldIfMissing(missingFields, thread, "thread");
        missingFields = ServiceLogV1.addFieldIfMissing(missingFields, message, "message");
        missingFields = ServiceLogV1.addFieldIfMissing(missingFields, safe, "safe");
        missingFields = ServiceLogV1.addFieldIfMissing(missingFields, params, "params");
        missingFields = ServiceLogV1.addFieldIfMissing(missingFields, uid, "uid");
        missingFields = ServiceLogV1.addFieldIfMissing(missingFields, sid, "sid");
        missingFields = ServiceLogV1.addFieldIfMissing(missingFields, tokenId, "tokenId");
        missingFields = ServiceLogV1.addFieldIfMissing(missingFields, traceId, "traceId");
        missingFields = ServiceLogV1.addFieldIfMissing(missingFields, stacktrace, "stacktrace");
        missingFields = ServiceLogV1.addFieldIfMissing(missingFields, unsafeParams, "unsafeParams");
        if ((missingFields = ServiceLogV1.addFieldIfMissing(missingFields, tags, "tags")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(14);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        private LogLevel level;
        @Safe
        private OffsetDateTime time;
        private Optional<@Safe String> origin = Optional.empty();
        private Optional<@Safe String> thread = Optional.empty();
        @Safe
        private String message;
        private Optional<@Safe Boolean> safe = Optional.empty();
        private Map<String, Object> params = new LinkedHashMap<String, Object>();
        private Optional<@Safe String> uid = Optional.empty();
        private Optional<@Safe String> sid = Optional.empty();
        private Optional<@Safe String> tokenId = Optional.empty();
        private Optional<@Safe String> traceId = Optional.empty();
        private Optional<@Safe String> stacktrace = Optional.empty();
        private Map<String, Object> unsafeParams = new LinkedHashMap<String, Object>();
        private Map<String, String> tags = new LinkedHashMap<String, String>();

        private Builder() {
        }

        public Builder from(ServiceLogV1 other) {
            this.checkNotBuilt();
            this.level(other.getLevel());
            this.time(other.getTime());
            this.origin(other.getOrigin());
            this.thread(other.getThread());
            this.message(other.getMessage());
            this.safe(other.getSafe());
            this.params(other.getParams());
            this.uid(other.getUid());
            this.sid(other.getSid());
            this.tokenId(other.getTokenId());
            this.traceId(other.getTraceId());
            this.stacktrace(other.getStacktrace());
            this.unsafeParams(other.getUnsafeParams());
            this.tags(other.getTags());
            return this;
        }

        @JsonSetter(value="level")
        public Builder level(@Nonnull LogLevel level) {
            this.checkNotBuilt();
            this.level = Preconditions.checkNotNull(level, "level cannot be null");
            return this;
        }

        @JsonSetter(value="time")
        public Builder time(@Nonnull @Safe OffsetDateTime time) {
            this.checkNotBuilt();
            this.time = Preconditions.checkNotNull(time, "time cannot be null");
            return this;
        }

        @JsonSetter(value="origin", nulls=Nulls.SKIP)
        public Builder origin(@Nonnull Optional<@Safe String> origin) {
            this.checkNotBuilt();
            this.origin = Preconditions.checkNotNull(origin, "origin cannot be null");
            return this;
        }

        public Builder origin(@Nonnull @Safe String origin) {
            this.checkNotBuilt();
            this.origin = Optional.of(Preconditions.checkNotNull(origin, "origin cannot be null"));
            return this;
        }

        @JsonSetter(value="thread", nulls=Nulls.SKIP)
        public Builder thread(@Nonnull Optional<@Safe String> thread) {
            this.checkNotBuilt();
            this.thread = Preconditions.checkNotNull(thread, "thread cannot be null");
            return this;
        }

        public Builder thread(@Nonnull @Safe String thread) {
            this.checkNotBuilt();
            this.thread = Optional.of(Preconditions.checkNotNull(thread, "thread cannot be null"));
            return this;
        }

        @JsonSetter(value="message")
        public Builder message(@Nonnull @Safe String message) {
            this.checkNotBuilt();
            this.message = Preconditions.checkNotNull(message, "message cannot be null");
            return this;
        }

        @JsonSetter(value="safe", nulls=Nulls.SKIP)
        public Builder safe(@Nonnull Optional<@Safe Boolean> safe) {
            this.checkNotBuilt();
            this.safe = Preconditions.checkNotNull(safe, "safe cannot be null");
            return this;
        }

        public Builder safe(@Safe boolean safe) {
            this.checkNotBuilt();
            this.safe = Optional.of(safe);
            return this;
        }

        @JsonSetter(value="params", nulls=Nulls.SKIP)
        public Builder params(@Nonnull Map<String, Object> params) {
            this.checkNotBuilt();
            this.params = new LinkedHashMap<String, Object>(Preconditions.checkNotNull(params, "params cannot be null"));
            return this;
        }

        public Builder putAllParams(@Nonnull Map<String, Object> params) {
            this.checkNotBuilt();
            this.params.putAll(Preconditions.checkNotNull(params, "params cannot be null"));
            return this;
        }

        public Builder params(String key, Object value) {
            this.checkNotBuilt();
            this.params.put(key, value);
            return this;
        }

        @JsonSetter(value="uid", nulls=Nulls.SKIP)
        public Builder uid(@Nonnull Optional<@Safe String> uid) {
            this.checkNotBuilt();
            this.uid = Preconditions.checkNotNull(uid, "uid cannot be null");
            return this;
        }

        public Builder uid(@Nonnull @Safe String uid) {
            this.checkNotBuilt();
            this.uid = Optional.of(Preconditions.checkNotNull(uid, "uid cannot be null"));
            return this;
        }

        @JsonSetter(value="sid", nulls=Nulls.SKIP)
        public Builder sid(@Nonnull Optional<@Safe String> sid) {
            this.checkNotBuilt();
            this.sid = Preconditions.checkNotNull(sid, "sid cannot be null");
            return this;
        }

        public Builder sid(@Nonnull @Safe String sid) {
            this.checkNotBuilt();
            this.sid = Optional.of(Preconditions.checkNotNull(sid, "sid cannot be null"));
            return this;
        }

        @JsonSetter(value="tokenId", nulls=Nulls.SKIP)
        public Builder tokenId(@Nonnull Optional<@Safe String> tokenId) {
            this.checkNotBuilt();
            this.tokenId = Preconditions.checkNotNull(tokenId, "tokenId cannot be null");
            return this;
        }

        public Builder tokenId(@Nonnull @Safe String tokenId) {
            this.checkNotBuilt();
            this.tokenId = Optional.of(Preconditions.checkNotNull(tokenId, "tokenId cannot be null"));
            return this;
        }

        @JsonSetter(value="traceId", nulls=Nulls.SKIP)
        public Builder traceId(@Nonnull Optional<@Safe String> traceId) {
            this.checkNotBuilt();
            this.traceId = Preconditions.checkNotNull(traceId, "traceId cannot be null");
            return this;
        }

        public Builder traceId(@Nonnull @Safe String traceId) {
            this.checkNotBuilt();
            this.traceId = Optional.of(Preconditions.checkNotNull(traceId, "traceId cannot be null"));
            return this;
        }

        @JsonSetter(value="stacktrace", nulls=Nulls.SKIP)
        public Builder stacktrace(@Nonnull Optional<@Safe String> stacktrace) {
            this.checkNotBuilt();
            this.stacktrace = Preconditions.checkNotNull(stacktrace, "stacktrace cannot be null");
            return this;
        }

        public Builder stacktrace(@Nonnull @Safe String stacktrace) {
            this.checkNotBuilt();
            this.stacktrace = Optional.of(Preconditions.checkNotNull(stacktrace, "stacktrace cannot be null"));
            return this;
        }

        @JsonSetter(value="unsafeParams", nulls=Nulls.SKIP)
        public Builder unsafeParams(@Nonnull Map<String, Object> unsafeParams) {
            this.checkNotBuilt();
            this.unsafeParams = new LinkedHashMap<String, Object>(Preconditions.checkNotNull(unsafeParams, "unsafeParams cannot be null"));
            return this;
        }

        public Builder putAllUnsafeParams(@Nonnull Map<String, Object> unsafeParams) {
            this.checkNotBuilt();
            this.unsafeParams.putAll(Preconditions.checkNotNull(unsafeParams, "unsafeParams cannot be null"));
            return this;
        }

        public Builder unsafeParams(String key, Object value) {
            this.checkNotBuilt();
            this.unsafeParams.put(key, value);
            return this;
        }

        @JsonSetter(value="tags", nulls=Nulls.SKIP)
        public Builder tags(@Nonnull Map<String, String> tags) {
            this.checkNotBuilt();
            this.tags = new LinkedHashMap<String, String>(Preconditions.checkNotNull(tags, "tags cannot be null"));
            return this;
        }

        public Builder putAllTags(@Nonnull Map<String, String> tags) {
            this.checkNotBuilt();
            this.tags.putAll(Preconditions.checkNotNull(tags, "tags cannot be null"));
            return this;
        }

        public Builder tags(String key, String value) {
            this.checkNotBuilt();
            this.tags.put(key, value);
            return this;
        }

        public ServiceLogV1 build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new ServiceLogV1(this.level, this.time, this.origin, this.thread, this.message, this.safe, this.params, this.uid, this.sid, this.tokenId, this.traceId, this.stacktrace, this.unsafeParams, this.tags);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

