/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.logreceiver.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.palantir.conjure.java.lib.SafeLong;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ConjureCollections;
import shadow.palantir.driver.com.palantir.logreceiver.api.Annotation;
import shadow.palantir.driver.com.palantir.logreceiver.api.TraceId;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public final class Span {
    private final TraceId traceId;
    private final String id;
    private final String name;
    private final Optional<String> parentId;
    private final SafeLong timestamp;
    private final SafeLong duration;
    private final List<Annotation> annotations;
    private int memoizedHashCode;

    private Span(TraceId traceId, String id, String name, Optional<String> parentId, SafeLong timestamp, SafeLong duration, List<Annotation> annotations) {
        Span.validateFields(traceId, id, name, parentId, timestamp, duration, annotations);
        this.traceId = traceId;
        this.id = id;
        this.name = name;
        this.parentId = parentId;
        this.timestamp = timestamp;
        this.duration = duration;
        this.annotations = Collections.unmodifiableList(annotations);
    }

    @JsonProperty(value="traceId")
    public TraceId getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="id")
    @Safe
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    @Safe
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="parentId")
    @Safe
    public Optional<String> getParentId() {
        return this.parentId;
    }

    @JsonProperty(value="timestamp")
    @Safe
    public SafeLong getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="duration")
    @Safe
    public SafeLong getDuration() {
        return this.duration;
    }

    @JsonProperty(value="annotations")
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof Span && this.equalTo((Span)other);
    }

    private boolean equalTo(Span other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.traceId.equals(other.traceId) && this.id.equals(other.id) && this.name.equals(other.name) && this.parentId.equals(other.parentId) && this.timestamp.equals(other.timestamp) && this.duration.equals(other.duration) && this.annotations.equals(other.annotations);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.traceId.hashCode();
            hash = 31 * hash + this.id.hashCode();
            hash = 31 * hash + this.name.hashCode();
            hash = 31 * hash + this.parentId.hashCode();
            hash = 31 * hash + this.timestamp.hashCode();
            hash = 31 * hash + this.duration.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.annotations.hashCode());
        }
        return result;
    }

    public String toString() {
        return "Span{traceId: " + this.traceId + ", id: " + this.id + ", name: " + this.name + ", parentId: " + this.parentId + ", timestamp: " + this.timestamp + ", duration: " + this.duration + ", annotations: " + this.annotations + "}";
    }

    private static void validateFields(TraceId traceId, String id, String name, Optional<String> parentId, SafeLong timestamp, SafeLong duration, List<Annotation> annotations) {
        List<String> missingFields = null;
        missingFields = Span.addFieldIfMissing(missingFields, traceId, "traceId");
        missingFields = Span.addFieldIfMissing(missingFields, id, "id");
        missingFields = Span.addFieldIfMissing(missingFields, name, "name");
        missingFields = Span.addFieldIfMissing(missingFields, parentId, "parentId");
        missingFields = Span.addFieldIfMissing(missingFields, timestamp, "timestamp");
        missingFields = Span.addFieldIfMissing(missingFields, duration, "duration");
        if ((missingFields = Span.addFieldIfMissing(missingFields, annotations, "annotations")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(7);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        private TraceId traceId;
        @Safe
        private String id;
        @Safe
        private String name;
        private Optional<@Safe String> parentId = Optional.empty();
        @Safe
        private SafeLong timestamp;
        @Safe
        private SafeLong duration;
        private List<Annotation> annotations = new ArrayList<Annotation>();

        private Builder() {
        }

        public Builder from(Span other) {
            this.checkNotBuilt();
            this.traceId(other.getTraceId());
            this.id(other.getId());
            this.name(other.getName());
            this.parentId(other.getParentId());
            this.timestamp(other.getTimestamp());
            this.duration(other.getDuration());
            this.annotations(other.getAnnotations());
            return this;
        }

        @JsonSetter(value="traceId")
        public Builder traceId(@Nonnull TraceId traceId) {
            this.checkNotBuilt();
            this.traceId = Preconditions.checkNotNull(traceId, "traceId cannot be null");
            return this;
        }

        @JsonSetter(value="id")
        public Builder id(@Nonnull @Safe String id) {
            this.checkNotBuilt();
            this.id = Preconditions.checkNotNull(id, "id cannot be null");
            return this;
        }

        @JsonSetter(value="name")
        public Builder name(@Nonnull @Safe String name) {
            this.checkNotBuilt();
            this.name = Preconditions.checkNotNull(name, "name cannot be null");
            return this;
        }

        @JsonSetter(value="parentId", nulls=Nulls.SKIP)
        public Builder parentId(@Nonnull Optional<@Safe String> parentId) {
            this.checkNotBuilt();
            this.parentId = Preconditions.checkNotNull(parentId, "parentId cannot be null");
            return this;
        }

        public Builder parentId(@Nonnull @Safe String parentId) {
            this.checkNotBuilt();
            this.parentId = Optional.of(Preconditions.checkNotNull(parentId, "parentId cannot be null"));
            return this;
        }

        @JsonSetter(value="timestamp")
        public Builder timestamp(@Nonnull @Safe SafeLong timestamp) {
            this.checkNotBuilt();
            this.timestamp = Preconditions.checkNotNull(timestamp, "timestamp cannot be null");
            return this;
        }

        @JsonSetter(value="duration")
        public Builder duration(@Nonnull @Safe SafeLong duration) {
            this.checkNotBuilt();
            this.duration = Preconditions.checkNotNull(duration, "duration cannot be null");
            return this;
        }

        @JsonSetter(value="annotations", nulls=Nulls.SKIP)
        public Builder annotations(@Nonnull Iterable<Annotation> annotations) {
            this.checkNotBuilt();
            this.annotations = ConjureCollections.newArrayList(Preconditions.checkNotNull(annotations, "annotations cannot be null"));
            return this;
        }

        public Builder addAllAnnotations(@Nonnull Iterable<Annotation> annotations) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.annotations, Preconditions.checkNotNull(annotations, "annotations cannot be null"));
            return this;
        }

        public Builder annotations(Annotation annotations) {
            this.checkNotBuilt();
            this.annotations.add(annotations);
            return this;
        }

        public Span build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new Span(this.traceId, this.id, this.name, this.parentId, this.timestamp, this.duration, this.annotations);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

