/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.logreceiver.api;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAnyGetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAnySetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSubTypes;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.palantir.logreceiver.api.EventLogV2;
import shadow.palantir.driver.com.palantir.logreceiver.api.MetricUpdate;
import shadow.palantir.driver.com.palantir.logreceiver.api.ServiceLogV1;
import shadow.palantir.driver.com.palantir.logreceiver.api.TraceLogV1;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

public final class TelemetryPayload {
    private final Base value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private TelemetryPayload(Base value) {
        this.value = value;
    }

    @JsonValue
    private Base getValue() {
        return this.value;
    }

    public static TelemetryPayload eventLogV2(EventLogV2 value) {
        return new TelemetryPayload(new EventLogV2Wrapper(value));
    }

    public static TelemetryPayload serviceLogV1(ServiceLogV1 value) {
        return new TelemetryPayload(new ServiceLogV1Wrapper(value));
    }

    public static TelemetryPayload metricUpdate(MetricUpdate value) {
        return new TelemetryPayload(new MetricUpdateWrapper(value));
    }

    public static TelemetryPayload traceLogV1(TraceLogV1 value) {
        return new TelemetryPayload(new TraceLogV1Wrapper(value));
    }

    public static TelemetryPayload unknown(@Safe String type, Object value) {
        switch (Preconditions.checkNotNull(type, "Type is required")) {
            case "eventLogV2": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: eventLogV2", new Arg[0]);
            }
            case "serviceLogV1": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: serviceLogV1", new Arg[0]);
            }
            case "metricUpdate": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: metricUpdate", new Arg[0]);
            }
            case "traceLogV1": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: traceLogV1", new Arg[0]);
            }
        }
        return new TelemetryPayload(new UnknownWrapper(type, Collections.singletonMap(type, value)));
    }

    public <T> T accept(Visitor<T> visitor) {
        return this.value.accept(visitor);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof TelemetryPayload && this.equalTo((TelemetryPayload)other);
    }

    private boolean equalTo(TelemetryPayload other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "TelemetryPayload{value: " + this.value + "}";
    }

    private static final class UnknownWrapper
    implements Base {
        private final String type;
        private final Map<String, Object> value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private UnknownWrapper(@JsonProperty(value="type") String type) {
            this(type, new HashMap<String, Object>());
        }

        private UnknownWrapper(@Nonnull String type, @Nonnull Map<String, Object> value) {
            Preconditions.checkNotNull(type, "type cannot be null");
            Preconditions.checkNotNull(value, "value cannot be null");
            this.type = type;
            this.value = value;
        }

        @JsonProperty
        private String getType() {
            return this.type;
        }

        @JsonAnyGetter
        private Map<String, Object> getValue() {
            return this.value;
        }

        @JsonAnySetter
        private void put(String key, Object val) {
            this.value.put(key, val);
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitUnknown(this.type);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof UnknownWrapper && this.equalTo((UnknownWrapper)other);
        }

        private boolean equalTo(UnknownWrapper other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            int hash = 1;
            hash = 31 * hash + this.type.hashCode();
            hash = 31 * hash + this.value.hashCode();
            return hash;
        }

        public String toString() {
            return "UnknownWrapper{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="traceLogV1")
    private static final class TraceLogV1Wrapper
    implements Base {
        private final TraceLogV1 value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private TraceLogV1Wrapper(@JsonSetter(value="traceLogV1") @Nonnull TraceLogV1 value) {
            Preconditions.checkNotNull(value, "traceLogV1 cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "traceLogV1";
        }

        @JsonProperty(value="traceLogV1")
        private TraceLogV1 getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitTraceLogV1(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof TraceLogV1Wrapper && this.equalTo((TraceLogV1Wrapper)other);
        }

        private boolean equalTo(TraceLogV1Wrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "TraceLogV1Wrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="metricUpdate")
    private static final class MetricUpdateWrapper
    implements Base {
        private final MetricUpdate value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private MetricUpdateWrapper(@JsonSetter(value="metricUpdate") @Nonnull MetricUpdate value) {
            Preconditions.checkNotNull(value, "metricUpdate cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "metricUpdate";
        }

        @JsonProperty(value="metricUpdate")
        private MetricUpdate getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitMetricUpdate(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof MetricUpdateWrapper && this.equalTo((MetricUpdateWrapper)other);
        }

        private boolean equalTo(MetricUpdateWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "MetricUpdateWrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="serviceLogV1")
    private static final class ServiceLogV1Wrapper
    implements Base {
        private final ServiceLogV1 value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ServiceLogV1Wrapper(@JsonSetter(value="serviceLogV1") @Nonnull ServiceLogV1 value) {
            Preconditions.checkNotNull(value, "serviceLogV1 cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "serviceLogV1";
        }

        @JsonProperty(value="serviceLogV1")
        private ServiceLogV1 getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitServiceLogV1(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof ServiceLogV1Wrapper && this.equalTo((ServiceLogV1Wrapper)other);
        }

        private boolean equalTo(ServiceLogV1Wrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "ServiceLogV1Wrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="eventLogV2")
    private static final class EventLogV2Wrapper
    implements Base {
        private final EventLogV2 value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private EventLogV2Wrapper(@JsonSetter(value="eventLogV2") @Nonnull EventLogV2 value) {
            Preconditions.checkNotNull(value, "eventLogV2 cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "eventLogV2";
        }

        @JsonProperty(value="eventLogV2")
        private EventLogV2 getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitEventLogV2(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof EventLogV2Wrapper && this.equalTo((EventLogV2Wrapper)other);
        }

        private boolean equalTo(EventLogV2Wrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "EventLogV2Wrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=UnknownWrapper.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=EventLogV2Wrapper.class), @JsonSubTypes.Type(value=ServiceLogV1Wrapper.class), @JsonSubTypes.Type(value=MetricUpdateWrapper.class), @JsonSubTypes.Type(value=TraceLogV1Wrapper.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Base {
        public <T> T accept(Visitor<T> var1);
    }

    public static interface Completed_StageVisitorBuilder<T> {
        public Visitor<T> build();
    }

    public static interface UnknownStageVisitorBuilder<T> {
        public Completed_StageVisitorBuilder<T> unknown(@Nonnull Function<String, T> var1);

        public Completed_StageVisitorBuilder<T> throwOnUnknown();
    }

    public static interface TraceLogV1StageVisitorBuilder<T> {
        public UnknownStageVisitorBuilder<T> traceLogV1(@Nonnull Function<TraceLogV1, T> var1);
    }

    public static interface ServiceLogV1StageVisitorBuilder<T> {
        public TraceLogV1StageVisitorBuilder<T> serviceLogV1(@Nonnull Function<ServiceLogV1, T> var1);
    }

    public static interface MetricUpdateStageVisitorBuilder<T> {
        public ServiceLogV1StageVisitorBuilder<T> metricUpdate(@Nonnull Function<MetricUpdate, T> var1);
    }

    public static interface EventLogV2StageVisitorBuilder<T> {
        public MetricUpdateStageVisitorBuilder<T> eventLogV2(@Nonnull Function<EventLogV2, T> var1);
    }

    private static final class VisitorBuilder<T>
    implements EventLogV2StageVisitorBuilder<T>,
    MetricUpdateStageVisitorBuilder<T>,
    ServiceLogV1StageVisitorBuilder<T>,
    TraceLogV1StageVisitorBuilder<T>,
    UnknownStageVisitorBuilder<T>,
    Completed_StageVisitorBuilder<T> {
        private Function<EventLogV2, T> eventLogV2Visitor;
        private Function<MetricUpdate, T> metricUpdateVisitor;
        private Function<ServiceLogV1, T> serviceLogV1Visitor;
        private Function<TraceLogV1, T> traceLogV1Visitor;
        private Function<String, T> unknownVisitor;

        private VisitorBuilder() {
        }

        @Override
        public MetricUpdateStageVisitorBuilder<T> eventLogV2(@Nonnull Function<EventLogV2, T> eventLogV2Visitor) {
            Preconditions.checkNotNull(eventLogV2Visitor, "eventLogV2Visitor cannot be null");
            this.eventLogV2Visitor = eventLogV2Visitor;
            return this;
        }

        @Override
        public ServiceLogV1StageVisitorBuilder<T> metricUpdate(@Nonnull Function<MetricUpdate, T> metricUpdateVisitor) {
            Preconditions.checkNotNull(metricUpdateVisitor, "metricUpdateVisitor cannot be null");
            this.metricUpdateVisitor = metricUpdateVisitor;
            return this;
        }

        @Override
        public TraceLogV1StageVisitorBuilder<T> serviceLogV1(@Nonnull Function<ServiceLogV1, T> serviceLogV1Visitor) {
            Preconditions.checkNotNull(serviceLogV1Visitor, "serviceLogV1Visitor cannot be null");
            this.serviceLogV1Visitor = serviceLogV1Visitor;
            return this;
        }

        @Override
        public UnknownStageVisitorBuilder<T> traceLogV1(@Nonnull Function<TraceLogV1, T> traceLogV1Visitor) {
            Preconditions.checkNotNull(traceLogV1Visitor, "traceLogV1Visitor cannot be null");
            this.traceLogV1Visitor = traceLogV1Visitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> unknown(@Nonnull Function<String, T> unknownVisitor) {
            Preconditions.checkNotNull(unknownVisitor, "unknownVisitor cannot be null");
            this.unknownVisitor = unknownVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> throwOnUnknown() {
            this.unknownVisitor = unknownType -> {
                throw new SafeIllegalArgumentException("Unknown variant of the 'TelemetryPayload' union", SafeArg.of("unknownType", unknownType));
            };
            return this;
        }

        @Override
        public Visitor<T> build() {
            final Function<EventLogV2, T> eventLogV2Visitor = this.eventLogV2Visitor;
            final Function<MetricUpdate, T> metricUpdateVisitor = this.metricUpdateVisitor;
            final Function<ServiceLogV1, T> serviceLogV1Visitor = this.serviceLogV1Visitor;
            final Function<TraceLogV1, T> traceLogV1Visitor = this.traceLogV1Visitor;
            final Function<String, T> unknownVisitor = this.unknownVisitor;
            return new Visitor<T>(){

                @Override
                public T visitEventLogV2(EventLogV2 value) {
                    return eventLogV2Visitor.apply(value);
                }

                @Override
                public T visitMetricUpdate(MetricUpdate value) {
                    return metricUpdateVisitor.apply(value);
                }

                @Override
                public T visitServiceLogV1(ServiceLogV1 value) {
                    return serviceLogV1Visitor.apply(value);
                }

                @Override
                public T visitTraceLogV1(TraceLogV1 value) {
                    return traceLogV1Visitor.apply(value);
                }

                @Override
                public T visitUnknown(String value) {
                    return unknownVisitor.apply(value);
                }
            };
        }
    }

    public static interface Visitor<T> {
        public T visitEventLogV2(EventLogV2 var1);

        public T visitServiceLogV1(ServiceLogV1 var1);

        public T visitMetricUpdate(MetricUpdate var1);

        public T visitTraceLogV1(TraceLogV1 var1);

        public T visitUnknown(@Safe String var1);

        public static <T> EventLogV2StageVisitorBuilder<T> builder() {
            return new VisitorBuilder();
        }
    }
}

