/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.logreceiver.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Safe
public final class TokenId
implements Comparable<TokenId> {
    @Safe
    private final String value;

    private TokenId(@Nonnull @Safe String value) {
        this.value = Preconditions.checkNotNull(value, "value cannot be null");
    }

    @JsonValue
    @Safe
    public String get() {
        return this.value;
    }

    @Safe
    public String toString() {
        return this.value.toString();
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof TokenId && this.value.equals(((TokenId)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(TokenId other) {
        return this.value.compareTo(other.get());
    }

    public static TokenId valueOf(@Safe String value) {
        return TokenId.of(value);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static TokenId of(@Nonnull @Safe String value) {
        return new TokenId(value);
    }
}

