/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.logreceiver.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.palantir.logreceiver.api.Span;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public final class TraceLogV1 {
    private final OffsetDateTime time;
    private final Span span;
    private int memoizedHashCode;

    private TraceLogV1(OffsetDateTime time, Span span) {
        TraceLogV1.validateFields(time, span);
        this.time = time;
        this.span = span;
    }

    @JsonProperty(value="time")
    @Safe
    public OffsetDateTime getTime() {
        return this.time;
    }

    @JsonProperty(value="span")
    public Span getSpan() {
        return this.span;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof TraceLogV1 && this.equalTo((TraceLogV1)other);
    }

    private boolean equalTo(TraceLogV1 other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.time.isEqual(other.time) && this.span.equals(other.span);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.time.toInstant().hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.span.hashCode());
        }
        return result;
    }

    public String toString() {
        return "TraceLogV1{time: " + this.time + ", span: " + this.span + "}";
    }

    public static TraceLogV1 of(@Safe OffsetDateTime time, Span span) {
        return TraceLogV1.builder().time(time).span(span).build();
    }

    private static void validateFields(OffsetDateTime time, Span span) {
        List<String> missingFields = null;
        missingFields = TraceLogV1.addFieldIfMissing(missingFields, time, "time");
        if ((missingFields = TraceLogV1.addFieldIfMissing(missingFields, span, "span")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(2);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        @Safe
        private OffsetDateTime time;
        private Span span;

        private Builder() {
        }

        public Builder from(TraceLogV1 other) {
            this.checkNotBuilt();
            this.time(other.getTime());
            this.span(other.getSpan());
            return this;
        }

        @JsonSetter(value="time")
        public Builder time(@Nonnull @Safe OffsetDateTime time) {
            this.checkNotBuilt();
            this.time = Preconditions.checkNotNull(time, "time cannot be null");
            return this;
        }

        @JsonSetter(value="span")
        public Builder span(@Nonnull Span span) {
            this.checkNotBuilt();
            this.span = Preconditions.checkNotNull(span, "span cannot be null");
            return this;
        }

        public TraceLogV1 build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new TraceLogV1(this.time, this.span);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

