/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.logreceiver.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.palantir.logreceiver.api.TelemetryPayload;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public final class WrappedTelemetry {
    private final String entityName;
    private final String entityVersion;
    private final TelemetryPayload payload;
    private int memoizedHashCode;

    private WrappedTelemetry(String entityName, String entityVersion, TelemetryPayload payload) {
        WrappedTelemetry.validateFields(entityName, entityVersion, payload);
        this.entityName = entityName;
        this.entityVersion = entityVersion;
        this.payload = payload;
    }

    @JsonProperty(value="entityName")
    @Safe
    public String getEntityName() {
        return this.entityName;
    }

    @JsonProperty(value="entityVersion")
    @Safe
    public String getEntityVersion() {
        return this.entityVersion;
    }

    @JsonProperty(value="payload")
    public TelemetryPayload getPayload() {
        return this.payload;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof WrappedTelemetry && this.equalTo((WrappedTelemetry)other);
    }

    private boolean equalTo(WrappedTelemetry other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.entityName.equals(other.entityName) && this.entityVersion.equals(other.entityVersion) && this.payload.equals(other.payload);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.entityName.hashCode();
            hash = 31 * hash + this.entityVersion.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.payload.hashCode());
        }
        return result;
    }

    public String toString() {
        return "WrappedTelemetry{entityName: " + this.entityName + ", entityVersion: " + this.entityVersion + ", payload: " + this.payload + "}";
    }

    public static WrappedTelemetry of(@Safe String entityName, @Safe String entityVersion, TelemetryPayload payload) {
        return WrappedTelemetry.builder().entityName(entityName).entityVersion(entityVersion).payload(payload).build();
    }

    private static void validateFields(String entityName, String entityVersion, TelemetryPayload payload) {
        List<String> missingFields = null;
        missingFields = WrappedTelemetry.addFieldIfMissing(missingFields, entityName, "entityName");
        missingFields = WrappedTelemetry.addFieldIfMissing(missingFields, entityVersion, "entityVersion");
        if ((missingFields = WrappedTelemetry.addFieldIfMissing(missingFields, payload, "payload")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(3);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        @Safe
        private String entityName;
        @Safe
        private String entityVersion;
        private TelemetryPayload payload;

        private Builder() {
        }

        public Builder from(WrappedTelemetry other) {
            this.checkNotBuilt();
            this.entityName(other.getEntityName());
            this.entityVersion(other.getEntityVersion());
            this.payload(other.getPayload());
            return this;
        }

        @JsonSetter(value="entityName")
        public Builder entityName(@Nonnull @Safe String entityName) {
            this.checkNotBuilt();
            this.entityName = Preconditions.checkNotNull(entityName, "entityName cannot be null");
            return this;
        }

        @JsonSetter(value="entityVersion")
        public Builder entityVersion(@Nonnull @Safe String entityVersion) {
            this.checkNotBuilt();
            this.entityVersion = Preconditions.checkNotNull(entityVersion, "entityVersion cannot be null");
            return this;
        }

        @JsonSetter(value="payload")
        public Builder payload(@Nonnull TelemetryPayload payload) {
            this.checkNotBuilt();
            this.payload = Preconditions.checkNotNull(payload, "payload cannot be null");
            return this;
        }

        public WrappedTelemetry build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new WrappedTelemetry(this.entityName, this.entityVersion, this.payload);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

